 # ----- General Definitions -------------------------------------------------
VERSION=btcpp550


# ----- 32 bit Windows compiler options -------------------------------------
W32_CPP=bcc32
W32_LINK=ilink32
W32_LIBRARIAN=tlib
W32_RC=brc32

W32_CPP_OPTS=-c -O1 -x- -RT- -W -DZIL_WIN32  
W32_LINK_OPTS=-Tpe -aa -c -x -Lc:\bc55\lib 
W32_RC_OPTS=-w32
W32_LIB_OPTS=/C /P32

W32_OBJS=c0w32
W32_LIBS=w32_zil import32 cw32  
.cpp.ob9:
	$(W32_CPP) $(W32_CPP_OPTS) -o$*.ob9 {$< }

.rc.rbj:
	$(W32_RC) -r $(W32_RC_OPTS) -fo$*.rbj $<

# ----- Usage ------------------------------------------------------------
usage:
	@echo ...........
	@echo ...........
	@echo To generate the library modules for specific environments type:
	@echo make -f btcpp550.mak win32
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean:
	z_clean

# ----- Copy files ----------------------------------------------------------
copy:
	copy ui_*.hpp ..\include
	copy z_clean.* ..\bin

commCopy: 
	copy z_comctl.h ..\include
gfx_copy:
	copy gfx\source\gfx.h ..\include
	copy gfx\source\gfx_pro.h ..\include

bgi_copy:
	copy bgi\*.fnt ..\bin


# ----- 32 bit Windows ------------------------------------------------------

win32: copy commCopy wtest.rbj 9test.exe

9test.exe: test.ob9 w32_zil.lib
	$(W32_LINK) $(W32_LINK_OPTS) @&&!
$(W32_OBJS)+test.ob9
$*, ,$(W32_LIBS), ,wtest.rbj
!

w32_zil.lib : \
	9_bnum.ob9 \
	9_border.ob9 \
	9_button.ob9 \
	9_combo.ob9 \
	9_cursor.ob9 \
	9_dsp.ob9 \
	9_date.ob9 \
	9_error.ob9 \
	9_error1.ob9 \
	9_event.ob9 \
	9_fmtstr.ob9 \
	9_group.ob9 \
	9_hlist.ob9 \
	9_icon.ob9 \
	9_image.ob9 \
	9_int.ob9 \
	9_intl.ob9 \
	9_keybrd.ob9 \
	9_max.ob9 \
	9_min.ob9 \
	9_mouse.ob9 \
	9_notebk.ob9 \
	9_plldn.ob9 \
	9_plldn1.ob9 \
	9_popup.ob9 \
	9_popup1.ob9 \
	9_print.ob9 \
	9_prompt.ob9 \
	9_real.ob9 \
	9_sbar.ob9 \
	9_scroll.ob9 \
	9_spin.ob9 \
	9_string.ob9 \
	9_sys.ob9 \
	9_table.ob9 \
	9_table1.ob9 \
	9_table2.ob9 \
	9_tbar.ob9 \
	9_text.ob9 \
	9_time.ob9 \
	9_title.ob9 \
	9_vlist.ob9 \
	9_win.ob9 \
	9_win1.ob9 \
	9_win2.ob9 \
	z_app.ob9 \
	z_bnum.ob9 \
	z_bnum1.ob9 \
	z_bnum2.ob9 \
	z_border.ob9 \
	z_button.ob9 \
	z_combo.ob9 \
	z_cursor.ob9 \
	z_date.ob9 \
	z_date1.ob9 \
	z_decor.ob9 \
	z_device.ob9 \
	z_dialog.ob9 \
	z_dsp.ob9 \
	z_error.ob9 \
	z_error1.ob9 \
	z_event.ob9 \
	z_file.ob9 \
	z_fmtstr.ob9 \
	z_gmgr.ob9 \
	z_gmgr1.ob9 \
	z_gmgr2.ob9 \
	z_gmgr3.ob9 \
	z_group.ob9 \
	z_help.ob9 \
	z_help1.ob9 \
	z_hlist.ob9 \
	z_icon.ob9 \
	z_image.ob9 \
	z_i18n.ob9 \
	z_int.ob9 \
	z_intl.ob9 \
	z_lang.ob9 \
	z_list.ob9 \
	z_list1.ob9 \
	z_locale.ob9 \
	z_map1.ob9 \
	z_map2.ob9 \
	z_max.ob9 \
	z_min.ob9 \
	z_msgwin.ob9 \
	z_notebk.ob9 \
	z_path.ob9 \
	z_plldn.ob9 \
	z_plldn1.ob9 \
	z_popup.ob9 \
	z_popup1.ob9 \
	z_printf.ob9 \
	z_prompt.ob9 \
	z_real.ob9 \
	z_region.ob9 \
	z_sbar.ob9 \
	z_scanf.ob9 \
	z_scroll.ob9 \
	z_spin.ob9 \
	z_stdarg.ob9 \
	z_stored.ob9 \
	z_storer.ob9 \
	z_storew.ob9 \
	z_string.ob9 \
	z_sys.ob9 \
	z_table.ob9 \
	z_table1.ob9 \
	z_table2.ob9 \
	z_tbar.ob9 \
	z_text.ob9 \
	z_time.ob9 \
	z_time1.ob9 \
	z_timer.ob9 \
	z_title.ob9 \
	z_utils.ob9 \
	z_utime.ob9 \
	z_utime1.ob9 \
	z_vlist.ob9 \
	z_win.ob9 \
	z_win1.ob9 \
	z_win2.ob9 \
	z_win3.ob9 \
	z_win4.ob9 \
	g_dsp.ob9 \
	g_event.ob9 \
	g_evt.ob9 \
	g_gen.ob9 \
	g_i18n.ob9 \
	g_jump.ob9 \
	g_lang.ob9 \
	g_lang1.ob9 \
	g_loc.ob9 \
	g_loc1.ob9 \
	g_mach.ob9 \
	g_pnorm.ob9 \
	g_win.ob9 \
	i_file.ob9 \
	i_map.ob9 \
	i_str1.ob9 \
	i_str2.ob9 \
	i_str3.ob9 \
	i_str4.ob9 \
	i_str5.ob9 \
	i_type.ob9
	-@del w32_zil.lib
	$(W32_LIBRARIAN) $(W32_LIB_OPTS) @&&!
$* &
	+9_dsp.ob9 &
	+9_keybrd.ob9 &
	+9_mouse.ob9 &
	+9_notebk.ob9 &
	+9_cursor.ob9 &
	+9_event.ob9 &
	+9_bnum.ob9 &
	+9_border.ob9 &
	+9_button.ob9 &
	+9_combo.ob9 &
	+9_date.ob9 &
	+9_fmtstr.ob9 &
	+9_group.ob9 &
	+9_hlist.ob9 &
	+9_int.ob9 &
	+9_icon.ob9 &
	+9_image.ob9 &
	+9_min.ob9 &
	+9_max.ob9 &
	+9_real.ob9 &
	+9_scroll.ob9 &
	+9_string.ob9 &
	+9_sys.ob9 &
	+9_text.ob9 &
	+9_time.ob9 &
	+9_title.ob9 &
	+9_popup.ob9 &
	+9_popup1.ob9 &
	+9_plldn.ob9 &
	+9_plldn1.ob9 &
	+9_print.ob9 &
	+9_prompt.ob9 &
	+9_sbar.ob9 &
	+9_spin.ob9 &
	+9_table.ob9 &
	+9_table1.ob9 &
	+9_table2.ob9 &
	+9_tbar.ob9 &
	+9_vlist.ob9 &
	+9_win.ob9 &
	+9_win1.ob9 &
	+9_win2.ob9 &
	+9_error.ob9 &
	+9_error1.ob9 &
	+9_intl.ob9 &
	+z_app.ob9 &
	+z_bnum.ob9 &
	+z_bnum1.ob9 &
	+z_bnum2.ob9 &
	+z_border.ob9 &
	+z_button.ob9 &
	+z_combo.ob9 &
	+z_cursor.ob9 &
	+z_date.ob9 &
	+z_date1.ob9 &
	+z_decor.ob9 &
	+z_device.ob9 &
	+z_dialog.ob9 &
	+z_dsp.ob9 &
	+z_error.ob9 &
	+z_error1.ob9 &
	+z_event.ob9 &
	+z_file.ob9 &
	+z_fmtstr.ob9 &
	+z_gmgr.ob9 &
	+z_gmgr1.ob9 &
	+z_gmgr2.ob9 &
	+z_gmgr3.ob9 &
	+z_group.ob9 &
	+z_help.ob9 &
	+z_help1.ob9 &
	+z_hlist.ob9 &
	+z_icon.ob9 &
	+z_image.ob9 &
	+z_i18n.ob9 &
	+z_int.ob9 &
	+z_intl.ob9 &
	+z_lang.ob9 &
	+z_list.ob9 &
	+z_list1.ob9 &
	+z_locale.ob9 &
	+z_map1.ob9 &
	+z_map2.ob9 &
	+z_max.ob9 &
	+z_min.ob9 &
	+z_msgwin.ob9 &
	+z_notebk.ob9 &
	+z_path.ob9 &
	+z_plldn.ob9 &
	+z_plldn1.ob9 &
	+z_popup.ob9 &
	+z_popup1.ob9 &
	+z_printf.ob9 &
	+z_prompt.ob9 &
	+z_real.ob9 &
	+z_region.ob9 &
	+z_sbar.ob9 &
	+z_scanf.ob9 &
	+z_scroll.ob9 &
	+z_spin.ob9 &
	+z_stdarg.ob9 &
	+z_stored.ob9 &
	+z_storer.ob9 &
	+z_storew.ob9 &
	+z_string.ob9 &
	+z_sys.ob9 &
	+z_table.ob9 &
	+z_table1.ob9 &
	+z_table2.ob9 &
	+z_tbar.ob9 &
	+z_text.ob9 &
	+z_time.ob9 &
	+z_time1.ob9 &
	+z_timer.ob9 &
	+z_title.ob9 &
	+z_utils.ob9 &
	+z_utime.ob9 &
	+z_utime1.ob9 &
	+z_vlist.ob9 &
	+z_win.ob9 &
	+z_win1.ob9 &
	+z_win2.ob9 &
	+z_win3.ob9 &
	+z_win4.ob9 &
	+g_dsp.ob9 &
	+g_event.ob9 &
	+g_evt.ob9 &
	+g_gen.ob9 &
	+g_i18n.ob9 &
	+g_jump.ob9 &
	+g_lang.ob9 &
	+g_lang1.ob9 &
	+g_loc.ob9 &
	+g_loc1.ob9 &
	+g_mach.ob9 &
	+g_pnorm.ob9 &
	+g_win.ob9 &
	+i_file.ob9 &
	+i_map.ob9 &
	+i_str1.ob9 &
	+i_str2.ob9 &
	+i_str3.ob9 &
	+i_str4.ob9 &
	+i_str5.ob9 &
	+i_type.ob9
!
	-@del zil.sym
	-@md ..\lib\$(VERSION)
	copy w32_zil.lib ..\lib\$(VERSION)

