//	Zinc Interface Library - OEM_DIAL.CPP
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

/*       This file is a part of OpenZinc

          OpenZinc is free software; you can redistribute it and/or modify it under
          the terms of the GNU Lessor General Public License as published by
          the Free Software Foundation, either version 3 of the License, or (at
          your option) any later version

	OpenZinc is distributed in the hope that it will be useful, but WITHOUT
          ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
          or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
          General Public License for more details.

          You should have received a copy of the GNU Lessor General Public License
	 along with OpenZinc. If not, see <http://www.gnu.org/licenses/>                          */


#include "gfx.h"
#if defined(DOS386)
#	undef _far
#	define _far
#endif

static unsigned short _far oem_dial_offset_table[] =
{
	0x0000, 0x0000, 0x0009, 0x0012, 0x001B, 0x0024, 0x002D, 0x0036,
	0x003F, 0x0048, 0x0051, 0x005A, 0x0063, 0x006C, 0x0075, 0x007E,
	0x0087, 0x0090, 0x0099, 0x00A2, 0x00AB, 0x00B4, 0x00BD, 0x00C6,
	0x00CF, 0x00D8, 0x00E1, 0x00EA, 0x00F3, 0x00FC, 0x0105, 0x010E,
	0x0117, 0x011E, 0x0121, 0x0127, 0x012F, 0x0136, 0x013E, 0x0148,
	0x014C, 0x0151, 0x0156, 0x015F, 0x0166, 0x016B, 0x0172, 0x0176,
	0x017F, 0x0187, 0x018E, 0x0196, 0x019E, 0x01A6, 0x01AE, 0x01B6,
	0x01BE, 0x01C6, 0x01CE, 0x01D1, 0x01D4, 0x01DB, 0x01E2, 0x01E9,
	0x01F0, 0x01F8, 0x0200, 0x0208, 0x0210, 0x0218, 0x021F, 0x0226,
	0x022E, 0x0236, 0x0239, 0x0240, 0x0248, 0x024F, 0x0258, 0x0260,
	0x0268, 0x0270, 0x027A, 0x0282, 0x028A, 0x0293, 0x029B, 0x02A4,
	0x02AD, 0x02B6, 0x02BF, 0x02C8, 0x02CD, 0x02D6, 0x02DB, 0x02E2,
	0x02EA, 0x02EE, 0x02F5, 0x02FC, 0x0303, 0x030A, 0x0311, 0x0317,
	0x031E, 0x0325, 0x0328, 0x032E, 0x0335, 0x0338, 0x0341, 0x0348,
	0x034F, 0x0356, 0x035D, 0x0364, 0x036B, 0x0370, 0x0377, 0x037E,
	0x0389, 0x038F, 0x0396, 0x039C, 0x03A2, 0x03A5, 0x03AB, 0x03B3,
	0x03BC, 0x03C4, 0x03CB, 0x03D2, 0x03D9, 0x03E0, 0x03E7, 0x03EE,
	0x03F6, 0x03FD, 0x0404, 0x040B, 0x0412, 0x0419, 0x041E, 0x0426,
	0x042E, 0x0435, 0x0440, 0x044C, 0x0453, 0x045A, 0x0461, 0x0468,
	0x046F, 0x0476, 0x047E, 0x0486, 0x048F, 0x0498, 0x04A1, 0x04A9,
	0x04B2, 0x04B9, 0x04BE, 0x04C5, 0x04CC, 0x04D4, 0x04DC, 0x04E3,
	0x04EA, 0x04F1, 0x04F7, 0x04FD, 0x0508, 0x0513, 0x0516, 0x051E,
	0x0526, 0x0528, 0x052A, 0x052C, 0x052E, 0x0530, 0x0532, 0x0534,
	0x0536, 0x0538, 0x053A, 0x053C, 0x053E, 0x0540, 0x0542, 0x0544,
	0x0546, 0x0548, 0x054A, 0x054C, 0x054E, 0x0550, 0x0552, 0x0554,
	0x0556, 0x0558, 0x055A, 0x055C, 0x055E, 0x0560, 0x0562, 0x0564,
	0x0566, 0x0568, 0x056A, 0x056C, 0x056E, 0x0570, 0x0572, 0x0574,
	0x0576, 0x0578, 0x057A, 0x057C, 0x057E, 0x0580, 0x0582, 0x0584,
	0x0586, 0x058F, 0x0597, 0x059F, 0x05A8, 0x05B1, 0x05BA, 0x05C2,
	0x05CB, 0x05D4, 0x05DC, 0x05E6, 0x05ED, 0x05F8, 0x0600, 0x0607,
	0x060F, 0x0617, 0x0620, 0x0627, 0x062E, 0x0635, 0x063C, 0x0642,
	0x064A, 0x0651, 0x0655, 0x0659, 0x0664, 0x066B, 0x0671, 0x0676,
	0x0678
};


static unsigned char _far oem_dial_data_table[] =
{

	// Scan Line #1.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x0C, 0x00, 0x60, 0x70, 0x00, 0xC0, 0x06, 0x00, 0x0C, 0x63,
	0x18, 0xE0, 0x60, 0x00, 0x00, 0x03, 0x00, 0x18, 0x18, 0x60, 0x03, 0x1B,
	0x18, 0x60, 0x00, 0x00, 0x7C, 0x00, 0x06, 0x18, 0x60, 0xC0, 0x07, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,

	// Scan Line #2.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x6C, 0xD8, 0x60, 0x00, 0xE0, 0x63, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xF8, 0x61, 0xF1, 0xF0, 0x33, 0xF9, 0xF3, 0xF9, 0xF1, 0xF0, 0x00, 0xC0,
	0x30, 0x3C, 0x7C, 0x38, 0xFC, 0x7C, 0xF8, 0xFD, 0xF9, 0xF3, 0x1B, 0x06,
	0xC6, 0xC1, 0x86, 0xC6, 0x7C, 0xFC, 0x7C, 0x3F, 0x1F, 0x3F, 0xD8, 0xD8,
	0x6C, 0x36, 0x1B, 0x0D, 0xFE, 0xF0, 0x03, 0xC0, 0x00, 0x30, 0x06, 0x00,
	0x01, 0x80, 0x00, 0x03, 0x06, 0x1B, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xB7, 0x00, 0x00, 0x07,
	0xCC, 0xC6, 0x1E, 0x66, 0x30, 0xD8, 0x01, 0xE6, 0x63, 0x19, 0x9E, 0x33,
	0x19, 0xB0, 0xC0, 0x00, 0x3F, 0xE7, 0x99, 0x8C, 0x3C, 0x31, 0x9B, 0x1B,
	0x18, 0x60, 0x78, 0xC3, 0x66, 0x07, 0x0C, 0x30, 0xC1, 0x87, 0x6D, 0xC7,
	0x8F, 0x0C, 0x00, 0x03, 0x00, 0x60, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC,
	0x00, 0xFF, 0x00, 0x00, 0x00, 0x1F, 0xE7, 0xC7, 0xF1, 0xF0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0x8F, 0x00,

	// Scan Line #3.
	0x7E, 0x3F, 0x0D, 0x81, 0x01, 0x80, 0xC0, 0x01, 0xFE, 0x00, 0x7F, 0x8F,
	0xC7, 0x81, 0xF1, 0xF8, 0x60, 0x80, 0x01, 0x0C, 0x19, 0x8F, 0xE3, 0xE0,
	0x00, 0x60, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC3, 0xFC, 0x03,
	0x6C, 0xD8, 0x63, 0x81, 0xB0, 0x66, 0x30, 0x00, 0x00, 0x00, 0x00, 0x0D,
	0x8C, 0xE3, 0x1B, 0x18, 0x73, 0x03, 0x1B, 0x1B, 0x1B, 0x18, 0x01, 0x80,
	0x18, 0x66, 0xC6, 0x6C, 0xC6, 0xC6, 0xCC, 0xC1, 0x83, 0x1B, 0x1B, 0x06,
	0xCC, 0xC1, 0xCE, 0xE6, 0xC6, 0xC6, 0xC6, 0x31, 0xB1, 0x86, 0x18, 0xD8,
	0x6C, 0x36, 0x1B, 0x0C, 0x06, 0xC6, 0x00, 0xC6, 0x00, 0x30, 0x06, 0x00,
	0x01, 0x80, 0x18, 0x03, 0x06, 0x1B, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x31, 0x8E, 0xC0, 0x0C,
	0x6C, 0xCC, 0x33, 0x66, 0x18, 0x70, 0x03, 0x36, 0x61, 0x99, 0xB3, 0x18,
	0x00, 0xE0, 0x00, 0x00, 0x6E, 0x0C, 0xD9, 0x86, 0x66, 0x19, 0x98, 0x00,
	0x01, 0xF8, 0xCC, 0xC3, 0x66, 0x0D, 0x98, 0x61, 0x83, 0x0D, 0xC0, 0x00,
	0xD9, 0x8C, 0x00, 0x03, 0x18, 0x63, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x8C,
	0x00, 0x63, 0x00, 0x00, 0x00, 0x03, 0x0C, 0x6C, 0x1B, 0x00, 0x00, 0x06,
	0x3C, 0xF8, 0x00, 0x30, 0xC0, 0x1B, 0x30, 0x67, 0x00, 0x1E, 0x00, 0x01,
	0xEC, 0xDB, 0x00,

	// Scan Line #4.
	0xA5, 0x6D, 0x9F, 0xC3, 0x83, 0xC1, 0xE0, 0x01, 0xFE, 0x3C, 0x61, 0x83,
	0x4C, 0xC1, 0xB1, 0x99, 0x68, 0xE0, 0x07, 0x1E, 0x19, 0x9B, 0x66, 0x10,
	0x00, 0xF0, 0x78, 0x18, 0x02, 0x08, 0x00, 0x02, 0x41, 0xE1, 0xF8, 0x03,
	0x6C, 0xD8, 0xF3, 0x99, 0xB0, 0x6C, 0x19, 0x98, 0x60, 0x00, 0x00, 0x19,
	0x9D, 0xE0, 0x18, 0x18, 0xF3, 0x03, 0x00, 0x1B, 0x1B, 0x1B, 0x03, 0x00,
	0x0C, 0x66, 0xC6, 0xC6, 0xC6, 0xC0, 0xC6, 0xC1, 0x83, 0x03, 0x1B, 0x06,
	0xD8, 0xC1, 0xFE, 0xE6, 0xC6, 0xC6, 0xC6, 0x31, 0xB0, 0x06, 0x18, 0xD8,
	0x6C, 0x33, 0x31, 0x98, 0x0C, 0xC3, 0x00, 0xCF, 0x00, 0x30, 0x06, 0x00,
	0x01, 0x80, 0x3C, 0x03, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x31, 0x9B, 0x80, 0x0C,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xE0, 0xE3, 0xF0, 0x00, 0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF3,
	0x1B, 0x6C, 0xC0, 0x66, 0x66, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x67,
	0xD9, 0x80, 0x00, 0x03, 0x30, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF9, 0x8C,
	0x00, 0x30, 0x00, 0x00, 0x00, 0x0F, 0xCC, 0x6C, 0x19, 0x80, 0x00, 0x7C,
	0x61, 0x8D, 0xFC, 0x30, 0x70, 0x73, 0x00, 0x67, 0x1D, 0xB3, 0x00, 0x03,
	0x0C, 0xC6, 0x00,

	// Scan Line #5.
	0xA5, 0x6D, 0x9F, 0xC7, 0xC3, 0xC3, 0xF0, 0x61, 0xFE, 0x7E, 0x4C, 0x86,
	0x4C, 0xC1, 0xF1, 0xF8, 0xF0, 0xF8, 0x1F, 0x3F, 0x19, 0x9B, 0x63, 0xC0,
	0x01, 0xF8, 0xFC, 0x18, 0x03, 0x18, 0x18, 0x06, 0x61, 0xE1, 0xF8, 0x03,
	0x01, 0xFD, 0x98, 0x30, 0xE0, 0xCC, 0x18, 0xF0, 0x60, 0x00, 0x00, 0x31,
	0xBC, 0x60, 0x30, 0x19, 0xB3, 0xF3, 0x00, 0x33, 0x1B, 0x1B, 0x66, 0x1F,
	0x86, 0x0C, 0xDE, 0xC6, 0xC6, 0xC0, 0xC6, 0xC1, 0x83, 0x03, 0x1B, 0x06,
	0xF0, 0xC1, 0xB6, 0xF6, 0xC6, 0xC6, 0xC6, 0x31, 0xB0, 0x06, 0x18, 0xD8,
	0x6C, 0x31, 0xE0, 0xF0, 0x18, 0xC1, 0x80, 0xD9, 0x80, 0x19, 0xE7, 0xC7,
	0xCF, 0x9E, 0x30, 0xFB, 0xE6, 0x1B, 0x66, 0xFE, 0x7C, 0x79, 0xF1, 0xF7,
	0xC7, 0xDE, 0xCD, 0x9B, 0x33, 0x6D, 0x9B, 0xE6, 0x31, 0x80, 0x03, 0x0C,
	0x0C, 0xCF, 0x1E, 0x3C, 0x78, 0xF3, 0x19, 0xE3, 0xC7, 0x86, 0x0C, 0x31,
	0xB1, 0xB3, 0x03, 0xFC, 0xC6, 0x07, 0x8F, 0x1E, 0x66, 0xCD, 0x9B, 0x1B,
	0x1B, 0x60, 0xC0, 0x3C, 0x7C, 0x0C, 0x1E, 0x31, 0xE6, 0x6F, 0x8E, 0x6C,
	0xD9, 0x8C, 0x00, 0x03, 0x60, 0x6D, 0x98, 0xDB, 0x60, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xCD, 0x8D, 0x81,
	0xFE, 0x18, 0x3F, 0x99, 0x9F, 0xD8, 0x6C, 0x6C, 0x18, 0xC3, 0xFC, 0xCE,
	0xC1, 0x8C, 0x01, 0xFE, 0x1D, 0xC3, 0x00, 0x60, 0x37, 0x33, 0x00, 0x03,
	0x0C, 0xCC, 0x00,

	// Scan Line #6.
	0x81, 0x7F, 0x9F, 0xCF, 0xEF, 0xF7, 0xF8, 0xF1, 0xCE, 0x66, 0x5E, 0x9F,
	0x0C, 0xC1, 0x81, 0x9B, 0x9C, 0xFE, 0x7F, 0x0C, 0x19, 0x9B, 0x66, 0x60,
	0x00, 0x60, 0x30, 0x18, 0x7F, 0xBF, 0xD8, 0x0F, 0xF3, 0xF0, 0xF0, 0x03,
	0x00, 0xD9, 0x80, 0x61, 0xEC, 0x0C, 0x1B, 0xFD, 0xF8, 0x1F, 0x80, 0x61,
	0xEC, 0x60, 0x60, 0xF3, 0x30, 0x1B, 0xF0, 0x61, 0xF1, 0xF8, 0x6C, 0x00,
	0x03, 0x18, 0xDE, 0xFE, 0xFC, 0xC0, 0xC6, 0xF9, 0xF3, 0x3B, 0xFB, 0x06,
	0xE0, 0xC1, 0x86, 0xDE, 0xC6, 0xFC, 0xC6, 0x3F, 0x1F, 0x06, 0x18, 0xD8,
	0x6C, 0x30, 0xC0, 0x60, 0x30, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x36, 0x6C,
	0x19, 0xB3, 0x79, 0x9B, 0x36, 0x1B, 0xC6, 0xDB, 0x66, 0xCD, 0x9B, 0x36,
	0x6C, 0x0C, 0xCD, 0x9B, 0x33, 0x6D, 0x98, 0x6C, 0x00, 0xC0, 0x07, 0x8C,
	0x0C, 0xD9, 0x83, 0x06, 0x0C, 0x1B, 0x03, 0x36, 0x6C, 0xC6, 0x0C, 0x33,
	0x1B, 0x1B, 0x00, 0x66, 0xFF, 0xCC, 0xD9, 0xB3, 0x66, 0xCD, 0x9B, 0x1B,
	0x1B, 0x61, 0xF0, 0x7E, 0x66, 0x1E, 0x03, 0x33, 0x36, 0x6C, 0xCF, 0x6C,
	0xD9, 0x8C, 0x00, 0x03, 0xDE, 0x7B, 0x99, 0xB1, 0xB0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x79, 0xF9, 0x80,
	0xCC, 0x0C, 0x66, 0x19, 0xB6, 0x18, 0x6F, 0xEC, 0x19, 0xE6, 0x66, 0xDE,
	0xF9, 0x8D, 0xFC, 0x30, 0x38, 0xE3, 0x00, 0x6F, 0x80, 0x1E, 0x00, 0x06,
	0x0C, 0xDF, 0x78,

	// Scan Line #7.
	0xBD, 0x7F, 0x9F, 0xC7, 0xCF, 0xF7, 0xF8, 0xF1, 0xCE, 0x66, 0x5E, 0xB1,
	0x87, 0x81, 0x81, 0x9B, 0x9C, 0xFC, 0x3F, 0x0C, 0x19, 0x8F, 0x66, 0x60,
	0x01, 0xF8, 0x30, 0x18, 0x7F, 0xBF, 0xD8, 0x0F, 0xF3, 0xF0, 0xF0, 0x03,
	0x01, 0xFC, 0xF0, 0xC3, 0x38, 0x0C, 0x18, 0xF0, 0x60, 0x00, 0x00, 0xC1,
	0xCC, 0x60, 0xC0, 0x1B, 0xF8, 0x1B, 0x18, 0xC3, 0x18, 0x18, 0x06, 0x1F,
	0x86, 0x18, 0xDC, 0xC6, 0xC6, 0xC0, 0xC6, 0xC1, 0x83, 0x1B, 0x1B, 0x06,
	0xF0, 0xC1, 0x86, 0xDE, 0xC6, 0xC0, 0xCE, 0x33, 0x01, 0x86, 0x18, 0xD8,
	0x6D, 0xB1, 0xE0, 0x60, 0x60, 0xC0, 0x60, 0xC0, 0x00, 0x01, 0xF6, 0x6C,
	0x19, 0xBF, 0x31, 0x9B, 0x36, 0x1B, 0x86, 0xDB, 0x66, 0xCD, 0x9B, 0x36,
	0x07, 0x8C, 0xCD, 0x9B, 0x33, 0x39, 0x98, 0xC6, 0x31, 0x80, 0x0C, 0xCC,
	0x0C, 0xDF, 0x9F, 0x3E, 0x7C, 0xFB, 0x03, 0xF7, 0xEF, 0xC6, 0x0C, 0x33,
	0x1B, 0x1B, 0xE3, 0xFE, 0xC6, 0x0C, 0xD9, 0xB3, 0x66, 0xCD, 0x9B, 0x1B,
	0x1B, 0x6C, 0xC0, 0x18, 0x6F, 0x0C, 0x1F, 0x33, 0x36, 0x6C, 0xCD, 0xE7,
	0xCF, 0x18, 0x00, 0x01, 0xB6, 0x37, 0x9B, 0x60, 0xD8, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x31, 0x8D, 0x80,
	0xCC, 0x18, 0x66, 0x19, 0xB6, 0x18, 0x6C, 0x66, 0x33, 0x36, 0x66, 0xF6,
	0xC1, 0x8C, 0x00, 0x30, 0xE0, 0x3B, 0x00, 0x60, 0x1D, 0x80, 0x00, 0x06,
	0x00, 0x00, 0x78,

	// Scan Line #8.
	0x99, 0x61, 0x8F, 0x83, 0x8D, 0xB3, 0xF0, 0x61, 0xFE, 0x7E, 0x4C, 0xB1,
	0x83, 0x07, 0x83, 0xB8, 0xF0, 0xF0, 0x0F, 0x3F, 0x00, 0x03, 0x63, 0xC7,
	0xF8, 0xF0, 0x30, 0x7E, 0x03, 0x18, 0x1F, 0xE6, 0x67, 0xF8, 0x60, 0x00,
	0x00, 0xD8, 0x19, 0x83, 0x18, 0x0C, 0x19, 0x98, 0x60, 0x00, 0x01, 0x81,
	0x8C, 0x61, 0x80, 0x18, 0x30, 0x1B, 0x18, 0xC3, 0x18, 0x1B, 0x03, 0x00,
	0x0C, 0x00, 0xC0, 0xC6, 0xC6, 0xC0, 0xC6, 0xC1, 0x83, 0x1B, 0x1B, 0x66,
	0xD8, 0xC1, 0x86, 0xCE, 0xC6, 0xC0, 0xC6, 0x31, 0x81, 0x86, 0x18, 0xCC,
	0xCF, 0xF3, 0x30, 0x60, 0xC0, 0xC0, 0x30, 0xC0, 0x00, 0x03, 0x36, 0x6C,
	0x19, 0xB0, 0x31, 0x9B, 0x36, 0x1B, 0xC6, 0xDB, 0x66, 0xCD, 0x9B, 0x36,
	0x00, 0xCC, 0xCD, 0x9B, 0x33, 0x39, 0x99, 0x86, 0x31, 0x80, 0x18, 0x6C,
	0x6C, 0xD8, 0x33, 0x66, 0xCD, 0x9B, 0x1B, 0x06, 0x0C, 0x06, 0x0C, 0x33,
	0xFB, 0xFB, 0x06, 0x60, 0xC6, 0x0C, 0xD9, 0xB3, 0x66, 0xCD, 0x9B, 0x1B,
	0x19, 0xF8, 0xC0, 0x7E, 0x66, 0x0C, 0x33, 0x33, 0x36, 0x6C, 0xCD, 0xE0,
	0x00, 0x33, 0x7D, 0xF3, 0x0C, 0x6F, 0xD9, 0xB1, 0xB0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x31, 0x8D, 0x80,
	0xCC, 0x30, 0x66, 0x19, 0x86, 0x0F, 0xCC, 0x66, 0x33, 0x36, 0x66, 0xE6,
	0x61, 0x8D, 0xFC, 0x00, 0x00, 0x03, 0x00, 0x67, 0x37, 0x00, 0x70, 0x6C,
	0x00, 0x00, 0x78,

	// Scan Line #9.
	0x81, 0x73, 0x87, 0x01, 0x01, 0x80, 0xC0, 0x01, 0xFE, 0x3C, 0x61, 0xB1,
	0x8F, 0xCF, 0x87, 0xB9, 0x68, 0xC0, 0x03, 0x1E, 0x19, 0x83, 0x68, 0x67,
	0xF8, 0x60, 0x30, 0x3C, 0x02, 0x08, 0x00, 0x02, 0x47, 0xF8, 0x60, 0x03,
	0x00, 0xD9, 0x9B, 0x3B, 0x1C, 0x06, 0x30, 0x00, 0x01, 0xC0, 0x3B, 0x01,
	0x8C, 0x63, 0x1B, 0x18, 0x33, 0x1B, 0x18, 0xC3, 0x1B, 0x1B, 0x61, 0x80,
	0x18, 0x18, 0xC0, 0xC6, 0xC6, 0xC6, 0xCC, 0xC1, 0x83, 0x1B, 0x1B, 0x66,
	0xCC, 0xC1, 0x86, 0xCE, 0xC6, 0xC0, 0xC7, 0x31, 0xB1, 0x86, 0x18, 0xC7,
	0x8E, 0x76, 0x18, 0x61, 0x80, 0xC0, 0x18, 0xC0, 0x00, 0x03, 0x36, 0x6C,
	0x19, 0xB3, 0x31, 0x9B, 0x36, 0x1B, 0x66, 0xDB, 0x66, 0xCD, 0x9B, 0x36,
	0x00, 0xCC, 0xCC, 0xF1, 0xFE, 0x6D, 0x9B, 0x06, 0x31, 0x80, 0x18, 0x67,
	0xCC, 0xD9, 0xB3, 0x66, 0xCD, 0x99, 0xF3, 0x36, 0x6C, 0xC6, 0x0C, 0x33,
	0x1B, 0x1B, 0x06, 0x66, 0xC6, 0x0C, 0xD9, 0xB3, 0x66, 0xCD, 0x9B, 0x1B,
	0x18, 0x60, 0xC6, 0x18, 0x66, 0x0C, 0x33, 0x33, 0x36, 0x6C, 0xCC, 0xEF,
	0xDF, 0xB3, 0x40, 0x16, 0x18, 0xC1, 0x98, 0xDB, 0x60, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x79, 0xF9, 0x80,
	0xCC, 0x63, 0x66, 0x1F, 0x06, 0x03, 0x0C, 0x63, 0x63, 0x33, 0xFC, 0x7C,
	0x3D, 0x8C, 0x01, 0xFE, 0xFD, 0xFB, 0x00, 0x67, 0x00, 0x00, 0x77, 0x3C,
	0x00, 0x00, 0x78,

	// Scan Line #10.
	0x7E, 0x3F, 0x02, 0x00, 0x03, 0xC1, 0xE0, 0x01, 0xFE, 0x00, 0x7F, 0x9F,
	0x03, 0x07, 0x03, 0x80, 0x60, 0x00, 0x00, 0x0C, 0x19, 0x83, 0x67, 0xC7,
	0xFB, 0xFC, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x00, 0xD8, 0xF0, 0x39, 0xF6, 0x03, 0x60, 0x00, 0x01, 0xC0, 0x38, 0x00,
	0xF9, 0xFB, 0xF9, 0xF0, 0x79, 0xF1, 0xF0, 0xC1, 0xF1, 0xF0, 0x60, 0xC0,
	0x30, 0x18, 0x7E, 0xC6, 0xFC, 0x7C, 0xF8, 0xFD, 0x81, 0xF3, 0x1B, 0x3C,
	0xC6, 0xFD, 0x86, 0xC6, 0x7C, 0xC0, 0x7D, 0xB1, 0x9F, 0x06, 0x0F, 0x83,
	0x0C, 0x36, 0x18, 0x61, 0xFE, 0xF0, 0x03, 0xC0, 0x00, 0x01, 0xF7, 0xC7,
	0xCF, 0x9E, 0x30, 0xFB, 0x36, 0x1B, 0x36, 0xDB, 0x66, 0x79, 0xF1, 0xF6,
	0x0F, 0x8C, 0x7C, 0x60, 0xCC, 0x6C, 0xFB, 0xE3, 0xB7, 0x00, 0x1F, 0xE1,
	0x87, 0xCF, 0x1F, 0x3E, 0x7C, 0xF8, 0x61, 0xE3, 0xC7, 0x86, 0x0C, 0x33,
	0x1B, 0x1B, 0xF3, 0xFC, 0xC7, 0xE7, 0x8F, 0x1E, 0x3E, 0x7C, 0xF9, 0xF1,
	0xF0, 0x61, 0xFC, 0x18, 0x63, 0x0C, 0x1F, 0x31, 0xE3, 0xEC, 0xCC, 0x60,
	0x00, 0x1E, 0x40, 0x10, 0x3E, 0x01, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xCD, 0x81, 0x80,
	0xCC, 0xFF, 0x3C, 0x18, 0x06, 0x1F, 0xE7, 0xCF, 0x79, 0xE0, 0x00, 0xC0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x60, 0x00, 0x00, 0x77, 0x18,
	0x00, 0x00, 0x78,

	// Scan Line #11.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x01, 0x80, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x0C,
	0xC0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00,
	0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x06, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,

	// Scan Line #12.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0xF0, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x01, 0x80, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x07,
	0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00
};


static FONT oem_dial =
{
	oem_dial_offset_table,
	oem_dial_data_table,

	207,		// The number of bytes in each row of the bitmap.
	 12,		// The number of rows in the bitmap.
	  0,		// The first character in the bitmap.
	255,		// The last character in the bitmap.
	 12,		// The widest character, in bits.
	  9,		// The distance from the baseline to the top of a character.
	 10,		// The distance from the top to the underline bar.
	  0 		// The flag for a ROM resident font.
};

FONT *GFX_oem_dial_font (void)
{
	return (&oem_dial);
}
