//	Zinc Interface Library - ISO_SYST.CPP
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

/*       This file is a part of OpenZinc

          OpenZinc is free software; you can redistribute it and/or modify it under
          the terms of the GNU Lessor General Public License as published by
          the Free Software Foundation, either version 3 of the License, or (at
          your option) any later version

	OpenZinc is distributed in the hope that it will be useful, but WITHOUT
          ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
          or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
          General Public License for more details.

          You should have received a copy of the GNU Lessor General Public License
	 along with OpenZinc. If not, see <http://www.gnu.org/licenses/>                          */


#include "gfx.h"
#if defined(DOS386)
#	undef _far
#	define _far
#endif

static unsigned short _far iso_syst_offset_table[] =
{
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0007, 0x000A, 0x0010, 0x0018, 0x001F, 0x0027, 0x0031,
	0x0035, 0x003A, 0x003F, 0x0048, 0x004F, 0x0054, 0x005B, 0x005F,
	0x0069, 0x0071, 0x0078, 0x0080, 0x0088, 0x0090, 0x0098, 0x00A0,
	0x00A8, 0x00B0, 0x00B8, 0x00BB, 0x00BE, 0x00C5, 0x00CC, 0x00D3,
	0x00DA, 0x00E2, 0x00EA, 0x00F2, 0x00FA, 0x0102, 0x0109, 0x0110,
	0x0118, 0x0120, 0x0123, 0x012A, 0x0133, 0x013A, 0x0143, 0x014B,
	0x0153, 0x015B, 0x0165, 0x016D, 0x0175, 0x017E, 0x0186, 0x018F,
	0x0198, 0x01A1, 0x01AA, 0x01B3, 0x01B8, 0x01C2, 0x01C7, 0x01CE,
	0x01D6, 0x01DA, 0x01E1, 0x01E8, 0x01EF, 0x01F6, 0x01FD, 0x0203,
	0x020A, 0x0211, 0x0214, 0x021A, 0x0221, 0x0224, 0x022D, 0x0234,
	0x023B, 0x0242, 0x0249, 0x0250, 0x0257, 0x025C, 0x0263, 0x026A,
	0x0275, 0x027B, 0x0282, 0x0288, 0x028E, 0x0291, 0x0297, 0x029F,
	0x02A8, 0x02A8, 0x02A8, 0x02A8, 0x02A8, 0x02A8, 0x02A8, 0x02A8,
	0x02A8, 0x02A8, 0x02A8, 0x02A8, 0x02A8, 0x02A8, 0x02A8, 0x02A8,
	0x02A8, 0x02AA, 0x02AA, 0x02AA, 0x02AA, 0x02AA, 0x02AA, 0x02AA,
	0x02AA, 0x02AA, 0x02AA, 0x02AA, 0x02AA, 0x02AA, 0x02AA, 0x02AA,
	0x02AA, 0x02B1, 0x02B4, 0x02BD, 0x02C6, 0x02CF, 0x02D8, 0x02DB,
	0x02E3, 0x02EA, 0x02F6, 0x02FD, 0x0305, 0x030D, 0x0314, 0x0320,
	0x0327, 0x032E, 0x0337, 0x033D, 0x0343, 0x0347, 0x034F, 0x0358,
	0x035C, 0x0363, 0x0368, 0x036F, 0x0377, 0x0382, 0x038D, 0x0399,
	0x03A0, 0x03A8, 0x03B0, 0x03B8, 0x03C0, 0x03C8, 0x03D0, 0x03DC,
	0x03E4, 0x03EB, 0x03F2, 0x03F9, 0x0400, 0x0404, 0x0408, 0x040E,
	0x0414, 0x041D, 0x0425, 0x042D, 0x0435, 0x043D, 0x0445, 0x044D,
	0x0455, 0x045F, 0x0467, 0x046F, 0x0477, 0x047F, 0x0488, 0x0491,
	0x0499, 0x04A0, 0x04A7, 0x04AE, 0x04B6, 0x04BD, 0x04C4, 0x04CF,
	0x04D7, 0x04DE, 0x04E5, 0x04EC, 0x04F3, 0x04F8, 0x04FD, 0x0504,
	0x050B, 0x0512, 0x051A, 0x0521, 0x0528, 0x052F, 0x0537, 0x053E,
	0x0544, 0x054C, 0x0553, 0x055A, 0x0561, 0x0568, 0x056F, 0x0577,
	0x057E
};


static unsigned char _far iso_syst_data_table[] =
{

	// Scan Line #1.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	// Scan Line #2.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0xF3, 0x80, 0x00, 0x00, 0x00,
	0x0C, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x30, 0x18, 0x38, 0x76,
	0x6C, 0x38, 0x00, 0x00, 0x06, 0x03, 0x1C, 0x6C, 0xC6, 0x73, 0x60, 0x03,
	0xB3, 0x00, 0xC1, 0xC3, 0xB3, 0x60, 0x00, 0x00, 0xC0, 0x30, 0x70, 0xD8,
	0x18, 0x00, 0x00, 0x30, 0x18, 0x60, 0x00, 0x03, 0x80, 0x00, 0x00, 0xC0,
	0x61, 0x80, 0x18, 0x31, 0x80, 0x00, 0x00, 0x18, 0x0C, 0x30, 0x00, 0x00,
	0x00, 0x06, 0x03, 0x0C, 0x00, 0x00, 0x00, 0x00,

	// Scan Line #3.
	0x01, 0xB6, 0x6C, 0x30, 0x00, 0x70, 0x31, 0xB0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3E, 0x18, 0x7C, 0x7C, 0x0C, 0xFE, 0x7C, 0xFE, 0x7C, 0x7C, 0x00,
	0x30, 0x0C, 0x0F, 0x1F, 0x0E, 0x3F, 0x1F, 0x3E, 0x3F, 0x7E, 0x7C, 0xC6,
	0xC1, 0xB1, 0x98, 0x30, 0xD8, 0xCF, 0x9F, 0x8F, 0x87, 0xE3, 0xE7, 0xFB,
	0x1B, 0x0D, 0x86, 0xC3, 0x61, 0xBF, 0xDE, 0x00, 0x3C, 0x00, 0x03, 0x00,
	0x60, 0x00, 0x18, 0x00, 0x00, 0x30, 0x61, 0xB0, 0x60, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3B, 0x70, 0x00,
	0x00, 0x80, 0x60, 0x31, 0xE0, 0x01, 0x86, 0xC7, 0x8D, 0x80, 0x01, 0xE0,
	0x00, 0x00, 0x00, 0x00, 0xFD, 0x98, 0x01, 0xB6, 0xCC, 0x00, 0x00, 0x00,
	0x1C, 0x78, 0x00, 0xC0, 0x18, 0x06, 0xC0, 0x18, 0x18, 0x30, 0x6C, 0xDC,
	0x6C, 0x6C, 0x3F, 0xE7, 0xC3, 0x06, 0x36, 0x6C, 0x6C, 0xDB, 0x67, 0xC6,
	0xE1, 0x81, 0x83, 0x66, 0xE3, 0x60, 0x00, 0x00, 0x60, 0x60, 0xD8, 0xD8,
	0x30, 0xF0, 0x00, 0x18, 0x30, 0xF1, 0xDB, 0x36, 0xC0, 0x00, 0x00, 0x60,
	0xC3, 0xCC, 0xCC, 0x63, 0xCC, 0xCF, 0x9D, 0x8C, 0x18, 0x78, 0xED, 0x98,
	0x00, 0x03, 0x06, 0x1E, 0x66, 0x18, 0x01, 0x98,

	// Scan Line #4.
	0x01, 0xB6, 0x6C, 0x30, 0x00, 0xD8, 0x33, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x63, 0x38, 0xC6, 0xC6, 0x1C, 0xC0, 0xC6, 0xC6, 0xC6, 0xC6, 0x00,
	0x60, 0x06, 0x19, 0xB1, 0x9B, 0x31, 0xB1, 0xB3, 0x30, 0x60, 0xC6, 0xC6,
	0xC1, 0xB3, 0x18, 0x39, 0xDC, 0xD8, 0xD8, 0xD8, 0xC6, 0x36, 0x30, 0xC3,
	0x1B, 0x0D, 0x86, 0xC3, 0x61, 0x80, 0xD8, 0xC0, 0x0C, 0x60, 0x03, 0x00,
	0x60, 0x00, 0x18, 0x01, 0x80, 0x30, 0x61, 0xB0, 0x60, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x18, 0xEC,
	0x00, 0x80, 0x60, 0x63, 0x30, 0x01, 0x86, 0xCC, 0xC0, 0x0F, 0xE0, 0x30,
	0x00, 0x00, 0x03, 0xF8, 0x01, 0x98, 0x60, 0x61, 0x8C, 0x00, 0xFE, 0x00,
	0x0C, 0xCC, 0x00, 0xC6, 0x18, 0xC1, 0x8C, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x6E, 0x0C, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x3E, 0x0C, 0x61, 0x9B, 0x73, 0x33, 0x80, 0x00, 0x00, 0x31,
	0x86, 0x6C, 0xC6, 0xC6, 0x6C, 0xD8, 0x37, 0x06, 0x30, 0xCD, 0xB9, 0x99,
	0xC0, 0x01, 0x8C, 0x33, 0x66, 0x31, 0xE1, 0x98,

	// Scan Line #5.
	0x01, 0xB6, 0x6C, 0x79, 0xC0, 0xD8, 0x36, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x06, 0x63, 0x78, 0x06, 0x06, 0x3C, 0xC0, 0xC0, 0x06, 0xC6, 0xC6, 0xC0,
	0xC0, 0x03, 0x19, 0xB1, 0xB1, 0xB1, 0xB0, 0x31, 0xB0, 0x60, 0xC0, 0xC6,
	0xC1, 0xB6, 0x18, 0x3F, 0xDC, 0xD8, 0xD8, 0xD8, 0xC6, 0x36, 0x00, 0xC3,
	0x1B, 0x0D, 0x86, 0x66, 0x33, 0x01, 0x98, 0x60, 0x0C, 0xF0, 0x03, 0x00,
	0x60, 0x00, 0x18, 0x03, 0xC0, 0x30, 0x00, 0x30, 0x60, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x19, 0xB8,
	0x00, 0x80, 0x07, 0xE3, 0x03, 0x0C, 0xCC, 0xC6, 0x00, 0x18, 0x31, 0xF0,
	0x00, 0x00, 0x06, 0x0C, 0x00, 0xF0, 0x60, 0xC6, 0xCC, 0x01, 0xB6, 0x00,
	0x0C, 0xCC, 0x00, 0xCC, 0x19, 0x86, 0xD8, 0x00, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0xC6, 0x0C, 0x0F, 0xDF, 0xBF, 0x7E, 0x6C, 0x61, 0x86, 0x36,
	0x33, 0xE3, 0xE3, 0xE3, 0xE3, 0xE3, 0x31, 0xF9, 0x8D, 0x8D, 0x8D, 0x8D,
	0x86, 0x7E, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0xC0, 0x60, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00,

	// Scan Line #6.
	0x01, 0x80, 0xFE, 0xCD, 0xCC, 0xD8, 0x06, 0x0C, 0xCC, 0x30, 0x00, 0x00,
	0x0C, 0x67, 0x18, 0x0C, 0x06, 0x6C, 0xC0, 0xC0, 0x0C, 0xC6, 0xC6, 0xD9,
	0x80, 0x01, 0x83, 0x37, 0xB1, 0xB1, 0xB0, 0x31, 0xB0, 0x60, 0xC0, 0xC6,
	0xC1, 0xBC, 0x18, 0x36, 0xDE, 0xD8, 0xD8, 0xD8, 0xC6, 0x36, 0x00, 0xC3,
	0x1B, 0x0D, 0x86, 0x3C, 0x1E, 0x03, 0x18, 0x30, 0x0D, 0x98, 0x01, 0x9E,
	0x7C, 0x7C, 0xF9, 0xE3, 0x0F, 0xBE, 0x61, 0xB3, 0x6F, 0xE7, 0xC7, 0x9F,
	0x1F, 0x7C, 0x7D, 0xEC, 0xD9, 0xB3, 0x36, 0xD9, 0xBE, 0x63, 0x18, 0x00,
	0x00, 0x80, 0x6C, 0xF3, 0x01, 0xF8, 0x78, 0xC3, 0x00, 0x33, 0xDB, 0x31,
	0xB0, 0x00, 0x0D, 0xE6, 0x00, 0x03, 0xFD, 0xF3, 0x98, 0xCD, 0xB6, 0xE0,
	0x1E, 0xCD, 0xB0, 0xDB, 0x1B, 0x03, 0xB6, 0x18, 0x6C, 0x6C, 0x6C, 0x6C,
	0x6C, 0x6C, 0xC6, 0x0C, 0x0C, 0x18, 0x30, 0x60, 0x6C, 0x61, 0x86, 0x37,
	0x36, 0x36, 0x36, 0x36, 0x36, 0x31, 0xE3, 0x39, 0x8D, 0x8D, 0x8D, 0x8C,
	0xCC, 0x63, 0x63, 0x3C, 0x78, 0xF1, 0xE1, 0xE3, 0xC7, 0xF8, 0xF8, 0xF1,
	0xE3, 0xC7, 0x8C, 0x61, 0x83, 0x06, 0x3E, 0x1E, 0x3C, 0x78, 0xF0, 0xF0,
	0x07, 0xCC, 0xD9, 0xB3, 0x66, 0xCC, 0xF9, 0x98,

	// Scan Line #7.
	0x01, 0x80, 0x6C, 0xC0, 0x18, 0x70, 0x06, 0x0C, 0x78, 0x30, 0x00, 0x00,
	0x18, 0x6F, 0x18, 0x18, 0x3C, 0xCC, 0xFC, 0xFC, 0x18, 0x7C, 0x7E, 0x1B,
	0x07, 0xE0, 0xC6, 0x37, 0xB1, 0xBF, 0x30, 0x31, 0xBE, 0x7C, 0xC0, 0xFE,
	0xC1, 0xB8, 0x18, 0x30, 0xDE, 0xD8, 0xDF, 0x98, 0xC7, 0xE3, 0xE0, 0xC3,
	0x1B, 0x0D, 0x86, 0x18, 0x0C, 0x06, 0x18, 0x18, 0x0C, 0x00, 0x00, 0x03,
	0x66, 0xC1, 0x9B, 0x37, 0x99, 0xB3, 0x61, 0xB6, 0x6D, 0xB6, 0x6C, 0xD9,
	0xB3, 0x66, 0xC0, 0xCC, 0xD9, 0xB3, 0x36, 0xD9, 0x86, 0xC0, 0x0C, 0x00,
	0x30, 0x80, 0x6D, 0x87, 0xC3, 0x0C, 0x30, 0x07, 0x80, 0x36, 0x19, 0xF3,
	0x60, 0x00, 0x0D, 0xB6, 0x00, 0x00, 0x60, 0x00, 0x00, 0xCD, 0xB6, 0xE0,
	0x00, 0x78, 0xD8, 0xF7, 0x1E, 0xF0, 0x6E, 0x18, 0xC6, 0xC6, 0xC6, 0xC6,
	0xC6, 0xC6, 0xFF, 0xCC, 0x0C, 0x18, 0x30, 0x60, 0x6C, 0x61, 0x8F, 0xB7,
	0x36, 0x36, 0x36, 0x36, 0x36, 0x30, 0xC6, 0x6D, 0x8D, 0x8D, 0x8D, 0x8C,
	0x78, 0x63, 0x7E, 0x06, 0x0C, 0x18, 0x30, 0x30, 0x60, 0xCD, 0x8D, 0x9B,
	0x36, 0x6C, 0xCC, 0x61, 0x83, 0x0F, 0x33, 0x33, 0x66, 0xCD, 0x99, 0x9B,
	0xEC, 0xEC, 0xD9, 0xB3, 0x66, 0xCC, 0xCD, 0x98,

	// Scan Line #8.
	0x01, 0x80, 0x6C, 0x78, 0x30, 0xF6, 0x06, 0x0D, 0xFE, 0xFC, 0x0F, 0xC0,
	0x30, 0x7B, 0x18, 0x30, 0x06, 0xFE, 0x06, 0xC6, 0x30, 0xC6, 0x06, 0x03,
	0x00, 0x00, 0xC6, 0x37, 0xBF, 0xB1, 0xB0, 0x31, 0xB0, 0x60, 0xCE, 0xC6,
	0xC1, 0xBC, 0x18, 0x30, 0xDB, 0xD8, 0xD8, 0x18, 0xC6, 0x60, 0x30, 0xC3,
	0x1B, 0x0D, 0x86, 0x3C, 0x0C, 0x0C, 0x18, 0x0C, 0x0C, 0x00, 0x00, 0x1F,
	0x66, 0xC1, 0x9B, 0x33, 0x19, 0xB3, 0x61, 0xBC, 0x6D, 0xB6, 0x6C, 0xD9,
	0xB3, 0x60, 0xC0, 0xCC, 0xD9, 0xB3, 0x33, 0x99, 0x8C, 0xC0, 0x0C, 0x00,
	0x78, 0x80, 0x6D, 0x83, 0x03, 0x0C, 0xFC, 0x0C, 0xC0, 0x36, 0x18, 0x06,
	0xC0, 0x07, 0xED, 0xE6, 0x00, 0x00, 0x60, 0x00, 0x00, 0xCC, 0xF6, 0xE0,
	0x00, 0x00, 0x6C, 0x6F, 0x0D, 0xB0, 0xDE, 0x18, 0xC6, 0xC6, 0xC6, 0xC6,
	0xC6, 0xC6, 0xC6, 0x0C, 0x0F, 0x9F, 0x3E, 0x7C, 0x6C, 0x61, 0x86, 0x37,
	0xB6, 0x36, 0x36, 0x36, 0x36, 0x31, 0xE6, 0xCD, 0x8D, 0x8D, 0x8D, 0x8C,
	0x30, 0x63, 0x63, 0x3E, 0x7C, 0xF9, 0xF1, 0xF3, 0xE7, 0xFD, 0x81, 0x9B,
	0x36, 0x6C, 0xCC, 0x61, 0x83, 0x19, 0xB3, 0x33, 0x66, 0xCD, 0x99, 0x98,
	0x0D, 0xEC, 0xD9, 0xB3, 0x66, 0xCC, 0xCD, 0x98,

	// Scan Line #9.
	0x01, 0x80, 0xFE, 0x0C, 0x61, 0x9C, 0x06, 0x0C, 0x78, 0x30, 0x00, 0x00,
	0x60, 0x73, 0x18, 0x60, 0x06, 0x0C, 0x06, 0xC6, 0x30, 0xC6, 0x06, 0xC1,
	0x87, 0xE1, 0x86, 0x37, 0x31, 0xB1, 0xB0, 0x31, 0xB0, 0x60, 0xC6, 0xC6,
	0xC1, 0xB6, 0x18, 0x30, 0xDB, 0xD8, 0xD8, 0x19, 0xC6, 0x30, 0x30, 0xC3,
	0x1B, 0x0D, 0xB6, 0x66, 0x0C, 0x18, 0x18, 0x06, 0x0C, 0x00, 0x00, 0x33,
	0x66, 0xC1, 0x9B, 0xF3, 0x19, 0xB3, 0x61, 0xB8, 0x6D, 0xB6, 0x6C, 0xD9,
	0xB3, 0x60, 0x78, 0xCC, 0xD9, 0xB3, 0x33, 0x99, 0x98, 0x63, 0x18, 0x00,
	0xCC, 0x80, 0x6F, 0x33, 0x03, 0x0C, 0x30, 0xCC, 0xC0, 0x36, 0x1B, 0xF3,
	0x60, 0x00, 0x0D, 0xB6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCC, 0x36, 0x00,
	0x00, 0xFC, 0xD8, 0xDF, 0x98, 0x61, 0xBF, 0x30, 0xFE, 0xFE, 0xFE, 0xFE,
	0xFE, 0xFE, 0xC6, 0x0C, 0x0C, 0x18, 0x30, 0x60, 0x6C, 0x61, 0x86, 0x36,
	0xF6, 0x36, 0x36, 0x36, 0x36, 0x33, 0x36, 0xCD, 0x8D, 0x8D, 0x8D, 0x8C,
	0x30, 0x63, 0x63, 0x66, 0xCD, 0x9B, 0x33, 0x36, 0x6C, 0xC1, 0x81, 0xFB,
	0xF7, 0xEF, 0xCC, 0x61, 0x83, 0x19, 0xB3, 0x33, 0x66, 0xCD, 0x99, 0x99,
	0xCF, 0x6C, 0xD9, 0xB3, 0x66, 0xCC, 0xCD, 0x98,

	// Scan Line #10.
	0x00, 0x00, 0x6C, 0xCC, 0xC1, 0x8C, 0x06, 0x0C, 0xCC, 0x30, 0x00, 0x00,
	0xC0, 0x63, 0x18, 0xC0, 0x06, 0x0C, 0x06, 0xC6, 0x30, 0xC6, 0x06, 0xC0,
	0xC0, 0x03, 0x00, 0x30, 0x31, 0xB1, 0xB0, 0x31, 0xB0, 0x60, 0xC6, 0xC6,
	0xD9, 0xB3, 0x18, 0x30, 0xD9, 0xD8, 0xD8, 0x18, 0xC6, 0x30, 0x30, 0xC3,
	0x19, 0x99, 0xFE, 0xC3, 0x0C, 0x30, 0x18, 0x03, 0x0C, 0x00, 0x00, 0x33,
	0x66, 0xC1, 0x9B, 0x03, 0x19, 0xB3, 0x61, 0xBC, 0x6D, 0xB6, 0x6C, 0xD9,
	0xB3, 0x60, 0x0C, 0xCC, 0xD9, 0xB3, 0x36, 0xD9, 0xB0, 0x63, 0x18, 0x01,
	0x86, 0x80, 0x67, 0xE3, 0x01, 0xF8, 0xFC, 0xC7, 0x80, 0x33, 0xD8, 0x01,
	0xB7, 0xF0, 0x0D, 0xB6, 0x00, 0x03, 0xFC, 0x00, 0x00, 0xCC, 0x36, 0x00,
	0x00, 0x01, 0xB1, 0x83, 0x30, 0xC3, 0x06, 0x66, 0xC6, 0xC6, 0xC6, 0xC6,
	0xC6, 0xC6, 0xC6, 0x0C, 0x6C, 0x18, 0x30, 0x60, 0x6C, 0x61, 0x86, 0x36,
	0x76, 0x36, 0x36, 0x36, 0x36, 0x30, 0x03, 0x99, 0x8D, 0x8D, 0x8D, 0x8C,
	0x30, 0x7E, 0x63, 0x66, 0xCD, 0x9B, 0x33, 0x36, 0x6C, 0xC1, 0x8D, 0x83,
	0x06, 0x0C, 0x0C, 0x61, 0x83, 0x19, 0xB3, 0x33, 0x66, 0xCD, 0x99, 0x99,
	0xCE, 0x6C, 0xD9, 0xB3, 0x66, 0xCC, 0xCD, 0x98,

	// Scan Line #11.
	0x01, 0x80, 0x6C, 0x79, 0x9D, 0x8E, 0x03, 0x18, 0x00, 0x00, 0xE0, 0x1D,
	0x80, 0x63, 0x18, 0xC6, 0xC6, 0x0C, 0xC6, 0xC6, 0x30, 0xC6, 0xC6, 0x18,
	0x60, 0x06, 0x06, 0x30, 0x31, 0xB1, 0xB1, 0xB3, 0x30, 0x60, 0xC6, 0xC6,
	0xD9, 0xB1, 0x98, 0x30, 0xD9, 0xD8, 0xD8, 0x18, 0xE6, 0x36, 0x30, 0xC3,
	0x18, 0xF1, 0xCE, 0xC3, 0x0C, 0x30, 0x18, 0x01, 0x8C, 0x00, 0x00, 0x33,
	0x66, 0xC1, 0x9B, 0x33, 0x19, 0xB3, 0x61, 0xB6, 0x6D, 0xB6, 0x6C, 0xD9,
	0xB3, 0x60, 0x0C, 0xCC, 0xCF, 0x1F, 0xE6, 0xD9, 0xB0, 0x63, 0x18, 0x01,
	0x86, 0x80, 0x66, 0x03, 0x1B, 0x0C, 0x30, 0xC3, 0x00, 0x18, 0x30, 0x00,
	0x00, 0x30, 0x06, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x36, 0x01,
	0x80, 0x00, 0x00, 0x03, 0x01, 0xF0, 0x06, 0x66, 0xC6, 0xC6, 0xC6, 0xC6,
	0xC6, 0xC6, 0xC6, 0x07, 0xCC, 0x18, 0x30, 0x60, 0x6C, 0x61, 0x86, 0x66,
	0x76, 0x36, 0x36, 0x36, 0x36, 0x30, 0x03, 0xF1, 0x8D, 0x8D, 0x8D, 0x8C,
	0x30, 0x60, 0x6E, 0x66, 0xCD, 0x9B, 0x33, 0x36, 0x6C, 0xCC, 0xF9, 0x9B,
	0x36, 0x6C, 0xCC, 0x61, 0x83, 0x19, 0xB3, 0x33, 0x66, 0xCD, 0x99, 0x98,
	0x07, 0xCC, 0xD9, 0xB3, 0x66, 0xCC, 0xF9, 0x98,

	// Scan Line #12.
	0x01, 0x80, 0x6C, 0x30, 0x1C, 0xFB, 0x01, 0xB0, 0x00, 0x00, 0xE0, 0x1C,
	0x00, 0x3E, 0x7E, 0xFE, 0x7C, 0x1E, 0x7C, 0x7C, 0x30, 0x7C, 0x7C, 0x18,
	0x30, 0x0C, 0x06, 0x1F, 0xB1, 0xBF, 0x1F, 0x3E, 0x3F, 0x60, 0x7C, 0xC6,
	0xCF, 0x30, 0xDF, 0xB0, 0xD8, 0xCF, 0x98, 0x0F, 0xB6, 0x33, 0xE0, 0xC1,
	0xF0, 0x61, 0x86, 0xC3, 0x0C, 0x3F, 0xDE, 0x00, 0x3C, 0x00, 0x00, 0x1F,
	0x7C, 0x7C, 0xF9, 0xE3, 0x0F, 0xB3, 0x61, 0xB3, 0x6D, 0xB6, 0x67, 0x9F,
	0x1F, 0x60, 0xF8, 0xC7, 0xC6, 0x0C, 0xC6, 0xCF, 0xBE, 0x3B, 0x70, 0x01,
	0xFE, 0x80, 0x6C, 0x07, 0xF0, 0x00, 0x30, 0xC1, 0x80, 0x0F, 0xE0, 0x00,
	0x00, 0x30, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x36, 0x01,
	0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0xC6, 0xC6, 0xC6, 0xC6,
	0xC6, 0xC6, 0xC7, 0xE1, 0x8F, 0xDF, 0xBF, 0x7E, 0x6C, 0x61, 0x87, 0xC6,
	0x33, 0xE3, 0xE3, 0xE3, 0xE3, 0xE0, 0x06, 0x00, 0xF8, 0xF8, 0xF8, 0xF8,
	0x30, 0xF0, 0x60, 0x3E, 0x7C, 0xF9, 0xF1, 0xF3, 0xE7, 0xF8, 0x30, 0xF1,
	0xE3, 0xC7, 0x8C, 0x61, 0x83, 0x0F, 0x33, 0x1E, 0x3C, 0x78, 0xF0, 0xF0,
	0x0C, 0x07, 0xCF, 0x9F, 0x3E, 0x7C, 0xC0, 0xF8,

	// Scan Line #13.
	0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x01, 0x80, 0x00, 0x00, 0x00, 0x18,
	0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xC0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x0C,
	0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0C, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x98, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xE0, 0x18,

	// Scan Line #14.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x19, 0x80, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x18,
	0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
	0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x01, 0xF0,

	// Scan Line #15.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
	0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


static FONT iso_syst =
{
	iso_syst_offset_table,
	iso_syst_data_table,

	176,		// The number of bytes in each row of the bitmap.
	 15,		// The number of rows in the bitmap.
	  0,		// The first character in the bitmap.
	255,		// The last character in the bitmap.
	 12,		// The widest character, in bits.
	 11,		// The distance from the baseline to the top of a character.
	 12,		// The distance from the top to the underline bar.
	  0 		// The flag for a ROM resident font.
};

FONT *GFX_iso_syst_font (void)
{
	return (&iso_syst);
}
