# ----- General Definitions -------------------------------------------------
VERSION=mvcpp210

D32HARDWAREDEP=i_mscat.o32
D32HARDWARELIB=i_mscat.o32

.SUFFIXES : .c .cpp .obj .o16 .o32 .obw .obn

# ----- 32 bit Dos Extender compiler options --------------------------------
# for debug:    add -Zi to CPP_OPTS
#               and -CV to LINK_OPTS
D32_CPP=cl
D32_LINK=link
D32_LIBRARIAN=lib
D32_CPP_OPTS=-c -DDOS386 -nologo
D32_LINK_OPTS=
D32_LIB_OPTS=
D32_OBJS=

# --- Use the next line for UI_GRAPHICS_DISPLAY ---
D32_LIBS=dosx32.lib dos32.lib d32_zil.lib d32_gfx.lib ms_32gfx.lib oldnames.lib
# --- Use the next line for UI_MSC_DISPLAY ---
#D32_LIBS=dosx32.lib dos32.lib tntapi.lib d32_zil.lib d32_msc.lib oldnames.lib

.cpp.o32:
	$(D32_CPP) $(D32_CPP_OPTS) -Fo$*.o32 $<

# ----- Usage --------------------------------------------------------------
usage:
	@echo ...........
	@echo ...........
	@echo To generate the library modules for specific environments type:
	@echo nmake -fmvcpp210.mak dos32
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean:
	z_clean.bat

# ----- Copy files ----------------------------------------------------------
copy:
	copy ui_*.hpp ..\include
	copy z_clean.* ..\bin

gfx_copy:
	copy gfx\source\gfx.h ..\include
	copy gfx\source\gfx_pro.h ..\include

# ----- 32 bit DOS Extender Libraries and Programs --------------------------
dos32: copy gfx_copy d32_msc.lib d32_gfx.lib ms_32gfx.lib d32_zil.lib test32.exe

test32.exe: test.o32
	$(D32_LINK) @msvc32.lnk $(D32_LINK_OPTS) -out:test32.exe $(D32_OBJS) test.o32 $(D32_LIBS)

d32_zil.lib : \
	d_bnum.o32 \
	d_border.o32 \
	d_button.o32 \
	d_combo.o32 \
	d_cursor.o32 \
	d_date.o32 \
	d_error.o32 \
	d_error1.o32 \
	d_event.o32 \
	d_fmtstr.o32 \
	d_group.o32 \
	d_hlist.o32 \
	d_icon.o32 \
	d_image.o32 \
	d_int.o32 \
	d_intl.o32 \
	d_keybrd.o32 \
	d_max.o32 \
	d_min.o32 \
	d_mouse.o32 \
	d_notebk.o32 \
	d_plldn.o32 \
	d_plldn1.o32 \
	d_popup.o32 \
	d_popup1.o32 \
	d_prompt.o32 \
	d_real.o32 \
	d_sbar.o32 \
	d_scroll.o32 \
	d_spin.o32 \
	d_string.o32 \
	d_sys.o32 \
	d_table.o32 \
	d_table1.o32 \
	d_table2.o32 \
	d_tbar.o32 \
	d_tdsp.o32 \
	d_text.o32 \
	d_time.o32 \
	d_title.o32 \
	d_vlist.o32 \
	d_win.o32 \
	d_win1.o32 \
	d_win2.o32 \
	z_bnum.o32 \
	z_bnum1.o32 \
	z_bnum2.o32 \
	z_border.o32 \
	z_button.o32 \
	z_combo.o32 \
	z_cursor.o32 \
	z_date.o32 \
	z_date1.o32 \
	z_decor.o32 \
	z_device.o32 \
	z_dialog.o32 \
	z_dsp.o32 \
	z_error.o32 \
	z_error1.o32 \
	z_event.o32 \
	z_file.o32 \
	z_fmtstr.o32 \
	z_gmgr.o32 \
	z_gmgr1.o32 \
	z_gmgr2.o32 \
	z_gmgr3.o32 \
	z_group.o32 \
	z_help.o32 \
	z_help1.o32 \
	z_hlist.o32 \
	z_icon.o32 \
	z_image.o32 \
	z_i18n.o32 \
	z_int.o32 \
	z_intl.o32 \
	z_lang.o32 \
	z_list.o32 \
	z_list1.o32 \
	z_locale.o32 \
	z_map1.o32 \
	z_map2.o32 \
	z_max.o32 \
	z_min.o32 \
	z_msgwin.o32 \
	z_notebk.o32 \
	z_path.o32 \
	z_plldn.o32 \
	z_plldn1.o32 \
	z_popup.o32 \
	z_popup1.o32 \
	z_printf.o32 \
	z_prompt.o32 \
	z_real.o32 \
	z_region.o32 \
	z_sbar.o32 \
	z_scanf.o32 \
	z_scroll.o32 \
	z_spin.o32 \
	z_stdarg.o32 \
	z_stored.o32 \
	z_storer.o32 \
	z_storew.o32 \
	z_string.o32 \
	z_sys.o32 \
	z_table.o32 \
	z_table1.o32 \
	z_table2.o32 \
	z_tbar.o32 \
	z_text.o32 \
	z_time.o32 \
	z_time1.o32 \
	z_timer.o32 \
	z_title.o32 \
	z_utils.o32 \
	z_utime.o32 \
	z_utime1.o32 \
	z_vlist.o32 \
	z_win.o32 \
	z_win1.o32 \
	z_win2.o32 \
	z_win3.o32 \
	z_win4.o32 \
	g_dsp.o32 \
	g_event.o32 \
	g_evt.o32 \
	g_gen.o32 \
	g_i18n.o32 \
	g_jump.o32 \
	g_lang.o32 \
	g_lang1.o32 \
	g_loc.o32 \
	g_loc1.o32 \
	g_mach.o32 \
	g_pnorm.o32 \
	g_win.o32 \
	i_file.o32 \
	i_map.o32 \
	i_str1.o32 \
	i_str2.o32 \
	i_str3.o32 \
	i_str4.o32 \
	i_str5.o32 \
	i_type.o32 \
	$(D32HARDWAREDEP)
	-@del d32_zil.lib
	$(D32_LIBRARIAN) $(D32_LIB_OPTS) @<<zil.rsp
/out:$*.lib
	d_bnum.o32
	d_border.o32
	d_button.o32
	d_combo.o32
	d_cursor.o32
	d_date.o32
	d_error.o32
	d_error1.o32
	d_event.o32
	d_fmtstr.o32
	d_group.o32
	d_hlist.o32
	d_icon.o32
	d_image.o32
	d_int.o32
	d_intl.o32
	d_keybrd.o32
	d_max.o32
	d_min.o32
	d_mouse.o32
	d_notebk.o32
	d_plldn.o32
	d_plldn1.o32
	d_popup.o32
	d_popup1.o32
	d_prompt.o32
	d_real.o32
	d_sbar.o32
	d_scroll.o32
	d_spin.o32
	d_string.o32
	d_sys.o32
	d_table.o32
	d_table1.o32
	d_table2.o32
	d_tbar.o32
	d_tdsp.o32
	d_text.o32
	d_time.o32
	d_title.o32
	d_vlist.o32
	d_win.o32
	d_win1.o32
	d_win2.o32
	z_bnum.o32
	z_bnum1.o32
	z_bnum2.o32
	z_border.o32
	z_button.o32
	z_combo.o32
	z_cursor.o32
	z_date.o32
	z_date1.o32
	z_decor.o32
	z_device.o32
	z_dialog.o32
	z_dsp.o32
	z_error.o32
	z_error1.o32
	z_event.o32
	z_file.o32
	z_fmtstr.o32
	z_gmgr.o32
	z_gmgr1.o32
	z_gmgr2.o32
	z_gmgr3.o32
	z_group.o32
	z_help.o32
	z_help1.o32
	z_hlist.o32
	z_icon.o32
	z_image.o32
	z_i18n.o32
	z_int.o32
	z_intl.o32
	z_lang.o32
	z_list.o32
	z_list1.o32
	z_locale.o32
	z_map1.o32
	z_map2.o32
	z_max.o32
	z_min.o32
	z_msgwin.o32
	z_notebk.o32
	z_path.o32
	z_plldn.o32
	z_plldn1.o32
	z_popup.o32
	z_popup1.o32
	z_printf.o32
	z_prompt.o32
	z_real.o32
	z_region.o32
	z_sbar.o32
	z_scanf.o32
	z_scroll.o32
	z_spin.o32
	z_stdarg.o32
	z_stored.o32
	z_storer.o32
	z_storew.o32
	z_string.o32
	z_sys.o32
	z_table.o32
	z_table1.o32
	z_table2.o32
	z_tbar.o32
	z_text.o32
	z_time.o32
	z_time1.o32
	z_timer.o32
	z_title.o32
	z_utils.o32
	z_utime.o32
	z_utime1.o32
	z_vlist.o32
	z_win.o32
	z_win1.o32
	z_win2.o32
	z_win3.o32
	z_win4.o32
	g_dsp.o32
	g_event.o32
	g_evt.o32
	g_gen.o32
	g_i18n.o32
	g_jump.o32
	g_lang.o32
	g_lang1.o32
	g_loc.o32
	g_loc1.o32
	g_mach.o32
	g_pnorm.o32
	g_win.o32
	i_file.o32
	i_map.o32
	i_str1.o32
	i_str2.o32
	i_str3.o32
	i_str4.o32
	i_str5.o32
	i_type.o32
	$(D32HARDWARELIB)
<<
	-@md ..\lib\$(VERSION)
	copy d32_zil.lib ..\lib\$(VERSION)

d32_msc.lib : d_mscdsp.o32 d_mscprn.o32 z_appmsc.o32
	-@del d32_msc.lib
	$(D32_LIBRARIAN) $(D32_LIB_OPTS) @<<zil.rsp
/out:$*.lib d_mscdsp.o32 d_mscprn.o32 z_appmsc.o32
<<
	-@md ..\lib\$(VERSION)
	copy d32_msc.lib ..\lib\$(VERSION)

d32_gfx.lib : d_gfxdsp.o32 d_gfxprn.o32 z_appgfx.o32 \
	OEM_smal.o32 OEM_dial.o32 OEM_syst.o32 \
	ISO_smal.o32 ISO_dial.o32 ISO_syst.o32
       -@del d32_gfx.lib
       $(D32_LIBRARIAN) $(D32_LIB_OPTS) @<<zil.rsp
/out:$*.lib d_gfxdsp.o32 d_gfxprn.o32 z_appgfx.o32
OEM_smal.o32 OEM_dial.o32 OEM_syst.o32
ISO_smal.o32 ISO_dial.o32 ISO_syst.o32
<<
       -@md ..\lib\$(VERSION)
       copy d32_gfx.lib ..\lib\$(VERSION)

ms_32gfx.lib:
       @cd gfx\source
       nmake -fmvcpp210.mak dos32
       @cd ..\..

# --- Done with libraries ---------------------------------------------------

z_appmsc.o32: z_app.cpp
        $(D32_CPP) -DMSC $(D32_CPP_OPTS) -Fo$@ $?

z_appgfx.o32: z_app.cpp
        $(D32_CPP) -DGFX $(D32_CPP_OPTS) -Fo$@ $?

z_apptxt.o32: z_app.cpp
        $(D32_CPP) -DTEXT $(D32_CPP_OPTS) -Fo$@ $?

d_mscprn.o32: d_print.cpp
        $(D32_CPP) -DMSC $(D32_CPP_OPTS) -Fo$@ $?

d_gfxprn.o32: d_print.cpp
        $(D32_CPP) -DGFX $(D32_CPP_OPTS) -Fo$@ $?

OEM_dial.cpp: gfx\OEM_dial.cpp
	copy gfx\OEM_dial.cpp

OEM_smal.cpp: gfx\OEM_smal.cpp
	copy gfx\OEM_smal.cpp

OEM_syst.cpp: gfx\OEM_syst.cpp
	copy gfx\OEM_syst.cpp

ISO_dial.cpp: gfx\ISO_dial.cpp
	copy gfx\ISO_dial.cpp

ISO_smal.cpp: gfx\ISO_smal.cpp
	copy gfx\ISO_smal.cpp

ISO_syst.cpp: gfx\ISO_syst.cpp
	copy gfx\ISO_syst.cpp
