//  GRID.HPP (GRID) - DrawItem example.
//  COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//  Zinc Software Incorporated.  Pleasant Grove, Utah  USA
//  May be freely copied, used and distributed.

#define CELL 50    // Grid cell dimension of 50 x 50 pixels.
#define EMPTY_CELL 0
#define X_CELL     1
#define O_CELL     2
#define E_RESET_GRID 10000
#define E_O_FIRST    10001
#define E_X_FIRST    10002

struct GRIDCELL
{
	UI_REGION region;
	int cellValue;
};

// Class prototype for DRAW_OBJECT.
class ZIL_EXPORT_CLASS DRAW_OBJECT : public UI_WINDOW_OBJECT
{
public:
	DRAW_OBJECT(void);
	~DRAW_OBJECT(void){}

	virtual EVENT_TYPE DrawItem(const UI_EVENT &event, EVENT_TYPE ccode);
	virtual EVENT_TYPE Event(const UI_EVENT &event);

protected:
	GRIDCELL gridCell[9];
	int xCenter,        // Horizontal center of draw object.
		yCenter,        // Vertical center of draw object.
		xoCount,
		moveOccurred;   // Counter for x's and o's.
};

// ------------------------------------------------------------------------
// From code file generated by designer (.hpp) ----------------------------
// ------------------------------------------------------------------------
#if defined(USE_GRID_WINDOW)
const ZIL_NUMBERID FIELD_1                          = 0x0001;
const ZIL_NUMBERID FIELD_2                          = 0x0002;
const ZIL_NUMBERID FIELD_3                          = 0x0003;
const ZIL_NUMBERID FIELD_4                          = 0x0004;
#endif

#if defined(USE_DERIVED_OBJECTS)
#endif

