//	Zinc Interface Library - OEM_SMAL.CPP
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

/*       This file is a part of OpenZinc

          OpenZinc is free software; you can redistribute it and/or modify it under
          the terms of the GNU Lessor General Public License as published by
          the Free Software Foundation, either version 3 of the License, or (at
          your option) any later version

	OpenZinc is distributed in the hope that it will be useful, but WITHOUT
          ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
          or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
          General Public License for more details.

          You should have received a copy of the GNU Lessor General Public License
	 along with OpenZinc. If not, see <http://www.gnu.org/licenses/>                          */


#include "gfx.h"
#if defined(DOS386)
#	undef _far
#	define _far
#endif

static unsigned short _far oem_smal_offset_table[] =
{
	0x0000, 0x0000, 0x0009, 0x0012, 0x001B, 0x0024, 0x002D, 0x0036,
	0x003F, 0x0048, 0x0051, 0x005A, 0x0063, 0x006C, 0x0075, 0x007E,
	0x0087, 0x0090, 0x0099, 0x00A2, 0x00AB, 0x00B4, 0x00BD, 0x00C6,
	0x00CF, 0x00D8, 0x00E1, 0x00EA, 0x00F3, 0x00FC, 0x0105, 0x010E,
	0x0117, 0x011D, 0x011F, 0x0124, 0x012B, 0x0131, 0x0138, 0x0141,
	0x0144, 0x0148, 0x014C, 0x0154, 0x015A, 0x015E, 0x0164, 0x0168,
	0x0170, 0x0177, 0x017D, 0x0184, 0x018B, 0x0192, 0x0199, 0x01A0,
	0x01A7, 0x01AE, 0x01B5, 0x01B8, 0x01BB, 0x01C1, 0x01C7, 0x01CD,
	0x01D3, 0x01DA, 0x01E1, 0x01E8, 0x01EF, 0x01F6, 0x01FC, 0x0202,
	0x0209, 0x0210, 0x0212, 0x0218, 0x021F, 0x0225, 0x022D, 0x0233,
	0x023A, 0x0241, 0x024A, 0x0251, 0x0258, 0x0260, 0x0267, 0x026F,
	0x0277, 0x027F, 0x0287, 0x028F, 0x0293, 0x029B, 0x029F, 0x02A5,
	0x02AC, 0x02AF, 0x02B5, 0x02BB, 0x02C1, 0x02C7, 0x02CD, 0x02D2,
	0x02D8, 0x02DE, 0x02E0, 0x02E5, 0x02EB, 0x02ED, 0x02F5, 0x02FB,
	0x0301, 0x0307, 0x030D, 0x0313, 0x0319, 0x031D, 0x0323, 0x0329,
	0x0333, 0x0338, 0x033E, 0x0343, 0x0348, 0x034A, 0x034F, 0x0356,
	0x035E, 0x0365, 0x036B, 0x0371, 0x0377, 0x037D, 0x0383, 0x0389,
	0x0390, 0x0396, 0x039C, 0x03A2, 0x03A8, 0x03AE, 0x03B2, 0x03B9,
	0x03C0, 0x03C6, 0x03D0, 0x03DB, 0x03E1, 0x03E7, 0x03ED, 0x03F3,
	0x03F9, 0x03FF, 0x0406, 0x040D, 0x0415, 0x041D, 0x0425, 0x042C,
	0x0434, 0x043A, 0x043E, 0x0444, 0x044A, 0x0451, 0x0458, 0x045E,
	0x0464, 0x046A, 0x0470, 0x0476, 0x0480, 0x048A, 0x048C, 0x0493,
	0x049A, 0x049C, 0x049E, 0x04A0, 0x04A2, 0x04A4, 0x04A6, 0x04A8,
	0x04AA, 0x04AC, 0x04AE, 0x04B0, 0x04B2, 0x04B4, 0x04B6, 0x04B8,
	0x04BA, 0x04BC, 0x04BE, 0x04C0, 0x04C2, 0x04C4, 0x04C6, 0x04C8,
	0x04CA, 0x04CC, 0x04CE, 0x04D0, 0x04D2, 0x04D4, 0x04D6, 0x04D8,
	0x04DA, 0x04DC, 0x04DE, 0x04E0, 0x04E2, 0x04E4, 0x04E6, 0x04E8,
	0x04EA, 0x04EC, 0x04EE, 0x04F0, 0x04F2, 0x04F4, 0x04F6, 0x04F8,
	0x04FA, 0x0502, 0x0509, 0x0510, 0x0518, 0x0520, 0x0528, 0x052F,
	0x0537, 0x053F, 0x0546, 0x054F, 0x0555, 0x055F, 0x0566, 0x056C,
	0x0573, 0x057A, 0x0582, 0x0588, 0x058E, 0x0594, 0x059A, 0x059F,
	0x05A6, 0x05AC, 0x05AF, 0x05B2, 0x05BC, 0x05C2, 0x05C7, 0x05CB,
	0x05CD
};


static unsigned char _far oem_smal_data_table[] =
{

	// Scan Line #1.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x10, 0x02, 0x06, 0x00, 0x20, 0x04, 0x00, 0x22, 0x21, 0x18,
	0x10, 0x00, 0x00, 0x04, 0x00, 0x81, 0x08, 0x01, 0x0A, 0x10, 0x80, 0x00,
	0x07, 0x80, 0x01, 0x08, 0x41, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	// Scan Line #2.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
	0x24, 0x84, 0x00, 0x30, 0x22, 0x80, 0x00, 0x00, 0x00, 0x00, 0x78, 0x43,
	0xC7, 0x81, 0x3F, 0x3C, 0xFC, 0xF1, 0xE0, 0x01, 0x01, 0x03, 0x8F, 0x0C,
	0x7C, 0x79, 0xE3, 0xEF, 0x9E, 0x42, 0x82, 0x85, 0x04, 0x14, 0x4F, 0x3E,
	0x3C, 0x3E, 0x3C, 0xFE, 0x85, 0x05, 0x05, 0x05, 0x05, 0xFD, 0xC0, 0x1C,
	0x00, 0x08, 0x04, 0x00, 0x04, 0x00, 0x00, 0x82, 0x14, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xB0, 0x00, 0x01,
	0xE4, 0x44, 0x29, 0x11, 0x09, 0x00, 0x52, 0x22, 0x22, 0x51, 0x21, 0x24,
	0x20, 0x00, 0x37, 0xCA, 0x44, 0x42, 0x84, 0x45, 0x0A, 0x10, 0x81, 0xC4,
	0x14, 0x40, 0xC2, 0x10, 0x82, 0x19, 0x4C, 0x71, 0xC2, 0x00, 0x01, 0x00,
	0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0xFE, 0x00, 0x00, 0x01, 0xFC,
	0xF1, 0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xC0, 0x80,
	0x00, 0x00, 0x00, 0x0F, 0x1C, 0x00,

	// Scan Line #3.
	0x7E, 0x3F, 0x0D, 0x81, 0x01, 0x80, 0xC0, 0x01, 0xFE, 0x00, 0x7F, 0x8F,
	0xC7, 0x81, 0xF1, 0xF8, 0x60, 0x80, 0x01, 0x0C, 0x19, 0x8F, 0xE3, 0xE0,
	0x00, 0x60, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC3, 0xFC, 0x05,
	0x24, 0x84, 0x60, 0x48, 0x24, 0x40, 0x00, 0x00, 0x00, 0x02, 0x84, 0xC4,
	0x28, 0x43, 0x20, 0x42, 0x85, 0x0A, 0x10, 0x02, 0x00, 0x84, 0x50, 0x92,
	0x42, 0x85, 0x12, 0x08, 0x21, 0x42, 0x82, 0x89, 0x06, 0x36, 0x50, 0xA1,
	0x42, 0x21, 0x42, 0x10, 0x85, 0x05, 0x05, 0x05, 0x04, 0x05, 0x10, 0x04,
	0x40, 0x08, 0x04, 0x00, 0x04, 0x01, 0x00, 0x82, 0x14, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0xC8, 0x02,
	0x14, 0x48, 0x45, 0x10, 0x86, 0x00, 0x8A, 0x21, 0x22, 0x88, 0x80, 0x18,
	0x00, 0x00, 0x4C, 0x11, 0x44, 0x24, 0x42, 0x44, 0x00, 0x03, 0xE2, 0x24,
	0x14, 0x41, 0x24, 0x21, 0x04, 0x26, 0x00, 0x0A, 0x22, 0x00, 0x01, 0x08,
	0x42, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x42, 0x00, 0x00, 0x00, 0x21,
	0x0A, 0x05, 0x00, 0x00, 0x08, 0xE7, 0x80, 0x04, 0x20, 0x0A, 0x20, 0x98,
	0x01, 0xC0, 0x00, 0xE8, 0xA4, 0x00,

	// Scan Line #4.
	0xA5, 0x6D, 0x9F, 0xC3, 0x83, 0xC1, 0xE0, 0x01, 0xFE, 0x3C, 0x61, 0x83,
	0x4C, 0xC1, 0xB1, 0x99, 0x68, 0xE0, 0x07, 0x1E, 0x19, 0x9B, 0x66, 0x10,
	0x00, 0xF0, 0x78, 0x18, 0x02, 0x08, 0x00, 0x02, 0x41, 0xE1, 0xF8, 0x05,
	0x24, 0x8E, 0x62, 0x48, 0x28, 0x24, 0x42, 0x00, 0x00, 0x04, 0x8D, 0x40,
	0x20, 0x45, 0x20, 0x40, 0x05, 0x0A, 0x16, 0x04, 0x00, 0x44, 0x50, 0xA1,
	0x42, 0x81, 0x0A, 0x08, 0x20, 0x42, 0x82, 0x91, 0x05, 0x56, 0x50, 0xA1,
	0x42, 0x21, 0x40, 0x10, 0x85, 0x05, 0x04, 0x88, 0x88, 0x09, 0x08, 0x04,
	0xA0, 0x08, 0x04, 0x00, 0x04, 0x02, 0x80, 0x80, 0x04, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x08, 0x89, 0x30, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x18,
	0xF8, 0x00, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF2, 0x14, 0x92, 0x02,
	0x24, 0x41, 0x00, 0x00, 0x00, 0x00, 0x42, 0x7A, 0x20, 0x00, 0x01, 0x10,
	0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1E, 0x42, 0x00, 0x20, 0x00, 0x00, 0x00, 0xF9,
	0x0A, 0x04, 0x80, 0x00, 0xF1, 0x08, 0x5F, 0x84, 0x18, 0x32, 0x00, 0x98,
	0xCA, 0x20, 0x01, 0x08, 0x88, 0x00,

	// Scan Line #5.
	0xA5, 0x6D, 0x9F, 0xC7, 0xC3, 0xC3, 0xF0, 0x61, 0xFE, 0x7E, 0x4C, 0x86,
	0x4C, 0xC1, 0xF1, 0xF8, 0xF0, 0xF8, 0x1F, 0x3F, 0x19, 0x9B, 0x63, 0xC0,
	0x01, 0xF8, 0xFC, 0x18, 0x03, 0x18, 0x18, 0x06, 0x61, 0xE1, 0xF8, 0x04,
	0x0F, 0xD1, 0x04, 0x30, 0x48, 0x22, 0x82, 0x00, 0x00, 0x08, 0x94, 0x40,
	0x40, 0x49, 0x3E, 0x40, 0x09, 0x0A, 0x16, 0xC8, 0x7C, 0x20, 0x93, 0xA1,
	0x42, 0x81, 0x0A, 0x08, 0x20, 0x42, 0x82, 0xA1, 0x04, 0x95, 0x50, 0xA1,
	0x42, 0x21, 0x40, 0x10, 0x85, 0x05, 0x04, 0x50, 0x50, 0x11, 0x04, 0x05,
	0x10, 0x04, 0xE7, 0x8F, 0x3C, 0xE2, 0x1E, 0xF2, 0x14, 0x97, 0x67, 0x8E,
	0x78, 0xF7, 0x8F, 0x74, 0x51, 0x44, 0x52, 0x8B, 0xC8, 0x88, 0x00, 0x42,
	0x04, 0x4E, 0x38, 0xE3, 0x8E, 0x42, 0x71, 0xC7, 0x08, 0x21, 0x12, 0x24,
	0x81, 0xDC, 0x84, 0x0E, 0x38, 0xE4, 0x51, 0x45, 0x0A, 0x14, 0x82, 0x01,
	0x47, 0x81, 0x07, 0x11, 0xC8, 0xBC, 0x62, 0x8A, 0x22, 0x00, 0x01, 0x20,
	0x49, 0x22, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0xA1, 0x40, 0xFE, 0x10, 0x7E, 0x44, 0xDD, 0x05,
	0x0A, 0x04, 0x43, 0xB9, 0x1A, 0x08, 0x40, 0x3F, 0x86, 0xC2, 0x00, 0x81,
	0x32, 0x20, 0x01, 0x08, 0x90, 0x00,

	// Scan Line #6.
	0x81, 0x7F, 0x9F, 0xCF, 0xEF, 0xF7, 0xF8, 0xF1, 0xCE, 0x66, 0x5E, 0x9F,
	0x0C, 0xC1, 0x81, 0x9B, 0x9C, 0xFE, 0x7F, 0x0C, 0x19, 0x9B, 0x66, 0x60,
	0x00, 0x60, 0x30, 0x18, 0x7F, 0xBF, 0xD8, 0x0F, 0xF3, 0xF0, 0xF0, 0x04,
	0x04, 0x90, 0x08, 0x52, 0x08, 0x2F, 0xEF, 0x83, 0xE0, 0x10, 0xA4, 0x40,
	0x83, 0x91, 0x01, 0x7C, 0x10, 0xF1, 0xF0, 0xD0, 0x00, 0x11, 0x12, 0xBF,
	0x7C, 0x81, 0x0B, 0xCF, 0x23, 0x7E, 0x82, 0xC1, 0x04, 0x15, 0x50, 0xBE,
	0x42, 0x3E, 0x3C, 0x10, 0x85, 0x05, 0x04, 0x20, 0x20, 0x21, 0x02, 0x04,
	0x00, 0x00, 0x14, 0x50, 0x45, 0x17, 0x22, 0x8A, 0x15, 0x14, 0x94, 0x51,
	0x45, 0x14, 0x50, 0x24, 0x51, 0x44, 0x52, 0x88, 0x50, 0x04, 0x00, 0xA2,
	0x04, 0x51, 0x04, 0x10, 0x41, 0x40, 0x8A, 0x28, 0x88, 0x21, 0x21, 0x42,
	0x80, 0x22, 0xFF, 0x91, 0x45, 0x14, 0x51, 0x45, 0x0A, 0x14, 0x87, 0x83,
	0xE4, 0x43, 0x80, 0x92, 0x28, 0xA2, 0x52, 0x8A, 0x22, 0x00, 0x01, 0x4E,
	0x53, 0x24, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x25, 0x2E, 0x40, 0x44, 0x08, 0x88, 0x45, 0x21, 0x05,
	0xFA, 0x04, 0xE4, 0x45, 0x2B, 0xC8, 0x5F, 0x84, 0x0C, 0x62, 0x00, 0xBC,
	0x01, 0xC0, 0x02, 0x08, 0xBD, 0xC0,

	// Scan Line #7.
	0xBD, 0x7F, 0x9F, 0xC7, 0xCF, 0xF7, 0xF8, 0xF1, 0xCE, 0x66, 0x5E, 0xB1,
	0x87, 0x81, 0x81, 0x9B, 0x9C, 0xFC, 0x3F, 0x0C, 0x19, 0x8F, 0x66, 0x60,
	0x01, 0xF8, 0x30, 0x18, 0x7F, 0xBF, 0xD8, 0x0F, 0xF3, 0xF0, 0xF0, 0x04,
	0x0F, 0xCE, 0x10, 0x8C, 0x08, 0x22, 0x82, 0x00, 0x00, 0x20, 0xC4, 0x41,
	0x00, 0x5F, 0x81, 0x42, 0x21, 0x08, 0x10, 0x08, 0x7C, 0x21, 0x13, 0x21,
	0x42, 0x81, 0x0A, 0x08, 0x21, 0x42, 0x82, 0xA1, 0x04, 0x14, 0xD0, 0xA0,
	0x46, 0x22, 0x02, 0x10, 0x85, 0x05, 0x24, 0x50, 0x20, 0x41, 0x01, 0x04,
	0x00, 0x00, 0xF4, 0x50, 0x45, 0xF2, 0x22, 0x8A, 0x16, 0x14, 0x94, 0x51,
	0x45, 0x14, 0x0E, 0x24, 0x51, 0x44, 0x4C, 0x88, 0x88, 0x88, 0x01, 0x12,
	0x04, 0x5F, 0x3C, 0xF3, 0xCF, 0x40, 0xFB, 0xEF, 0x88, 0x21, 0x21, 0x42,
	0xF1, 0xFE, 0x84, 0x11, 0x45, 0x14, 0x51, 0x45, 0x0A, 0x14, 0x92, 0x00,
	0x84, 0xE1, 0x07, 0x92, 0x28, 0xA2, 0x4A, 0x79, 0xC4, 0x00, 0x00, 0x92,
	0x25, 0x29, 0x04, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x22, 0x21, 0x40, 0x44, 0x10, 0x88, 0x45, 0x21, 0x05,
	0x09, 0x09, 0x14, 0x45, 0x4A, 0x08, 0x40, 0x04, 0x30, 0x1A, 0x00, 0x80,
	0xC8, 0x00, 0x02, 0x00, 0x01, 0x40,

	// Scan Line #8.
	0x99, 0x61, 0x8F, 0x83, 0x8D, 0xB3, 0xF0, 0x61, 0xFE, 0x7E, 0x4C, 0xB1,
	0x83, 0x07, 0x83, 0xB8, 0xF0, 0xF0, 0x0F, 0x3F, 0x00, 0x03, 0x63, 0xC7,
	0xF8, 0xF0, 0x30, 0x7E, 0x03, 0x18, 0x1F, 0xE6, 0x67, 0xF8, 0x60, 0x00,
	0x04, 0x81, 0x20, 0x84, 0x08, 0x24, 0x42, 0x00, 0x00, 0x40, 0x84, 0x42,
	0x00, 0x41, 0x01, 0x42, 0x21, 0x08, 0x16, 0x04, 0x00, 0x40, 0x10, 0x21,
	0x42, 0x81, 0x0A, 0x08, 0x21, 0x42, 0xA2, 0x91, 0x04, 0x14, 0xD0, 0xA0,
	0x42, 0x21, 0x02, 0x10, 0x84, 0x89, 0x54, 0x88, 0x20, 0x81, 0x00, 0x84,
	0x00, 0x01, 0x14, 0x50, 0x45, 0x02, 0x22, 0x8A, 0x15, 0x14, 0x94, 0x51,
	0x45, 0x14, 0x01, 0x24, 0x51, 0x44, 0x4C, 0x89, 0x08, 0x88, 0x02, 0x0A,
	0x14, 0x50, 0x45, 0x14, 0x51, 0x42, 0x82, 0x08, 0x08, 0x21, 0x3F, 0x7E,
	0x82, 0x20, 0x84, 0x11, 0x45, 0x14, 0x51, 0x45, 0x0A, 0x13, 0xE2, 0x03,
	0xE4, 0x41, 0x08, 0x92, 0x28, 0xA2, 0x4A, 0x00, 0x08, 0xBE, 0xF9, 0x04,
	0x4F, 0xA4, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x22, 0x21, 0x40, 0x44, 0x20, 0x88, 0x44, 0x20, 0xF9,
	0x09, 0x09, 0x14, 0x45, 0x89, 0x08, 0x5F, 0x80, 0x00, 0x02, 0x00, 0x99,
	0x30, 0x0C, 0x24, 0x00, 0x01, 0x40,

	// Scan Line #9.
	0x81, 0x73, 0x87, 0x01, 0x01, 0x80, 0xC0, 0x01, 0xFE, 0x3C, 0x61, 0xB1,
	0x8F, 0xCF, 0x87, 0xB9, 0x68, 0xC0, 0x03, 0x1E, 0x19, 0x83, 0x68, 0x67,
	0xF8, 0x60, 0x30, 0x3C, 0x02, 0x08, 0x00, 0x02, 0x47, 0xF8, 0x60, 0x04,
	0x04, 0x91, 0x46, 0x86, 0x04, 0x40, 0x00, 0x18, 0x0C, 0x80, 0x84, 0x44,
	0x28, 0x41, 0x21, 0x42, 0x21, 0x0A, 0x16, 0xC2, 0x00, 0x81, 0x10, 0x21,
	0x42, 0x85, 0x12, 0x08, 0x21, 0x42, 0xA2, 0x89, 0x04, 0x14, 0x50, 0xA0,
	0x43, 0x21, 0x42, 0x10, 0x84, 0x51, 0x8D, 0x04, 0x21, 0x01, 0x00, 0x44,
	0x00, 0x01, 0x14, 0x50, 0x45, 0x12, 0x22, 0x8A, 0x14, 0x94, 0x94, 0x51,
	0x45, 0x14, 0x01, 0x24, 0x4A, 0x2A, 0x92, 0x8A, 0x08, 0x88, 0x02, 0x09,
	0xE4, 0x51, 0x45, 0x14, 0x51, 0x3C, 0x8A, 0x28, 0x88, 0x21, 0x21, 0x42,
	0x82, 0x22, 0x84, 0x11, 0x45, 0x14, 0x51, 0x45, 0x0A, 0x10, 0x82, 0x10,
	0x84, 0x41, 0x08, 0x92, 0x28, 0xA2, 0x46, 0xFB, 0xE8, 0xA0, 0x0A, 0x08,
	0x81, 0x22, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x25, 0x3E, 0x40, 0x44, 0x42, 0x88, 0x78, 0x20, 0x21,
	0x08, 0x91, 0x13, 0xB8, 0xF0, 0xE8, 0x40, 0x3F, 0xFE, 0xFA, 0x00, 0x98,
	0x00, 0x0D, 0x94, 0x00, 0x01, 0x40,

	// Scan Line #10.
	0x7E, 0x3F, 0x02, 0x00, 0x03, 0xC1, 0xE0, 0x01, 0xFE, 0x00, 0x7F, 0x9F,
	0x03, 0x07, 0x03, 0x80, 0x60, 0x00, 0x00, 0x0C, 0x19, 0x83, 0x67, 0xC7,
	0xFB, 0xFC, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
	0x04, 0x8E, 0x06, 0x79, 0x02, 0x80, 0x00, 0x18, 0x0C, 0x00, 0x79, 0xF7,
	0xE7, 0x83, 0x9E, 0x3C, 0x20, 0xF1, 0xE0, 0xC1, 0x01, 0x01, 0x0F, 0xA1,
	0x7C, 0x79, 0xE3, 0xE8, 0x1E, 0x42, 0x9C, 0x85, 0xF4, 0x14, 0x4F, 0x20,
	0x3C, 0xA1, 0x3C, 0x10, 0x78, 0x21, 0x05, 0x04, 0x21, 0xFD, 0xC0, 0x1C,
	0x00, 0x00, 0xF7, 0x8F, 0x3C, 0xE2, 0x1E, 0x8A, 0x14, 0x54, 0x94, 0x4E,
	0x78, 0xF4, 0x1E, 0x23, 0xC4, 0x11, 0x12, 0x7B, 0xC6, 0xB0, 0x03, 0xF8,
	0x43, 0xCE, 0x3C, 0xF3, 0xCF, 0x08, 0x71, 0xC7, 0x08, 0x21, 0x21, 0x42,
	0xF9, 0xFC, 0x87, 0xCE, 0x38, 0xE3, 0xCF, 0x3C, 0xF1, 0xE0, 0x87, 0xE0,
	0x84, 0x21, 0x07, 0x91, 0xC7, 0xA2, 0x42, 0x00, 0x07, 0x20, 0x08, 0x1E,
	0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0xA0, 0x40, 0x44, 0xFE, 0x70, 0x40, 0x21, 0xFC,
	0xF3, 0x9C, 0xE0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x80,
	0x00, 0x0D, 0x88, 0x00, 0x01, 0xC0,

	// Scan Line #11.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 0x00,
	0x40, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02,
	0x20, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x08, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	// Scan Line #12.
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0xE0, 0x00, 0x00, 0x00,
	0x40, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x01,
	0xC0, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


static FONT oem_smal =
{
	oem_smal_offset_table,
	oem_smal_data_table,

	186,		// The number of bytes in each row of the bitmap.
	 12,		// The number of rows in the bitmap.
	  0,		// The first character in the bitmap.
	255,		// The last character in the bitmap.
	 11,		// The widest character, in bits.
	  9,		// The distance from the baseline to the top of a character.
	 10,		// The distance from the top to the underline bar.
	  0 		// The flag for a ROM resident font.
};

FONT *GFX_oem_smal_font (void)
{
	return (&oem_smal);
}
