//  POSTWN.CPP (POSTWN) - Loading and storing a persistant window.
//  COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//  Zinc Software Incorporated.  Pleasant Grove, Utah  USA
//  May be freely copied, used and distributed.

#include <ui_win.hpp>
#define USE_DERIVED_OBJECTS
#include "postwn.hpp"

// This user function saves the window in the designated .data file.
EVENT_TYPE SaveData(UI_WINDOW_OBJECT *object, UI_EVENT &, EVENT_TYPE ccode)
{
	
	if (ccode != L_SELECT)
		return(ccode);

	ZIL_STORAGE *storage = new ZIL_STORAGE("p_postwn.dat", UIS_READWRITE);
	
	// Save the data.
	object->parent->Store("PERSONAL_DATA", storage);
	storage->Save();
	
	// Clean up.
	delete storage;
	
	object->eventManager->Put(L_EXIT);
	return(ccode);
}

// ----- UI_APPLICATION::Main -----------------------------------------------

int UI_APPLICATION::Main(void)
{
	// The UI_APPLICATION constructor automatically initializes the
	// display, eventManager, and windowManager variables.

	// This line fixes linkers that don't look for main in the .LIBs.
	UI_APPLICATION::LinkMain();

	UI_WINDOW_OBJECT::errorSystem = new UI_ERROR_SYSTEM;

	UI_WINDOW_OBJECT::defaultStorage = new ZIL_STORAGE("p_postwn.dat");

	// Check to see if the default storage was allocated.
	if (UI_WINDOW_OBJECT::defaultStorage->storageError)
	{
		UI_WINDOW_OBJECT::errorSystem->ReportError(windowManager, WOS_NO_STATUS,
			"ERROR: Unable to open or find the file \"p_postwn.dat\".");
		delete UI_WINDOW_OBJECT::defaultStorage;
		delete UI_WINDOW_OBJECT::errorSystem;
		return (0);
	}

	// Add the window to the window manager.
	UI_WINDOW_OBJECT *window = UI_WINDOW_OBJECT::New("p_postwn.dat~PERSONAL_DATA");
	*windowManager
		+ window;
	
	// Process user responses.
	UI_APPLICATION::Control();

	// Clean up.
	delete UI_WINDOW_OBJECT::defaultStorage;
	delete UI_WINDOW_OBJECT::errorSystem;

	return (0);
}

// --------------------------------------------------------------------------
// From code file generated by designer -------------------------------------
// --------------------------------------------------------------------------
#if defined(ZIL_LINKBUG)
void z_jump_dummy(void) { } // Bug fix for broken linkers.
#endif

extern EVENT_TYPE SaveData(UI_WINDOW_OBJECT *, UI_EVENT &, EVENT_TYPE);

static ZIL_ICHAR _SaveData[] = { 'S','a','v','e','D','a','t','a',0 };

static UI_ITEM _userTable[] =
{
	{ 0, (EVENT_TYPE*)ZIL_VOIDF(SaveData), _SaveData, 0 },
	{ ID_END, ZIL_NULLP(void), ZIL_NULLP(ZIL_ICHAR), 0 }
};
UI_ITEM *UI_WINDOW_OBJECT::userTable = _userTable;

static UI_ITEM _objectTable[] =
{
	{ ID_BIGNUM, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_BIGNUM::New), UIW_BIGNUM::_className, 0 },
	{ ID_BORDER, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_BORDER::New), UIW_BORDER::_className, 0 },
	{ ID_BUTTON, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_BUTTON::New), UIW_BUTTON::_className, 0 },
	{ ID_MAXIMIZE_BUTTON, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_MAXIMIZE_BUTTON::New), UIW_MAXIMIZE_BUTTON::_className, 0 },
	{ ID_MINIMIZE_BUTTON, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_MINIMIZE_BUTTON::New), UIW_MINIMIZE_BUTTON::_className, 0 },
	{ ID_PROMPT, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_PROMPT::New), UIW_PROMPT::_className, 0 },
	{ ID_STRING, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_STRING::New), UIW_STRING::_className, 0 },
	{ ID_SYSTEM_BUTTON, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_SYSTEM_BUTTON::New), UIW_SYSTEM_BUTTON::_className, 0 },
	{ ID_TITLE, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_TITLE::New), UIW_TITLE::_className, 0 },
	{ ID_WINDOW, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_WINDOW::New), UIW_WINDOW::_className, 0 },
	{ ID_END, ZIL_NULLP(void), ZIL_NULLP(ZIL_ICHAR), 0 }
};
UI_ITEM *UI_WINDOW_OBJECT::objectTable = _objectTable;
