//	Zinc Interface Library - MAP1256.CPP
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

/*       This file is a part of OpenZinc

          OpenZinc is free software; you can redistribute it and/or modify it under
          the terms of the GNU Lessor General Public License as published by
          the Free Software Foundation, either version 3 of the License, or (at
          your option) any later version

	OpenZinc is distributed in the hope that it will be useful, but WITHOUT
          ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
          or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
          General Public License for more details.

          You should have received a copy of the GNU Lessor General Public License
	 along with OpenZinc. If not, see <http://www.gnu.org/licenses/>                          */


static ZIL_ICHAR _MapName[] = { 'I','B','M','_','1','2','5','6',0 };

#if defined(ZIL_UNICODE)
static ZIL_ICHAR _ISOToLocal[256] = 
{
	// Hard coded map for IBM_1256 character encoding.
	0x0000,      0,      0,      0,      0,      0,      0,      0, 
	     0, 0x0009, 0x000a,      0, 0x000c, 0x000d,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	     0,      0,      0,      0,      0,      0,      0,      0, 
	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
	0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
	0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
	0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
	0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
	0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
	0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
	0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f, 
	0x060c, 0x0660, 0x201a, 0x0661, 0x201e, 0x2026, 0x2020, 0x2021, 
	0x0662, 0x0663, 0x0664, 0x2039, 0x0665, 0x0666, 0x0667, 0x0668, 
	0x0669, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, 
	0x061b, 0x2122, 0x061f, 0x203a, 0x0621, 0x0622, 0x0623, 0x0178, 
	0x00a0, 0x0624, 0x0625, 0x00a3, 0x00a4, 0x0626, 0x00a6, 0x00a7, 
	0x0627, 0x00a9, 0x0628, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x067e, 
	0x00b0, 0x00b1, 0x0629, 0x062a, 0x062b, 0x00b5, 0x00b6, 0x00b7, 
	0x062c, 0x0686, 0x062d, 0x00bb, 0x062e, 0x062f, 0x0630, 0x0631, 
	0x00c0, 0x0632, 0x00c2, 0x0698, 0x0633, 0x0634, 0x0635, 0x00c7, 
	0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x0636, 0x0637, 0x00ce, 0x00cf, 
	0x0638, 0x0639, 0x063a, 0x0640, 0x00d4, 0x0641, 0x0642, 0x00d7, 
	0x0643, 0x00d9, 0x06af, 0x00db, 0x00dc, 0x0644, 0x0645, 0x0646, 
	0x00e0, 0x0647, 0x00e2, 0x06c0, 0x0648, 0x0649, 0x064a, 0x00e7, 
	0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x064b, 0x064c, 0x00ee, 0x00ef, 
	0x064d, 0x064e, 0x064f, 0x0650, 0x00f4, 0x0651, 0x0652, 0x00f7, 
	     0, 0x00f9,      0, 0x00fb, 0x00fc, 0x200e, 0x200f, 0x00ff, 
};
static ZIL_ICHAR *_LocalToISO = ZIL_NULLP(ZIL_ICHAR);
#else
static ZIL_UINT8 _ISOToLocal[256] =
{
	// Hard coded map for IBM_1256 character encoding.
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xbf, 0xc0, 0xc1, 
	0xc2, 0xc3, 0xc4, 0xc5, 0xd9, 0xda, 0x00, 0x00, 
	0xdf, 0xdc, 0xdb, 0xba, 0xb9, 0xbb, 0xc8, 0xca, 
	0xcb, 0xcc, 0xcd, 0xce, 0xbc, 0xc9, 0xfe, 0x00, 
	0xa0,    0,    0, 0xa3, 0xa4,    0, 0xa6, 0xa7, 
	   0, 0xa9,    0, 0xab, 0xac, 0xad, 0xae,    0, 
	0xb0, 0xb1,    0,    0,    0, 0xb5, 0xb6, 0xb7, 
	   0,    0,    0, 0xbb,    0,    0,    0,    0, 
	0xc0,    0, 0xc2,    0,    0,    0,    0, 0xc7, 
	0xc8, 0xc9, 0xca, 0xcb,    0,    0, 0xce, 0xcf, 
	   0,    0,    0,    0, 0xd4,    0,    0, 0xd7, 
	   0, 0xd9,    0, 0xdb, 0xdc,    0,    0,    0, 
	0xe0,    0, 0xe2,    0,    0,    0,    0, 0xe7, 
	0xe8, 0xe9, 0xea, 0xeb,    0,    0, 0xee, 0xef, 
	   0,    0,    0,    0, 0xf4,    0,    0, 0xf7, 
	   0, 0xf9,    0, 0xfb, 0xfc,    0,    0, 0xff, 
};
static ZIL_UINT8 _LocalToISO[256] =
{
	// Hard coded map for IBM_1256 character encoding.
	0x00,    0,    0,    0,    0,    0,    0,    0, 
	   0, 0x09, 0x0a,    0, 0x0c, 0x0d,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0, 
	0xa0,    0,    0, 0xa3, 0xa4,    0, 0xa6, 0xa7, 
	   0, 0xa9,    0, 0xab, 0xac, 0xad, 0xae,    0, 
	0xb0, 0xb1,    0,    0,    0, 0xb5, 0xb6, 0xb7, 
	   0,    0,    0, 0xbb,    0,    0,    0,    0, 
	0xc0,    0, 0xc2,    0,    0,    0,    0, 0xc7, 
	0xc8, 0xc9, 0xca, 0xcb,    0,    0, 0xce, 0xcf, 
	   0,    0,    0,    0, 0xd4,    0,    0, 0xd7, 
	   0, 0xd9,    0, 0xdb, 0xdc,    0,    0,    0, 
	0xe0,    0, 0xe2,    0,    0,    0,    0, 0xe7, 
	0xe8, 0xe9, 0xea, 0xeb,    0,    0, 0xee, 0xef, 
	   0,    0,    0,    0, 0xf4,    0,    0, 0xf7, 
	   0, 0xf9,    0, 0xfb, 0xfc,    0,    0, 0xff, 
};
#endif
