//	MENUS.CPP (MENUS) - Simple menu manipulation program.
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
//	May be freely copied, used and distributed.

#include <ui_win.hpp>

EVENT_TYPE ToggleFile(UI_WINDOW_OBJECT *object, UI_EVENT &, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return (ccode);

	UI_WINDOW_OBJECT *file = object->Root()->Get("FILE");

	file->woFlags ^= WOF_NON_SELECTABLE;
	file->Information(I_CHANGED_FLAGS, ZIL_NULLP(void));
	file->Event(S_REDISPLAY);

	return (ccode);
}

EVENT_TYPE TogglePaste(UI_WINDOW_OBJECT *object, UI_EVENT &, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return (ccode);

	UI_WINDOW_OBJECT *paste = object->Root()->Get("PASTE");

	paste->woFlags ^= WOF_NON_SELECTABLE;
	paste->Information(I_CHANGED_FLAGS, ZIL_NULLP(void));

	return (ccode);
}

EVENT_TYPE ToggleZoom(UI_WINDOW_OBJECT *object, UI_EVENT &, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return (ccode);

	UI_WINDOW_OBJECT *zoom = object->Root()->Get("ZOOM");

	zoom->woStatus ^= WOS_SELECTED;
	zoom->Information(I_CHANGED_FLAGS, ZIL_NULLP(void));

	return (ccode);
}

int UI_APPLICATION::Main()
{
	// This line fixes linkers that don't look for main in the .LIBs.
	UI_APPLICATION::LinkMain();

	UI_WINDOW_OBJECT::defaultStorage = new ZIL_STORAGE("p_menus.dat");

	// Check to see if the default storage was allocated.
	if (UI_WINDOW_OBJECT::defaultStorage->storageError)
	{
		delete UI_WINDOW_OBJECT::defaultStorage;
		return(-1);
	}

	UIW_WINDOW *win = new UIW_WINDOW("RESOURCE_1", UI_WINDOW_OBJECT::defaultStorage);

	windowManager->Center(win);

	*windowManager + win;

	Control();

	delete UI_WINDOW_OBJECT::defaultStorage;
	return (0);
}

//---------------------------- Generated by the designer -------------------
void z_jump_dummy(void) { }   // Bug fix for broken linkers.

static ZIL_ICHAR _ToggleFile[] = { 'T','o','g','g','l','e','F','i','l','e',0 };
static ZIL_ICHAR _TogglePaste[] = { 'T','o','g','g','l','e','P','a','s','t','e',0 };
static ZIL_ICHAR _ToggleZoom[] = { 'T','o','g','g','l','e','Z','o','o','m',0 };

static UI_ITEM _userTable[] =
{
	{ 0, (EVENT_TYPE*)ZIL_VOIDF(ToggleFile), _ToggleFile, 0 },
	{ 0, (EVENT_TYPE*)ZIL_VOIDF(TogglePaste), _TogglePaste, 0 },
	{ 0, (EVENT_TYPE*)ZIL_VOIDF(ToggleZoom), _ToggleZoom, 0 },
	{ ID_END, ZIL_NULLP(void), ZIL_NULLP(ZIL_ICHAR), 0 }
};
UI_ITEM *UI_WINDOW_OBJECT::userTable = _userTable;

static UI_ITEM _objectTable[] =
{
	{ ID_BORDER, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_BORDER::New), UIW_BORDER::_className, 0 },
	{ ID_BUTTON, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_BUTTON::New), UIW_BUTTON::_className, 0 },
	{ ID_MAXIMIZE_BUTTON, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_MAXIMIZE_BUTTON::New), UIW_MAXIMIZE_BUTTON::_className, 0 },
	{ ID_MINIMIZE_BUTTON, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_MINIMIZE_BUTTON::New), UIW_MINIMIZE_BUTTON::_className, 0 },
	{ ID_POP_UP_ITEM, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_POP_UP_ITEM::New), UIW_POP_UP_ITEM::_className, 0 },
	{ ID_POP_UP_MENU, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_POP_UP_MENU::New), UIW_POP_UP_MENU::_className, 0 },
	{ ID_PULL_DOWN_ITEM, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_PULL_DOWN_ITEM::New), UIW_PULL_DOWN_ITEM::_className, 0 },
	{ ID_PULL_DOWN_MENU, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_PULL_DOWN_MENU::New), UIW_PULL_DOWN_MENU::_className, 0 },
	{ ID_SYSTEM_BUTTON, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_SYSTEM_BUTTON::New), UIW_SYSTEM_BUTTON::_className, 0 },
	{ ID_TITLE, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_TITLE::New), UIW_TITLE::_className, 0 },
	{ ID_TOOL_BAR, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_TOOL_BAR::New), UIW_TOOL_BAR::_className, 0 },
	{ ID_WINDOW, (UI_WINDOW_OBJECT*)ZIL_VOIDF(UIW_WINDOW::New), UIW_WINDOW::_className, 0 },
	{ ID_END, ZIL_NULLP(void), ZIL_NULLP(ZIL_ICHAR), 0 }
};
UI_ITEM *UI_WINDOW_OBJECT::objectTable = _objectTable;
