//	Zinc Interface Library - G_PNORM.CPP
//	COPYRIGHT (C) 1990-1995.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

/*       This file is a part of OpenZinc

          OpenZinc is free software; you can redistribute it and/or modify it under
          the terms of the GNU Lessor General Public License as published by
          the Free Software Foundation, either version 3 of the License, or (at
          your option) any later version

	OpenZinc is distributed in the hope that it will be useful, but WITHOUT
          ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
          or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
          General Public License for more details.

          You should have received a copy of the GNU Lessor General Public License
	 along with OpenZinc. If not, see <http://www.gnu.org/licenses/>                          */


#include "ui_win.hpp"

void z_pnorm_dummy(void) { } // Bug fix for broken linkers.

// --------------------------------------------------------------------------
// ----- ZIL_MSDOS ----------------------------------------------------------
// --------------------------------------------------------------------------

// ----- ZIL_SHADOW_BORDER --------------------------------------------------

#if defined(ZIL_MSDOS) && defined(ZIL_MSWINDOWS_STYLE) && defined(ZIL_SHADOW_BORDER)
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_SELECTED,
		{ ' ', attrib(BLACK, LIGHTCYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(BLUE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_HOT_KEY,
		{ ' ', attrib(BLUE, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_MENU_ITEM, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(BLUE, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(CYAN, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(CYAN, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_MENU_ITEM, PM_HOT_KEY,
		{ ' ', attrib(BLUE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TABLE_HEADER, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TABLE, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_WINDOW, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_LIST_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_SELECTED | PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_LIST_ITEM, PM_SELECTED,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_LIST_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_GROUP, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, BACKGROUND, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_GROUP, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BACKGROUND, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(ZIL_UNICODE)
 		{ 0x2591, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#elif defined(ZIL_ISO8859_1)
 		{ 0x80, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0xb0, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_MENU, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_ICON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, DARKGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_PROMPT, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(BLUE, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, BLACK, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BORDER, PM_ACTIVE,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_INTERLEAVE_FILL, BLACK, MAGENTA, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_SPECIAL,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, CYAN, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_BAR, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, RED, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, GREEN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, GREEN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(ZIL_UNICODE)
 		{ 0x2591, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#elif defined(ZIL_ISO8859_1)
 		{ 0x80, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0xb0, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif

// ----- ZIL_STANDARD_BORDER ------------------------------------------------

#if defined(ZIL_MSDOS) && defined(ZIL_MSWINDOWS_STYLE) && defined(ZIL_STANDARD_BORDER)
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_SELECTED,
		{ ' ', attrib(BLACK, LIGHTCYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_MENU_ITEM, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, CYAN), attrib(MONO_DIM, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(CYAN, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_MENU_ITEM, PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TABLE_HEADER, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TABLE, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_WINDOW, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_LIST_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_SELECTED | PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_LIST_ITEM, PM_SELECTED,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_LIST_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_GROUP, PM_NON_SELECTABLE,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, BACKGROUND, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_GROUP, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, BACKGROUND, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(ZIL_UNICODE)
 		{ 0x2591, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#elif defined(ZIL_ISO8859_1)
 		{ 0x80, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0xb0, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(BLACK, BLUE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_MENU, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_ICON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, DARKGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_PROMPT, PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, BLUE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, WHITE, BLACK, BW_WHITE, BW_BLACK, GS_GRAY, GS_WHITE } },
	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Support objects.
	{ ID_BORDER, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_HIGH, MONO_BLACK),
		PTN_INTERLEAVE_FILL, BLACK, MAGENTA, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_SPECIAL,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, CYAN, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, MAGENTA), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_BAR, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, WHITE, WHITE, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, RED, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, GREEN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, GREEN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(ZIL_UNICODE)
 		{ 0x2591, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#elif defined(ZIL_ISO8859_1)
 		{ 0x80, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0xb0, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif

// ----- ZIL_3D_BORDER -------------------------------------------------------

#if defined(ZIL_MSDOS) && defined(ZIL_MSWINDOWS_STYLE) && defined(ZIL_3D_BORDER)
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_CURRENT,
		{ ' ', attrib(CYAN, BLACK), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_SELECTED,
		{ ' ', attrib(CYAN, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
	{ ID_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(LIGHTCYAN, BLACK), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_CURRENT,
		{ ' ', attrib(CYAN, BLACK), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
	{ ID_BUTTON, PM_ACTIVE | PM_HOT_KEY,
		{ ' ', attrib(LIGHTCYAN, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_MENU_ITEM, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(LIGHTCYAN, BLACK), attrib(MONO_DIM, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_CURRENT,
		{ ' ', attrib(LIGHTGRAY, BLACK), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(DARKGRAY, CYAN), attrib(MONO_DIM, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, CYAN), attrib(MONO_DIM, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_MENU_ITEM, PM_HOT_KEY,
		{ ' ', attrib(LIGHTCYAN, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_WINDOW, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_LIST_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_SELECTED | PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_LIST_ITEM, PM_SELECTED,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_LIST_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_GROUP, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, BACKGROUND, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_GROUP, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BACKGROUND, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(ZIL_UNICODE)
 		{ 0x2591, attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
#elif defined(ZIL_ISO8859_1)
 		{ 0x80, attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0xb0, attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_MENU, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_PROMPT, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(LIGHTCYAN, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, WHITE, BLACK, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BORDER, PM_ACTIVE,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_INTERLEAVE_FILL, BLACK, MAGENTA, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_SPECIAL,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, CYAN, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ACTIVE,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_BAR, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTCYAN, CYAN), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTCYAN, CYAN), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, RED, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTCYAN, CYAN), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTCYAN, CYAN), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, GREEN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(ZIL_UNICODE)
 		{ 0x2591, attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
#elif defined(ZIL_ISO8859_1)
 		{ 0x80, attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0xb0, attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTCYAN, CYAN), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTCYAN, CYAN), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif

// ----- ZIL_OS2_STYLE ------------------------------------------------------

#if defined(ZIL_MSDOS) && defined(ZIL_OS2_STYLE)
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_CURRENT,
		{ ' ', attrib(CYAN, BLACK), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, DARKGRAY, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_SELECTED,
		{ ' ', attrib(BLACK, LIGHTCYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(BLUE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_HOT_KEY,
		{ ' ', attrib(BLUE, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_MENU_ITEM, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(BLUE, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, WHITE, DARKGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(CYAN, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(CYAN, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_MENU_ITEM, PM_HOT_KEY,
		{ ' ', attrib(BLUE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, DARKGRAY, YELLOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, YELLOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TABLE_HEADER, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TABLE, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_WINDOW, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_LIST_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, YELLOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_SELECTED | PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, DARKGRAY, BW_WHITE, BW_BLACK, GS_GRAY, GS_BLACK } },
	{ ID_LIST_ITEM, PM_SELECTED,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, WHITE, DARKGRAY, BW_WHITE, BW_BLACK, GS_GRAY, GS_BLACK } },
	{ ID_LIST_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, YELLOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, YELLOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_GROUP, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, DARKGRAY, BACKGROUND, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_GROUP, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BACKGROUND, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, YELLOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(ZIL_UNICODE)
 		{ 0x2591, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#elif defined(ZIL_ISO8859_1)
 		{ 0x80, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0xb0, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_INTERLEAVE_FILL, DARKGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_MENU, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_ICON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_PROMPT, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(BLUE, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, WHITE, BLACK, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLUE, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BORDER, PM_ACTIVE,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, YELLOW, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_SPECIAL,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, YELLOW, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
 	{ ID_STATUS_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_BAR, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, RED, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, GREEN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, GREEN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, YELLOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, YELLOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(ZIL_UNICODE)
 		{ 0x2591, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#elif defined(ZIL_ISO8859_1)
 		{ 0x80, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0xb0, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_INTERLEAVE_FILL, DARKGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif

// ----- ZIL_MOTIF_STYLE ----------------------------------------------------

#if defined(ZIL_MSDOS) && defined(ZIL_MOTIF_STYLE)
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, BLACK, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_SELECTED,
		{ ' ', attrib(BLACK, LIGHTCYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(BLUE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_HOT_KEY,
		{ ' ', attrib(BLUE, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_MENU_ITEM, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(BLUE, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(CYAN, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(CYAN, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_MENU_ITEM, PM_HOT_KEY,
		{ ' ', attrib(BLUE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_CURRENT,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TABLE_HEADER, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TABLE, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_WINDOW, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_LIST_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_SELECTED | PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, BLACK, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_SELECTED,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, BLACK, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_GROUP, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, DARKGRAY, BACKGROUND, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_GROUP, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BACKGROUND, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(ZIL_UNICODE)
 		{ 0x2591, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#elif defined(ZIL_ISO8859_1)
 		{ 0x80, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0xb0, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_BACKGROUND_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_MENU, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_ICON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_PROMPT, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(BLUE, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BORDER, PM_ACTIVE,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_INTERLEAVE_FILL, CYAN, CYAN, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_SPECIAL,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, CYAN, CYAN, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, CYAN, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, CYAN, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, CYAN, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, CYAN, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(WHITE, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, CYAN, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_BAR, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_WHITE, BW_WHITE, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, RED, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, GREEN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, GREEN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(ZIL_UNICODE)
 		{ 0x2591, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#elif defined(ZIL_ISO8859_1)
 		{ 0x80, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0xb0, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_BACKGROUND_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif

// --------------------------------------------------------------------------
// ----- ZIL_MSWINDOWS ------------------------------------------------------
// --------------------------------------------------------------------------

#if defined(ZIL_MSWINDOWS)
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_WINDOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

#if defined(ZIL_MSWINDOWS_CTL3D)
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_BTNFACE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_LIST, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_WINDOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
#endif

	{ ID_TEXT, PM_NON_SELECTABLE,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_GRAYTEXT, COLOR_WINDOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_WINDOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_CHECK_BOX, PM_NON_SELECTABLE,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_GRAYTEXT, BACKGROUND, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_CHECK_BOX, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, BACKGROUND, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_RADIO_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_GRAYTEXT, BACKGROUND, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_RADIO_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, BACKGROUND, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_GROUP, PM_NON_SELECTABLE,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_GRAYTEXT, BACKGROUND, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_GROUP, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, BACKGROUND, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, BACKGROUND, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_GRAYTEXT, COLOR_BTNFACE, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_BTNTEXT, COLOR_BTNFACE, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },

	{ ID_LIST_ITEM, PM_SELECTED,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_HIGHLIGHTTEXT, COLOR_HIGHLIGHT, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_GRAYTEXT, COLOR_WINDOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_WINDOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_MENUTEXT, COLOR_MENU, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_SCROLL_BAR, PM_ANY,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, BACKGROUND, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },

	{ ID_TABLE_HEADER, PM_ANY,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_BTNTEXT, COLOR_BTNFACE, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },

	{ ID_ICON, PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_CAPTIONTEXT, COLOR_ACTIVECAPTION, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
#if (WINVER > 0x300)
	{ ID_ICON, PM_NON_SELECTABLE,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_INACTIVECAPTIONTEXT, COLOR_INACTIVECAPTION, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
#else
	{ ID_ICON, PM_NON_SELECTABLE,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_INACTIVECAPTION, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
#endif
	{ ID_ICON, PM_ANY,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_WINDOW, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },

	{ ID_MENU, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SYSTEM_COLOR, COLOR_MENUTEXT, COLOR_MENU, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_BTNTEXT, COLOR_BTNFACE, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },

	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_ACTIVECAPTION, COLOR_ACTIVEBORDER, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_TITLE, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SYSTEM_COLOR, COLOR_ACTIVECAPTION, COLOR_ACTIVEBORDER, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_STATUS_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SYSTEM_COLOR, COLOR_BTNTEXT, COLOR_BTNFACE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_BAR, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SYSTEM_COLOR, COLOR_BTNTEXT, COLOR_BTNFACE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
#if defined(ZIL_WIN32)
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SYSTEM_COLOR, COLOR_3DLIGHT, COLOR_3DLIGHT, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
#else
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
#endif
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_BTNSHADOW, COLOR_BTNSHADOW, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, RED, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_WINDOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_WINDOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_WINDOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, GREEN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, GREEN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_WINDOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, COLOR_WINDOWTEXT, COLOR_WINDOW, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif

// --------------------------------------------------------------------------
// ----- ZIL_OS2 ------------------------------------------------------------
// --------------------------------------------------------------------------

#if defined(ZIL_OS2)
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_SELECTED,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_HILITEFOREGROUND, SYSCLR_HILITEBACKGROUND,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_FIELDBACKGROUND,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_MENUDISABLEDTEXT, SYSCLR_BUTTONMIDDLE,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_BUTTONMIDDLE,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_COMBO_BOX, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_BUTTONMIDDLE,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_ICON, PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_HILITEFOREGROUND, SYSCLR_HILITEBACKGROUND,
		BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
	{ ID_ICON, PM_ANY,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_ICONTEXT, SYSCLR_DIALOGBACKGROUND,
		BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
	{ ID_LIST, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_ENTRYFIELD,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_SELECTED,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_HILITEFOREGROUND, SYSCLR_HILITEBACKGROUND,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_MENUDISABLEDTEXT, SYSCLR_ENTRYFIELD,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_ENTRYFIELD,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_WINDOWSTATICTEXT, SYSCLR_FIELDBACKGROUND,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STATUS_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_BUTTONMIDDLE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_BAR, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_BUTTONMIDDLE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_TABLE_HEADER, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_BUTTONMIDDLE,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_BUTTONMIDDLE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, SYSCLR_OUTPUTTEXT, SYSCLR_WINDOW,
		BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, RED, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, GREEN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, GREEN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif

// --------------------------------------------------------------------------
// ----- ZIL_XT -------------------------------------------------------------
// --------------------------------------------------------------------------

#if defined(ZIL_XT)
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_SELECTED | PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, DARKGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_SELECTED,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, DARKGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, RED, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, GREEN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, GREEN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif

// --------------------------------------------------------------------------
// ----- ZIL_CURSES ---------------------------------------------------------
// --------------------------------------------------------------------------

#if defined(ZIL_CURSES)
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, CYAN), A_NORMAL | A_BOLD,
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_WINDOW_OBJECT, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), A_NORMAL,
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, WHITE), A_BOLD | A_UNDERLINE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_PROMPT, PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, BLUE), A_BOLD|A_UNDERLINE,
		PTN_SOLID_FILL, WHITE, BLACK, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(WHITE, BLUE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_STRING, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, WHITE), A_DIM,
		PTN_SOLID_FILL, WHITE, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_CURRENT,
		{ ' ', attrib(BLACK, WHITE), A_REVERSE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_BOLD|A_UNDERLINE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_RADIO_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, WHITE), A_DIM,
		PTN_SOLID_FILL, WHITE, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_RADIO_BUTTON, PM_CURRENT,
		{ ' ', attrib(BLACK, WHITE), A_REVERSE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_RADIO_BUTTON, PM_SELECTED,
		{ ' ', attrib(BLACK, WHITE), A_BOLD,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_RADIO_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_CHECK_BOX, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, WHITE), A_DIM,
		PTN_SOLID_FILL, WHITE, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_CHECK_BOX, PM_CURRENT,
		{ ' ', attrib(BLACK, WHITE), A_REVERSE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_CHECK_BOX, PM_SELECTED,
		{ ' ', attrib(BLACK, WHITE), A_BOLD,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_CHECK_BOX, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, CYAN), A_UNDERLINE | A_BOLD,
		PTN_SOLID_FILL, BLACK, CYAN, BW_BLACK, BW_WHITE, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), A_BOLD | A_UNDERLINE |A_REVERSE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_BUTTON, PM_SELECTED,
		{ ' ', attrib(BLACK, CYAN), A_BOLD,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_BUTTON, PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, WHITE), A_BOLD | A_UNDERLINE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_REVERSE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_WINDOW, PM_NON_SELECTABLE,
		{ ' ', attrib(WHITE, BLUE), A_NORMAL,
		PTN_SOLID_FILL, WHITE, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(WHITE, BLUE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_MENU, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_MENU_ITEM, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, CYAN), A_UNDERLINE | A_BOLD,
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), A_REVERSE,
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, WHITE), A_NORMAL,
		PTN_SOLID_FILL, WHITE, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(CYAN, WHITE), A_DIM,
		PTN_SOLID_FILL, WHITE, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_MENU_ITEM, PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, WHITE), A_BOLD | A_UNDERLINE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_LIST, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_LIST_ITEM, PM_SELECTED | PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), A_REVERSE,
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_SELECTED,
		{ ' ', attrib(MAGENTA, CYAN), A_REVERSE,
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_CURRENT,
		{ ' ', attrib(BLUE, CYAN), A_REVERSE,
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(BLACK, WHITE), A_DIM,
		PTN_SOLID_FILL, BLACK, WHITE, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },

	{ ID_LIST_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_BOLD | A_UNDERLINE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },

	{ ID_GROUP, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_STATUS_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, BLUE), A_REVERSE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_STATUS_BAR, PM_ANY,
		{ ' ', attrib(BLACK, BLUE), A_REVERSE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_TEXT, PM_CURRENT,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_SCROLL_BAR, PM_ANY,
 		{ '#', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, WHITE, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_TABLE_HEADER, PM_ANY,
		{ ' ', attrib(BLACK, BLUE), A_BOLD | A_UNDERLINE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_TABLE, PM_ANY,
		{ ' ', attrib(BLACK, BLUE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_TABLE_RECORD, PM_CURRENT,
		{ ' ', attrib(BLACK, BLUE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_TABLE_RECORD, PM_ANY,
		{ ' ', attrib(BLACK, BLUE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(BLACK, BLUE), A_REVERSE | A_UNDERLINE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_PULL_DOWN_MENU, PM_ANY,
		{ ' ', attrib(BLACK, BLUE), A_REVERSE | A_UNDERLINE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_PULL_DOWN_ITEM, PM_HOT_KEY,
		{ ' ', attrib(BLACK, BLUE), A_BOLD | A_UNDERLINE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_PULL_DOWN_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, BLUE), A_BOLD | A_UNDERLINE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_PULL_DOWN_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, BLUE), A_REVERSE | A_UNDERLINE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Support objects.
	{ ID_BORDER, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), A_REVERSE,
		PTN_INTERLEAVE_FILL, BLACK, MAGENTA, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_SPECIAL,
		{ ' ', attrib(CYAN, BLUE), A_REVERSE,
		PTN_SOLID_FILL, WHITE, CYAN, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(WHITE, BLUE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), A_REVERSE,
		PTN_SOLID_FILL, WHITE, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ANY,
		{ ' ', attrib(WHITE, BLUE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(CYAN, BLUE), A_REVERSE,
		PTN_SOLID_FILL, YELLOW, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), A_REVERSE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, BLUE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), A_REVERSE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, BLUE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(CYAN, BLUE), A_REVERSE,
		PTN_SOLID_FILL, YELLOW, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), A_REVERSE,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(WHITE, BLUE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), A_REVERSE,
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), A_REVERSE,
		PTN_SOLID_FILL, WHITE, WHITE, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, WHITE), A_NORMAL,
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), A_NORMAL,
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), A_NORMAL,
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), A_BOLD,
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), A_REVERSE,
		PTN_SOLID_FILL, WHITE, RED, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), A_REVERSE,
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), A_REVERSE,
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), A_REVERSE,
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), A_NORMAL,
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), A_NORMAL,
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), A_NORMAL,
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), A_BOLD,
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), A_REVERSE,
		PTN_SOLID_FILL, WHITE, GREEN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, GREEN), A_REVERSE,
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), A_NORMAL,
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), A_REVERSE,
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), A_REVERSE,
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), A_REVERSE,
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), A_NORMAL,
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), A_NORMAL,
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif

// --------------------------------------------------------------------------
// ----- ZIL_MACINTOSH ------------------------------------------------------
// --------------------------------------------------------------------------

#if defined(ZIL_MACINTOSH)
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_CURRENT,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_MENU_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SYSTEM_COLOR, BLACK, WHITE, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(CYAN, LIGHTGRAY), attrib(MONO_DIM, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_WINDOW, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_LIST_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, WHITE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_LIST_ITEM, PM_SELECTED,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SYSTEM_COLOR, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_COMBO_BOX, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_GROUP, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, DARKGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_GROUP, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_MENU, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_ICON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, DARKGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },

	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BORDER, PM_ACTIVE,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_INTERLEAVE_FILL, BLACK, MAGENTA, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_SPECIAL,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, CYAN, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_STATUS_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_BAR, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_TABLE_HEADER, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, RED, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, GREEN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, GREEN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif

// --------------------------------------------------------------------------
// ----- ZIL_NEXTSTEP ------------------------------------------------------
// --------------------------------------------------------------------------

#if defined(ZIL_NEXTSTEP)
#ifdef MIKEC
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_BLACK, GS_WHITE } },
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_MENU_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SYSTEM_COLOR, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(CYAN, LIGHTGRAY), attrib(MONO_DIM, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_WINDOW, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_LIST_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SYSTEM_COLOR, BLACK, CYAN, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_LIST_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_COMBO_BOX, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	
	{ ID_GROUP, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_GROUP, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_MENU, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BORDER, PM_ACTIVE,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_INTERLEAVE_FILL, BLACK, MAGENTA, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_SPECIAL,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, CYAN, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_STATUS_BAR, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, RED, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, GREEN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, GREEN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

#endif

#if defined(ZIL_MSDOS) && (!(defined(ZIL_MSWINDOWS_STYLE) || defined(ZIL_OS2_STYLE) || defined(ZIL_MOTIF_STYLE)) || !(defined(ZIL_SHADOW_BORDER) || defined(ZIL_STANDARD_BORDER) || defined(ZIL_3D_BORDER)))
static UI_PALETTE_MAP ZIL_FARDATA __normalPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_BUTTON, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_BUTTON, PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_BUTTON, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	{ ID_MENU_ITEM, PM_CURRENT | PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, CYAN), attrib(MONO_DIM, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE | PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MENU_ITEM, PM_NON_SELECTABLE,
		{ ' ', attrib(CYAN, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_MENU_ITEM, PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_MENU_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_NON_SELECTABLE,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_WINDOW, PM_NON_SELECTABLE,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_WINDOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_LIST_ITEM, PM_SELECTED | PM_CURRENT,
		{ ' ', attrib(WHITE, CYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_LIST_ITEM, PM_SELECTED,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_BLACK } },
	{ ID_LIST_ITEM, PM_CURRENT,
		{ ' ', attrib(BLACK, CYAN), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_LIST_ITEM, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_GROUP, PM_NON_SELECTABLE,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, LIGHTGRAY, WHITE, BW_BLACK, BW_WHITE, GS_GRAY, GS_WHITE } },
	{ ID_GROUP, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(ZIL_UNICODE)
 		{ 0x2591, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#elif defined(ZIL_ISO8859_1)
 		{ 0x80, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0xb0, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TOOL_BAR, PM_ANY,
		{ ' ', attrib(BLACK, BLUE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_MENU, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	{ ID_PROMPT, PM_HOT_KEY,
		{ ' ', attrib(MAGENTA, BLUE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, WHITE, BLACK, BW_WHITE, BW_BLACK, GS_GRAY, GS_WHITE } },
	{ ID_PROMPT, PM_ANY,
		{ ' ', attrib(BLACK, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Support objects.
	{ ID_BORDER, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_HIGH, MONO_BLACK),
		PTN_INTERLEAVE_FILL, BLACK, MAGENTA, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_SPECIAL,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, CYAN, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_BORDER, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, MAGENTA), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, CYAN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MINIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_SYSTEM_BUTTON, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_BLACK, MONO_HIGH),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE,
		{ ' ', attrib(CYAN, BLUE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, BLUE), attrib(MONO_NORMAL, MONO_DIM),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_GRAY } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(BLACK, LIGHTGRAY), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
		PTN_SOLID_FILL, WHITE, WHITE, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __errorPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, RED), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, RED, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};

static UI_PALETTE_MAP ZIL_FARDATA __helpPaletteMapTable[] =
{
	{ ID_WINDOW_OBJECT, PM_ANY,
		{ ' ', attrib(WHITE, DARKGRAY), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_WINDOW_OBJECT, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },
	{ ID_TITLE, PM_ACTIVE,
		{ ' ', attrib(WHITE, GREEN), attrib(MONO_HIGH, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, GREEN, BW_WHITE, BW_BLACK, GS_WHITE, GS_GRAY } },
	{ ID_MAXIMIZE_BUTTON, PM_ACTIVE | PM_SELECTED,
		{ ' ', attrib(YELLOW, GREEN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_WHITE, GS_GRAY } },

	{ ID_STRING, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_TEXT, PM_ANY,
		{ ' ', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, WHITE, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },
	{ ID_SCROLL_BAR, PM_ANY,
#if defined(ZIL_UNICODE)
 		{ 0x2591, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#elif defined(ZIL_ISO8859_1)
 		{ 0x80, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#else
 		{ 0xb0, attrib(BLACK, LIGHTGRAY), attrib(MONO_HIGH, MONO_BLACK),
#endif
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_WHITE, GS_BLACK, GS_WHITE } },

	// Special palettes.
	{ ID_OUTLINE, PM_ANY,
		{ ' ', attrib(WHITE, LIGHTGRAY), attrib(MONO_HIGH, MONO_NORMAL),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_WHITE_SHADOW, PM_ANY,
		{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
		PTN_SOLID_FILL, WHITE, WHITE, BW_WHITE, BW_WHITE, GS_WHITE, GS_WHITE } },
	{ ID_LIGHT_SHADOW, PM_ANY,
		{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_DARK_SHADOW, PM_ANY,
		{ ' ', attrib(DARKGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },
	{ ID_BLACK_SHADOW, PM_ANY,
		{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK } },

	// End of array.
	{ ID_END, 0, { 0, 0, 0, 0, 0, 0 } }
};
#endif

UI_PALETTE_MAP *_normalPaletteMapTable = __normalPaletteMapTable;
UI_PALETTE_MAP *_errorPaletteMapTable = __errorPaletteMapTable;
UI_PALETTE_MAP *_helpPaletteMapTable = __helpPaletteMapTable;
