//	Program name..	Zinc Interface Library
//	Filename......	D_CTRL.CPP
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>
#include "d_demo.hpp"
#include "d_help.hlh"

DISPLAY_POP_UP_ITEM::DISPLAY_POP_UP_ITEM(char *string, USHORT mniFlags,
	USHORT btFlags, USHORT woFlags, TEXT_DISPLAY_MODE a_mode) :
	UIW_POP_UP_ITEM(string, mniFlags, btFlags, woFlags,
	DISPLAY_POP_UP_ITEM::UserFunction)
{
	mode = a_mode;
	if (_currentMode == a_mode)
		woStatus |= WOS_SELECTED;
}

#pragma argsused
void DISPLAY_POP_UP_ITEM::UserFunction(void *data, UI_EVENT &event)
{
	DISPLAY_POP_UP_ITEM *displayItem = (DISPLAY_POP_UP_ITEM *)data;

	// Set up the new screen mode.
	if (_currentMode != displayItem->mode)
	{
		RestoreSystem(FALSE);
		InitializeSystem(displayItem->mode);
	}

	// See if an error occurred on display creation.
	if (_currentMode == displayItem->mode)
		displayItem->woStatus |= WOS_SELECTED;
	else
	{
		char *errorString;
		if (displayItem->mode == TDM_25x40)
			errorString = "25 line x 40 column";
		else if (displayItem->mode == TDM_25x80)
			errorString = "25 line x 80 column";
		else if (displayItem->mode == TDM_43x80)
			errorString = "43 line x 80 column";
		else
			errorString = "graphics";
		_errorSystem->ReportError(displayItem->windowManager, 0xFFFF,
			"Your machine cannot be switched into %s mode", errorString);
		displayItem->woStatus &= ~WOS_SELECTED;
	}
}

HELP_POP_UP_ITEM::HELP_POP_UP_ITEM(char *string, USHORT mniFlags, USHORT btFlags,
	USHORT woFlags, int a_helpContext) :
	UIW_POP_UP_ITEM(string, mniFlags, btFlags, woFlags,
	HELP_POP_UP_ITEM::UserFunction)
{
	helpContext = a_helpContext;
}

#pragma argsused
void HELP_POP_UP_ITEM::UserFunction(void *helpItem, UI_EVENT &event)
{
	// Display the help information.
	_helpSystem->DisplayHelp(_windowManager,
		((HELP_POP_UP_ITEM *)helpItem)->helpContext);
}

HELP_PULL_DOWN_ITEM::HELP_PULL_DOWN_ITEM(char *string, USHORT mnFlags,
	int a_helpContext) :
	UIW_PULL_DOWN_ITEM(string, mnFlags, HELP_PULL_DOWN_ITEM::UserFunction)
{
	helpContext = a_helpContext;
}

#pragma argsused
void HELP_PULL_DOWN_ITEM::UserFunction(void *helpItem, UI_EVENT &event)
{
	// Display the help information.
	_helpSystem->DisplayHelp(_windowManager,
		((HELP_PULL_DOWN_ITEM *)helpItem)->helpContext);
}

#pragma argsused
static void ClearScreen(void *popUpItem, UI_EVENT &event)
{
	// We must be very careful down here when destroying windows since
	// we are currently in a pop-up window.
	UI_WINDOW_OBJECT *object, *tObject;
	for (object = _windowManager->First(); object; object = tObject)
	{
		tObject = object->Next();
		if (object != _controlMenu)
		{
			*_windowManager - object;
			if (!FlagSet(object->woAdvancedFlags, WOAF_NO_DESTROY))
				delete object;
		}
	}
}

static void Exit(void *popUpItem, UI_EVENT &event)
{
	// Send an exit message to the system.
	event.type = L_EXIT;
	((UIW_POP_UP_ITEM *)popUpItem)->eventManager->Put(event, Q_BEGIN);
}

#pragma argsused
void ErrorNone(void *item, UI_EVENT &event)
{
	delete _errorSystem;
	_errorSystem = new UI_ERROR_SYSTEM;
	((UIW_POP_UP_ITEM *)item)->woStatus |= WOS_SELECTED;
}

#pragma argsused
void ErrorWindow(void *item, UI_EVENT &event)
{
	delete _errorSystem;
	_errorSystem = new UI_ERROR_WINDOW_SYSTEM;
	((UIW_POP_UP_ITEM *)item)->woStatus |= WOS_SELECTED;
}

#pragma argsused
void HelpNone(void *item, UI_EVENT &event)
{
	delete _helpSystem;
	_helpSystem = new UI_HELP_SYSTEM;
	((UIW_POP_UP_ITEM *)item)->woStatus |= WOS_SELECTED;
}

#pragma argsused
void HelpWindow(void *item, UI_EVENT &event)
{
	delete _helpSystem;
	_helpSystem = new UI_HELP_WINDOW_SYSTEM("d_help.hlp", _windowManager,
		HELP_GENERAL);
	((UIW_POP_UP_ITEM *)item)->woStatus |= WOS_SELECTED;
}

void InitializeControlMenu(void)
{
	UIW_PULL_DOWN_ITEM *pullDownItem;

	// Create the control menu.
	_controlMenu = new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS);
	_controlMenu->woAdvancedFlags |= WOAF_LOCKED | WOAF_NON_CURRENT;

	// Create the "Control" item with sub-items.
	pullDownItem = new UIW_PULL_DOWN_ITEM(" ~Control ", MNF_NO_FLAGS, 0);
	*pullDownItem
		+ new UIW_POP_UP_ITEM("~Clear screen", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, ClearScreen)
		+ new UIW_POP_UP_ITEM
		+ new HELP_POP_UP_ITEM("~How to order...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, INFO_HOW_TO_ORDER)
		+ new HELP_POP_UP_ITEM("~System requirements...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, INFO_SYSTEM_REQUIREMENTS)
		+ new HELP_POP_UP_ITEM("~About the demonstration...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, INFO_CONTROL)
		+ new UIW_POP_UP_ITEM
		+ new UIW_POP_UP_ITEM("E~xit", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, Exit);
	*_controlMenu + pullDownItem;

	// Create the "Display" item with sub-items.
	pullDownItem = new UIW_PULL_DOWN_ITEM(" ~Display ", MNF_SELECT_ONE, 0);
	*pullDownItem
		+ new DISPLAY_POP_UP_ITEM(" ~1-25x40 text mode", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, TDM_25x40)
		+ new DISPLAY_POP_UP_ITEM(" ~2-25x80 text mode", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, TDM_25x80)
		+ new DISPLAY_POP_UP_ITEM(" ~3-(43/50)x80 text mode", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, TDM_43x80)
		+ new DISPLAY_POP_UP_ITEM(" ~4-Graphics mode", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, TDM_AUTO)
		+ new UIW_POP_UP_ITEM
		+ new HELP_POP_UP_ITEM(" ~About the screen display...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, INFO_DISPLAY);
	*_controlMenu + pullDownItem;

	// Create the "Window" item with sub-items.
	extern void WindowClassic(void *item, UI_EVENT &event);
	extern void GeneralObjects(void *item, UI_EVENT &event);
	extern void SampleDates(void *item, UI_EVENT &event);
	extern void SampleStrings(void *item, UI_EVENT &event);
	extern void SampleMatrix(void *item, UI_EVENT &event);
	extern void SampleMenus(void *item, UI_EVENT &event);
	extern void SampleTimes(void *item, UI_EVENT &event);
	extern void SampleNumbers(void *item, UI_EVENT &event);
	extern void SampleIcons(void *item, UI_EVENT &event);
	extern void WindowObjects(void *item, UI_EVENT &event);

	pullDownItem = new UIW_PULL_DOWN_ITEM(" ~Window ", MNF_NO_FLAGS, 0);
	*pullDownItem
		+ new UIW_POP_UP_ITEM("~Classic windows", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, WindowClassic)
		+ new UIW_POP_UP_ITEM
		+ new UIW_POP_UP_ITEM("~1-Generic window...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, GeneralObjects)
		+ new UIW_POP_UP_ITEM("~2-Date window...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, SampleDates)
		+ new UIW_POP_UP_ITEM("~3-Time window...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, SampleTimes)
		+ new UIW_POP_UP_ITEM("~4-Number window...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, SampleNumbers)
		+ new UIW_POP_UP_ITEM("~5-String window...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, SampleStrings)
		+ new UIW_POP_UP_ITEM("~6-Menu window...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, SampleMenus)
		+ new UIW_POP_UP_ITEM("~7-Matrix window...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, SampleMatrix)
		+ new UIW_POP_UP_ITEM("~8-Icon window...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, SampleIcons)
		+ new UIW_POP_UP_ITEM
		+ new HELP_POP_UP_ITEM("~About the window manager...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, INFO_WINDOW);
	*_controlMenu + pullDownItem;

	// Create the "Event" item with sub-items.
	extern void EventKeyboard(void *item, UI_EVENT &event);
	extern void EventMouse(void *item, UI_EVENT &event);
	extern void EventMonitor(void *item, UI_EVENT &event);

	pullDownItem = new UIW_PULL_DOWN_ITEM(" ~Event ", MNF_NO_FLAGS, 0);
	*pullDownItem
		+ new UIW_POP_UP_ITEM(
			(_eventManager->DeviceState(E_KEY, D_STATE) == D_ON) ?
			"~Keyboard (Off/On) : ON " : "~Keyboard (Off/On) : ON ",
			MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, EventKeyboard)
		+ new UIW_POP_UP_ITEM(
			(_eventManager->DeviceState(E_MOUSE, D_STATE) == D_ON) ?
			"~Mouse    (Off/On) : ON " : "~Mouse    (Off/On) : OFF",
			MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, EventMouse)
		+ new UIW_POP_UP_ITEM
		+ new UIW_POP_UP_ITEM("~Event monitor", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, EventMonitor)
		+ new UIW_POP_UP_ITEM
		+ new HELP_POP_UP_ITEM("~About the event manager...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, INFO_EVENT);
	*_controlMenu + pullDownItem;

	// Create the "Help" item with sub-items.
	pullDownItem = new UIW_PULL_DOWN_ITEM(" ~Help ", MNF_SELECT_ONE, 0);
	pullDownItem->Add(new UIW_POP_UP_ITEM(" ~No help system", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, HelpNone));
	UIW_POP_UP_ITEM *windowHelp = new UIW_POP_UP_ITEM(" ~Window help system", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, HelpWindow);
	windowHelp->woStatus |= WOS_SELECTED;

	*pullDownItem
		+ windowHelp
		+ new UIW_POP_UP_ITEM
		+ new HELP_POP_UP_ITEM(" ~About the help system...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, INFO_HELP);
	*_controlMenu + pullDownItem;

	// Create the "Error" item with sub-items.
	pullDownItem = new UIW_PULL_DOWN_ITEM(" E~rror ", MNF_SELECT_ONE, 0);
	pullDownItem->Add(new UIW_POP_UP_ITEM(" ~No error system", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, ErrorNone));
	UIW_POP_UP_ITEM *windowError = new UIW_POP_UP_ITEM(" ~Window error system", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, ErrorWindow);
	windowError->woStatus |= WOS_SELECTED;

	*pullDownItem
		+ windowError
		+ new UIW_POP_UP_ITEM
		+ new HELP_POP_UP_ITEM(" ~About the error system...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, INFO_ERROR);
	*_controlMenu + pullDownItem;

	// Create the "Applications" item with sub-items.
	extern void WindowDirectory(void *item, UI_EVENT &event);
	extern void DataEntry(void *item, UI_EVENT &event);
	extern void Calculator(void *item, UI_EVENT &event);
	extern void Piano(void *item, UI_EVENT &event);
	extern void Graph(void *item, UI_EVENT &event);

	pullDownItem = new UIW_PULL_DOWN_ITEM(" ~Applications ", MNF_NO_FLAGS, 0);
	*pullDownItem
		+ new UIW_POP_UP_ITEM("~1-Directory...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, WindowDirectory)
		+ new UIW_POP_UP_ITEM("~2-Data entry...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, DataEntry)
		+ new UIW_POP_UP_ITEM("~3-Calculator...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, Calculator)
		+ new UIW_POP_UP_ITEM("~4-Piano...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, Piano)
		+ new UIW_POP_UP_ITEM("~5-Graph...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, Graph)
		+ new UIW_POP_UP_ITEM
		+ new HELP_POP_UP_ITEM("~About application programs...", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, INFO_APPS);
	*_controlMenu + pullDownItem;

	// Attach the control menu to the screen display.
	*_windowManager + _controlMenu;
}
