//	Program name..	Zinc Interface Library
//	Filename......	D_DIRECT.CPP
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dir.h>
#include <dos.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ui_win.hpp>
#include "d_demo.hpp"

// Window File demonstration.

UIW_WINDOW *DIRECTORY_WINDOW::fileWindow = 0;

DIRECTORY_WINDOW::DIRECTORY_WINDOW(void) :
	UIW_WINDOW(3, 3, -3, 10, WOF_NO_FLAGS, WOAF_NO_FLAGS, NO_HELP_CONTEXT)
{
	// See if the file window has already been initialized.
	if (fileWindow)
		return;

	// Initialize the file window.
	extern void ExitButton(void *object, UI_EVENT &event);
	UI_DATE date;
	UI_TIME time;
	long size = 0;
	fileWindow = new UIW_WINDOW(20, 15, -20, 9, WOF_NO_FLAGS, WOAF_MODAL | WOAF_NO_SIZE | WOAF_NO_DESTROY, NO_HELP_CONTEXT);
	fileTitle = new UIW_TITLE("", WOF_JUSTIFY_CENTER);
	fileDate = new UIW_DATE(14, 1, 15, &date, 0, DTF_SYSTEM, WOF_VIEW_ONLY, 0);
	fileTime = new UIW_TIME(14, 2, 15, &time, 0, TMF_NO_FLAGS, WOF_VIEW_ONLY, 0);
	fileSize = new UIW_NUMBER(14, 3, 15, &size, 0, NMF_COMMAS, WOF_VIEW_ONLY, 0);
	*fileWindow
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON
		+ fileTitle
		+ new UIW_PROMPT(2, 1, "~Date........", WOF_NO_FLAGS)
		+ fileDate
		+ new UIW_PROMPT(2, 2, "~Time........", WOF_NO_FLAGS)
		+ fileTime
		+ new UIW_PROMPT(2, 3, "~Size........", WOF_NO_FLAGS)
		+ fileSize
		+ new UIW_BUTTON(2, 5, 10, "Esc=Exit", BTF_NO_FLAGS, WOF_JUSTIFY_CENTER, ExitButton);
}

int DIRECTORY_WINDOW::CompareFunction(void *file1, void *file2)
{
	return (strcmp(((UIW_POP_UP_ITEM *)file1)->DataGet(),
		((UIW_POP_UP_ITEM *)file2)->DataGet()));
}

#pragma argsused
void DIRECTORY_WINDOW::D_DirectoryUserFunction(void *data, UI_EVENT &event)
{
	UIW_POP_UP_ITEM *item = (UIW_POP_UP_ITEM *)data;
	DIRECTORY_WINDOW *directoryWindow = (DIRECTORY_WINDOW *)item->parent;
	while (directoryWindow->parent)
		directoryWindow = (DIRECTORY_WINDOW *)directoryWindow->parent;
	directoryWindow->DirectoryUserFunction(item);
}
void DIRECTORY_WINDOW::DirectoryUserFunction(UIW_POP_UP_ITEM *item)
{
	// Create a new pulldown directory.
	PullDownMenu((UIW_PULL_DOWN_ITEM *)item->parent->parent, item->DataGet());
	Matrix();

	// Redraw the information by adding the object back to the window manager.
	windowManager->Add(this);
}

#pragma argsused
void DIRECTORY_WINDOW::D_FileUserFunction(void *data, UI_EVENT &event)
{
	UIW_POP_UP_ITEM *item = (UIW_POP_UP_ITEM *)data;
	DIRECTORY_WINDOW *directoryWindow = (DIRECTORY_WINDOW *)item->parent;
	while (directoryWindow->parent)
		directoryWindow = (DIRECTORY_WINDOW *)directoryWindow->parent;
	directoryWindow->FileUserFunction(item);
}
void DIRECTORY_WINDOW::FileUserFunction(UIW_POP_UP_ITEM *item)
{
	// Determine the file path.
	char path[128];
	path[0] = '\0';
	for (UIW_PULL_DOWN_ITEM *tItem = pullDownMenu->First(); tItem; tItem = tItem->Next())
		strcat(path, tItem->DataGet());
	strcat(path, item->DataGet());
	for (int i = 0; path[i]; )
		if (path[i] == ' ')
			strcpy(&path[i], &path[i+1]);
		else
			i++;

	// Set the file information.
	char title[64];
	struct ffblk fileBlock;
	findfirst(path, &fileBlock, FA_DIREC);
	strcpy(title, item->DataGet());
	fileTitle->DataSet(title);
	UI_DATE date(fileBlock.ff_fdate);
	fileDate->DataSet(&date);
	UI_TIME time(fileBlock.ff_ftime);
	fileTime->DataSet(&time);
	fileSize->DataSet(&fileBlock.ff_fsize);
	windowManager->Add(fileWindow);
}

void DIRECTORY_WINDOW::Matrix(void)
{
	// Clear the old matrix.
	for (UI_WINDOW_OBJECT *button = matrix->First(); button; button = matrix->First())
	{
		matrix->Subtract(button);
		delete button;
	}

	// Determine the new path.
	char path[128];
	path[0] = '\0';
	for (UIW_PULL_DOWN_ITEM *item = pullDownMenu->First(); item; item = item->Next())
		strcat(path, item->DataGet());
	strcat(path, "*.*");
	for (int i = 0; path[i]; )
		if (path[i] == ' ')
			strcpy(&path[i], &path[i+1]);
		else
			i++;

	// Get the new files.
	struct ffblk fileBlock;
	int ccode = findfirst(path, &fileBlock, FA_DIREC);
	while (ccode == 0)
	{
		if (strcmp("..", fileBlock.ff_name) &&
			strcmp(".", fileBlock.ff_name) &&
			fileBlock.ff_attrib != FA_DIREC)
			matrix->Add(new UIW_POP_UP_ITEM(fileBlock.ff_name,
				MNIF_NO_FLAGS, BTF_NO_FLAGS, WOF_NO_FLAGS,
				DIRECTORY_WINDOW::D_FileUserFunction));
		ccode = findnext(&fileBlock);
	}
}

void DIRECTORY_WINDOW::PullDownMenu(UIW_PULL_DOWN_ITEM *tItem,
	const char *directory)
{
	struct ffblk fileBlock;

	// Clear the old pull-down menu.
	for (UIW_PULL_DOWN_ITEM *item = pullDownMenu->Last(); item; item = pullDownMenu->Last())
		if (item != tItem)
		{
			pullDownMenu->Subtract(item);
			delete item;
		}
		else
			break;

	// Create a new pull-down item.
	if (!directory)
		return;
	char path[128];
	strcpy(path, directory);
	for (int i = 0; path[i]; )
		if (path[i] == ' ')
			strcpy(&path[i], &path[i+1]);
		else
			i++;
	if (!strcmp(path, "."))		// The item directory was specified.
		return;
	strcat(path, "\\");
	item = new UIW_PULL_DOWN_ITEM(path, MNF_NO_FLAGS, 0);
	pullDownMenu->Add(item);

	// Determine the new path.
	path[0] = '\0';
	for (tItem = pullDownMenu->First(); tItem; tItem = tItem->Next())
	{
		tItem->woStatus &= ~WOS_CURRENT;
		strcat(path, tItem->DataGet());
	}
	strcat(path, "*.*");
	item->woStatus |= WOS_CURRENT;

	// Determine the sub-directory items.
	item->Add(new UIW_POP_UP_ITEM(".", MNIF_NO_FLAGS, BTF_NO_TOGGLE,
		WOF_NO_FLAGS, DIRECTORY_WINDOW::D_DirectoryUserFunction));
	int ccode = findfirst(path, &fileBlock, FA_DIREC);
	while (ccode == 0)
	{
		if (strcmp("..", fileBlock.ff_name) &&
			strcmp(".", fileBlock.ff_name) &&
			fileBlock.ff_attrib == FA_DIREC)
			item->Add(new UIW_POP_UP_ITEM(fileBlock.ff_name, MNIF_NO_FLAGS,
				BTF_NO_TOGGLE, WOF_NO_FLAGS, DIRECTORY_WINDOW::D_DirectoryUserFunction));
		ccode = findnext(&fileBlock);
	}
}

#pragma argsused
void WindowDirectory(void *item, UI_EVENT &event)
{
	// Create the DIRECTORY_WINDOW object.
	DIRECTORY_WINDOW *directoryWindow = new DIRECTORY_WINDOW;
	*directoryWindow
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ UIW_SYSTEM_BUTTON::GENERIC()
		+ new UIW_TITLE("File Directory", WOF_JUSTIFY_CENTER);

	// Create the pull-down menu.
	directoryWindow->pullDownMenu = new UIW_PULL_DOWN_MENU(1, WOF_NO_FLAGS, WOAF_NO_FLAGS);
	directoryWindow->PullDownMenu(0, "");
	*directoryWindow + directoryWindow->pullDownMenu;

	// Create the file matrix.
	directoryWindow->matrix = new UIW_MATRIX(0, 0, 0, 0, 5, 14, 1,
		DIRECTORY_WINDOW::CompareFunction, MXF_COLUMNS_FILL,
		WOF_NON_FIELD_REGION, WOAF_NO_FLAGS);
	directoryWindow->Matrix();
	*directoryWindow
		+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL, WOF_NON_FIELD_REGION)
		+ directoryWindow->matrix;

	*_windowManager + directoryWindow;
}

