//	Program name..	Zinc Interface Library
//	Filename......	D_EVENT.CPP
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dos.h>
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <ui_win.hpp>
#include "d_demo.hpp"
#include "d_help.hlh"

#pragma argsused
void EventKeyboard(void *data, UI_EVENT &event)
{
	// Check the state of the input devices.
	UIW_POP_UP_ITEM *item = (UIW_POP_UP_ITEM *)data;
	int kState = item->eventManager->DeviceState(E_KEY, D_STATE);
	int mState = item->eventManager->DeviceState(E_MOUSE, D_STATE);

	// Change the state of the keyboard device.
	if (mState == D_OFF && kState == D_ON)
		return;
	kState = (kState == D_ON) ? D_OFF : D_ON;
	item->eventManager->DeviceState(E_KEY, kState);
	kState = item->eventManager->DeviceState(E_KEY, D_STATE);
	if (kState == D_ON)
		item->DataSet(" ~Keyboard (Off/On) : ON");
	else
		item->DataSet(" ~Keyboard (Off/On) : OFF");
}

#pragma argsused
void EventMouse(void *data, UI_EVENT &event)
{
	// Check the state of the input devices.
	UIW_POP_UP_ITEM *item = (UIW_POP_UP_ITEM *)data;
	int kState = item->eventManager->DeviceState(E_KEY, D_STATE);
	int mState = item->eventManager->DeviceState(E_MOUSE, D_STATE);

	// Change the state of the mouse device.
	if (kState == D_OFF && mState == D_ON)
		return;
	mState = (mState == D_ON) ? D_OFF : D_ON;
	item->eventManager->DeviceState(E_MOUSE, mState);
	mState = item->eventManager->DeviceState(E_MOUSE, D_STATE);
	if (mState == D_ON)
		item->DataSet(" ~Mouse    (Off/On) : ON");
	else
		item->DataSet(" ~Mouse    (Off/On) : OFF");
}

#pragma argsused
void EventMonitor(void *item, UI_EVENT &event)
{
	EVENT_MONITOR *eventMonitor = new EVENT_MONITOR;
	if (!eventMonitor->installed)
		delete eventMonitor;
}

// ----- Event Monitor class definition -------------------------------------

int EVENT_MONITOR::active = FALSE;

EVENT_MONITOR::EVENT_MONITOR(void) :
	UI_DEVICE(E_EVENT_MONITOR, D_ON),
	UIW_WINDOW(-31, 1, 32, 8, WOF_NO_FLAGS, WOAF_NO_SIZE, NO_HELP_CONTEXT),
	installed(FALSE)
{
	if (active)
		return;

	active = TRUE;
	installed = TRUE;
	oldTime = lastTime = time(0);
	kEvent.type = mEvent.type = sEvent.type = 0;
	kEvent.rawCode = mEvent.rawCode = sEvent.rawCode = 0xFFFF;
	keyboard[0] = new UIW_STRING(16, 1, 4, "", 10, STF_NO_FLAGS, WOF_VIEW_ONLY, 0);
	keyboard[1] = new UIW_STRING(21, 1, 2, "", 10, STF_NO_FLAGS, WOF_VIEW_ONLY, 0);
	keyboard[2] = new UIW_STRING(25, 1, 1, "", 10, STF_NO_FLAGS, WOF_VIEW_ONLY, 0);
	mouse[0] = new UIW_STRING(16, 2, 4, "", 10, STF_NO_FLAGS, WOF_VIEW_ONLY, 0);
	mouse[1] = new UIW_STRING(21, 2, 3, "", 10, STF_NO_FLAGS, WOF_VIEW_ONLY, 0);
	mouse[2] = new UIW_STRING(25, 2, 3, "", 10, STF_NO_FLAGS, WOF_VIEW_ONLY, 0);
	system = new UIW_STRING(16, 3, 15, "", 20, STF_NO_FLAGS, WOF_VIEW_ONLY, 0);
	elapsedTime = new UIW_STRING(16, 4, 15, "", 20, STF_NO_FLAGS, WOF_VIEW_ONLY, 0);

	window = this;
	*window
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ &(*new UIW_SYSTEM_BUTTON
			+ new UIW_POP_UP_ITEM("~Move", MNIF_MOVE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM
			+ new UIW_POP_UP_ITEM("~Close", MNIF_CLOSE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0))
		+ new UIW_TITLE("Event monitor", WOF_JUSTIFY_CENTER)
		+ new UIW_PROMPT(1, 1, "Last key......", WOF_NO_FLAGS)
		+ keyboard[0] + keyboard[1] + keyboard[2]
		+ new UIW_PROMPT(1, 2, "Last mouse....", WOF_NO_FLAGS)
		+ mouse[0] + mouse[1] + mouse[2]
		+ new UIW_PROMPT(1, 3, "Last event....", WOF_NO_FLAGS)
		+ system
		+ new UIW_PROMPT(1, 4, "Elapsed time..", WOF_NO_FLAGS)
		+ elapsedTime;
	*_windowManager + window;

	device = this;
	*_eventManager + device;
}

EVENT_MONITOR::~EVENT_MONITOR(void)
{
	if (!installed)
		return;

	// The object is automatically removed from the window manager.
	*_eventManager - device;
	active = FALSE;
}

int EVENT_MONITOR::Event(const UI_EVENT &event)
{
	// Process the event according to the event type.
	if (event.type == E_EVENT_MONITOR || event.type == E_DEVICE)
		return (state);
	UIW_WINDOW::Event(event);
}

void EVENT_MONITOR::Poll(void)
{
	char string[32];
	long currentTime = time(0);
	if (currentTime != lastTime)
	{
		sprintf(string, "%ld", currentTime - oldTime);
		elapsedTime->DataSet(string);
		lastTime = currentTime;
	}

	UI_EVENT event;
	event.type = 0;
	_eventManager->Get(event, Q_BEGIN | Q_NO_BLOCK | Q_NO_DESTROY | Q_NO_POLL);
	if (event.type == 0)
		return;
	else if (event.type == E_KEY)
	{
		if (kEvent.rawCode != event.rawCode)
		{
			sprintf(string, "%04x", event.rawCode);
			keyboard[0]->DataSet(string);
		}
		if (kEvent.key.shiftState != event.key.shiftState)
		{
			sprintf(string, "%02x", event.key.shiftState);
			keyboard[1]->DataSet(string);
		}
		if (kEvent.key.value != event.key.value)
		{
			sprintf(string, "%c", event.key.value);
			keyboard[2]->DataSet(string);
		}
		kEvent = event;
	}
	else if (event.type == E_MOUSE)
	{
		if (mEvent.rawCode != event.rawCode)
		{
			sprintf(string, "%04x", event.rawCode);
			mouse[0]->DataSet(string);
		}
		if (mEvent.position.column != event.position.column)
		{
			sprintf(string, "%03d", event.position.column);
			mouse[1]->DataSet(string);
		}
		if (mEvent.position.line != event.position.line)
		{
			sprintf(string, "%03d", event.position.line);
			mouse[2]->DataSet(string);
		}
		mEvent = event;
	}
	if (sEvent.type != event.type)
	{
		char *typeName;
		switch (event.type)
		{
		case E_KEY: typeName = "Key"; break;
		case E_MOUSE: typeName = "Mouse"; break;
		case E_CURSOR: typeName = "Cursor"; break;
		case E_DEVICE: typeName = "Device"; break;

		case S_ERROR: typeName = "Error"; break;
		case S_NO_OBJECT: typeName = "No object"; break;
		case S_MINIMIZE: typeName = "Minimize"; break;
		case S_MAXIMIZE: typeName = "Maximize"; break;
		case S_ALT_KEY: typeName = "Alt key"; break;
		case S_CREATE: typeName = "Create"; break;
		case S_DELETE: typeName = "Delete"; break;
		case S_CURRENT: typeName = "Current"; break;
		case S_NON_CURRENT: typeName = "Non current"; break;
		case S_MOVE: typeName = "Move"; break;
		case S_REDISPLAY: typeName = "Redisplay"; break;
		case S_DELETE_LEVEL: typeName = "Delete level"; break;
		case S_SIZE: typeName = "Size"; break;
		case S_CHANGE: typeName = "Change"; break;
		case S_DISPLAY_ACTIVE: typeName = "Display active"; break;
		case S_DISPLAY_INACTIVE: typeName = "Display inactive"; break;
		case S_SCROLL_VERTICAL: typeName = "Scroll vertical"; break;
		case S_SCROLL_HORIZONTAL: typeName = "Scroll horizontal"; break;
		default: typeName = "<Unknown>"; break;
		}
		system->DataSet(typeName);
	}
	sEvent = event;
}
