//	Program name..	Zinc Interface Library
//	Filename......	D_.CPP
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <graphics.h>
#include <ui_win.hpp>
#include "d_demo.hpp"
#include "d_help.hlh"

// Icon bitmap.
static USHORT note[] = {
	8,			// 		 16th note
	12,			//	   	��������Ŀ
	0x0800,		//	   	�    �   �
	0x0C00,		//	   	�    ��  �
	0x0B00,		//	   	�    � ���
	0x0800,		//	   	�    �   �
	0x0C00,		//	   	�    ��  �
	0x0B00,		//	   	�    � ���
	0x0800,		//	   	�    �   �
	0x7800,		//	   	� ����   �
	0xF800,		//	   	������   �
	0xF800,		//	   	������   �
	0xF800,		//	   	������   �
	0x7000		//	   	� ���    �
				//	   	����������
};

USHORT *notes[] = { note, 0 };

UI_PALETTE notePalettes[] =
{
	{
		'\260', attrib(RED, RED), attrib(MONO_BLACK, MONO_BLACK),
			SOLID_FILL, attrib(RED, WHITE), attrib(BW_BLACK, BW_WHITE),
			attrib(GS_BLACK, GS_WHITE)
	}
};


#pragma argsused
void Graph(void *item, UI_EVENT &event)
{
	extern void ExitButton(void *object, UI_EVENT &event);

	int left = _display->columns / _display->cellWidth / 2 - 15;
	int top = _display->lines / _display->cellHeight / 2 - 8;
	if (top < 0)
		top = 0;

	// Create the window.
	UIW_WINDOW *window = UIW_WINDOW::GENERIC(left, top, 31, 17, WOF_NO_FLAGS,
		WOAF_MODAL, INFO_GRAPH, " Icon graph ");
	*window
		+ &(*new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
			+ new HELP_PULL_DOWN_ITEM(" ~About icons ", MNF_NO_FLAGS, INFO_GRAPH));

	// Draw the graph with icons if in graphics mode, otherwise use Xs.
	int i, j;
	int height[] = { 8, 7, 7, 7, 5, 6, 4, 1, 1};
	for (i = 2; i <= 28; i += 3)
		for (j = height[i / 3]; j < 9; j++)
		{
			if (_display->isText)
				*window + new UIW_PROMPT(i, j, "X", WOF_NO_FLAGS);
			else
				*window + new UIW_ICON(i, j, notes , notePalettes,
					ICF_NO_FLAGS, WOF_NO_FLAGS);
		}

	// Add the prompt line (no border needed in text mode).
	if (_display->isText)
		*window + new UIW_PROMPT(1, 10, " 1  2  3  4  5  6  7  8  9 ", WOF_NO_FLAGS);
	else
		*window + new UIW_PROMPT(1, 10, " 1  2  3  4  5  6  7  8  9 ", WOF_BORDER);

	// Add the Exit button.
	*window
		+ new UIW_BUTTON(9, 12, 10, "Esc=Exit", BTF_NO_FLAGS, WOF_JUSTIFY_CENTER, ExitButton);

	// Add the graph to the window manager.
	*_windowManager + window;
}

