//	Program name..	Zinc Interface Library
//	Filename......	D_WIN.CPP
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>
#include "d_demo.hpp"
#include "d_help.hlh"

#pragma argsused
void GeneralObjects(void *item, UI_EVENT &event)
{
	UIW_WINDOW *window = UIW_WINDOW::GENERIC(0, 1, 67, 11, WOF_NO_FLAGS,
		WOAF_NO_FLAGS, INFO_GENERAL_OBJECTS, " General objects ");
	*window
		+ &(*new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
			+ new HELP_PULL_DOWN_ITEM(" ~About general objects ", MNF_NO_FLAGS, INFO_GENERAL_OBJECTS)
			+ new HELP_PULL_DOWN_ITEM(" ~Options ", MNF_NO_FLAGS, OPTIONS_GENERAL_OBJECTS));

	*_windowManager + window;
}

#pragma argsused
void SampleDates(void *item, UI_EVENT &event)
{
	UIW_WINDOW *window = UIW_WINDOW::GENERIC(2, 3, 67, 11, WOF_NO_FLAGS,
		WOAF_NO_FLAGS, INFO_SAMPLE_DATES, " Sample dates ");
	UI_DATE date;
	*window
		+ &(*new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
			+ new HELP_PULL_DOWN_ITEM(" ~About dates ", MNF_NO_FLAGS, INFO_SAMPLE_DATES)
			+ new HELP_PULL_DOWN_ITEM(" ~Options ", MNF_NO_FLAGS, OPTIONS_DATE)
			+ new HELP_PULL_DOWN_ITEM(" ~Editing ", MNF_NO_FLAGS, EDIT_DATE))
		+ new UIW_TEXT(43, 1, 20, 6,
			"All edited dates should be in the range 1-1-90..12-31-99",
			128, TXF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE | WOF_BORDER)

		+ new UIW_PROMPT(2, 1, "Standard...........", WOF_NO_FLAGS)
		+ new UIW_DATE(22, 1, 20, &date, "1-1-90..12-31-99", 
			DTF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 2, "Military...........", WOF_NO_FLAGS)
		+ new UIW_DATE(22, 2, 20, &date, "1-1-90..12-31-99", 
			DTF_MILITARY_FORMAT | DTF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 3, "Long text month....", WOF_NO_FLAGS)
		+ new UIW_DATE(22, 3, 20, &date, "1-1-90..12-31-99", 
			DTF_ALPHA_MONTH | DTF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 4, "Short text month...", WOF_NO_FLAGS)
		+ new UIW_DATE(22, 4, 20, &date, "1-1-90..12-31-99", 
			DTF_SHORT_MONTH | DTF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 5, "Short day-of-week..", WOF_NO_FLAGS)
		+ new UIW_DATE(22, 5, 20, &date, "1-1-90..12-31-99", 
			DTF_SHORT_DAY | DTF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 6, "Slash & zero fill..", WOF_NO_FLAGS)
		+ new UIW_DATE(22, 6, 20, &date, "1-1-90..12-31-99", 
			DTF_SLASH | DTF_ZERO_FILL | DTF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR);

	*_windowManager + window;
}

#pragma argsused
void SampleTimes(void *item, UI_EVENT &event)
{
	UIW_WINDOW *window = UIW_WINDOW::GENERIC(4, 5, 67, 11, WOF_NO_FLAGS,
		WOAF_NO_FLAGS, INFO_SAMPLE_TIMES, " Sample times ");
	UI_TIME time;
	*window
		+ &(*new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
			+ new HELP_PULL_DOWN_ITEM(" ~About times ", MNF_NO_FLAGS, INFO_SAMPLE_TIMES)
			+ new HELP_PULL_DOWN_ITEM(" ~Options ", MNF_NO_FLAGS, OPTIONS_TIME)
			+ new HELP_PULL_DOWN_ITEM(" ~Editing ", MNF_NO_FLAGS, EDIT_TIME))
		+ new UIW_TEXT(43, 1, 20, 6,
			"All edited times should be in the range 6:00am..10:00pm",
			128, TXF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE | WOF_BORDER)

		+ new UIW_PROMPT(2, 2, "Standard...........", WOF_NO_FLAGS)
		+ new UIW_TIME(22, 2, 20, &time, "6:00am..10:00pm",
			TMF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 3, "Twenty-four hour...", WOF_NO_FLAGS)
		+ new UIW_TIME(22, 3, 20, &time, "6:00am..10:00pm", 
			TMF_TWENTY_FOUR_HOUR | TMF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 4, "Colon & zero fill..", WOF_NO_FLAGS)
		+ new UIW_TIME(22, 4, 20, &time, "6:00am..10:00pm", 
			TMF_COLON_SEPARATOR | TMF_ZERO_FILL | TMF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 5, "Seconds...........", WOF_NO_FLAGS)
		+ new UIW_TIME(22, 5, 20, &time, "6:00am..10:00pm", 
			TMF_SECONDS | TMF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR);

	*_windowManager + window;
}

#pragma argsused
void SampleNumbers(void *item, UI_EVENT &event)
{
	UIW_WINDOW *window = UIW_WINDOW::GENERIC(6, 7, 67, 11, WOF_NO_FLAGS,
		WOAF_NO_FLAGS, INFO_SAMPLE_NUMBERS, " Sample numbers ");
	int ivalue = 1000;
	int cvalue = -1000;
	*window
		+ &(*new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
			+ new HELP_PULL_DOWN_ITEM(" ~About numbers ", MNF_NO_FLAGS, INFO_SAMPLE_NUMBERS)
			+ new HELP_PULL_DOWN_ITEM(" ~Options ", MNF_NO_FLAGS, OPTIONS_NUMBER)
			+ new HELP_PULL_DOWN_ITEM(" ~Editing ", MNF_NO_FLAGS, EDIT_NUMBER))
		+ new UIW_TEXT(43, 1, 20, 6,
			"All edited numbers should be in the range 0..10,000",
			128, TXF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE | WOF_BORDER)

		+ new UIW_PROMPT(2, 1, "Standard...........", WOF_NO_FLAGS)
		+ new UIW_NUMBER(22, 1, 20, &ivalue, "0..10000",
			NMF_NO_FLAGS, WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 2, "Currency...........", WOF_NO_FLAGS)
		+ new UIW_NUMBER(22, 2, 20, &ivalue, "0..10000",
			NMF_CURRENCY | NMF_DECIMAL(2), WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 3, "Commas.............", WOF_NO_FLAGS)
		+ new UIW_NUMBER(22, 3, 20, &ivalue, "0..10000",
			NMF_COMMAS, WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 4, "Fixed decimal (2)..", WOF_NO_FLAGS)
		+ new UIW_NUMBER(22, 4, 20, &ivalue, "0..10000",
			NMF_DECIMAL(2), WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 5, "Percent............", WOF_NO_FLAGS)
		+ new UIW_NUMBER(22, 5, 20, &ivalue, "0..10000",
			NMF_PERCENT, WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_PROMPT(2, 6, "Credit.............", WOF_NO_FLAGS)
		+ new UIW_NUMBER(22, 6, 20, &cvalue, "-10000..10000",
			NMF_CREDIT, WOF_BORDER | WOF_AUTO_CLEAR);

	*_windowManager + window;
}

#pragma argsused
void SampleStrings(void *item, UI_EVENT &event)
{
	UIW_WINDOW *window = UIW_WINDOW::GENERIC(8, 9, 67, 11, WOF_NO_FLAGS,
		WOAF_NO_FLAGS, INFO_SAMPLE_STRINGS, " Sample strings ");
	*window
		+ &(*new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
			+ new HELP_PULL_DOWN_ITEM(" ~About strings ", MNF_NO_FLAGS, INFO_SAMPLE_STRINGS)
			+ new HELP_PULL_DOWN_ITEM(" ~Options ", MNF_NO_FLAGS, OPTIONS_STRING)
			+ new HELP_PULL_DOWN_ITEM(" ~Editing ", MNF_NO_FLAGS, EDIT_STRING))

		+ new UIW_PROMPT(2, 1, "String.............", WOF_NO_FLAGS)
		+ new UIW_STRING(22, 1, 40, "Sample string", 256, STF_NO_FLAGS, WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 2, "Formatted strings..", WOF_NO_FLAGS)
		+ new UIW_FORMATTED_STRING(22, 2, 20, "8017858900", "LNNNLLNNNLXXXX",
			"(...) ...-....", WOF_BORDER | WOF_AUTO_CLEAR)
		+ new UIW_FORMATTED_STRING(43, 2, 19, "846020000", "NNNNNLNNNN",
			".....-....", WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 3, "Text...............", WOF_NO_FLAGS)
		+ new UIW_SCROLL_BAR(62, 3, 1, 4, SBF_VERTICAL, WOF_NO_FLAGS)
		+ new UIW_TEXT(22, 3, 40, 4, "Sample text", 1028, TXF_NO_FLAGS, WOF_BORDER | WOF_AUTO_CLEAR);

	*_windowManager + window;
}

#pragma argsused
void SampleMenus(void *item, UI_EVENT &event)
{
	UIW_WINDOW *window = UIW_WINDOW::GENERIC(10, 11, 67, 11, WOF_NO_FLAGS,
		WOAF_NO_FLAGS, INFO_SAMPLE_MENUS, " Sample menus ");
	*window
		+ &(*new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
			+ new HELP_PULL_DOWN_ITEM(" ~About menus ", MNF_NO_FLAGS, INFO_SAMPLE_MENUS)
			+ new HELP_PULL_DOWN_ITEM(" ~Options ", MNF_NO_FLAGS, OPTIONS_MENU))

		+ &(*new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
			+ &(*new UIW_PULL_DOWN_ITEM(" Item~1 ", MNF_NO_FLAGS, 0)
				+ new UIW_POP_UP_ITEM("Option 1.1", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
				+ new UIW_POP_UP_ITEM("Option 1.2", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
				+ new UIW_POP_UP_ITEM("Option 1.3", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0))
			+ &(*new UIW_PULL_DOWN_ITEM(" Item~2 ", MNF_NO_FLAGS, 0)
				+ new UIW_POP_UP_ITEM("Option 2.1", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
				+ new UIW_POP_UP_ITEM("Option 2.2", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
				+ new UIW_POP_UP_ITEM("Option 2.3", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0))
			+ &(*new UIW_PULL_DOWN_ITEM(" Item~3 ", MNF_NO_FLAGS, 0)
				+ new UIW_POP_UP_ITEM("Option 3.1", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
				+ new UIW_POP_UP_ITEM("Option 3.2", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
				+ new UIW_POP_UP_ITEM("Option 3.3", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)))

		+ new UIW_TEXT(43, 1, 20, 5,
			"A pull-down menu is shown at the top of the window.",
			128, TXF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE | WOF_BORDER)

		+ new UIW_PROMPT(2, 1, "Pop-up menu........", WOF_NO_FLAGS)
		+ &(*new UIW_POP_UP_MENU(22, 1, MNF_SELECT_ONE, WOF_BORDER, WOAF_NO_FLAGS)
			+ new UIW_POP_UP_ITEM(" Option 1 ", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 2 ", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 3 ", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 4 ", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 5 ", MNIF_NO_FLAGS, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0));

	*_windowManager + window;
}

#pragma argsused
void SampleMatrix(void *item, UI_EVENT &event)
{
	UIW_WINDOW *window = UIW_WINDOW::GENERIC(12, 13, 67, 11, WOF_NO_FLAGS,
		WOAF_NO_FLAGS, INFO_SAMPLE_MATRIX, " Sample matrix ");
	*window
		+ &(*new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
			+ new HELP_PULL_DOWN_ITEM(" ~About matrices ", MNF_NO_FLAGS, INFO_SAMPLE_MATRIX)
			+ new HELP_PULL_DOWN_ITEM(" ~Options ", MNF_NO_FLAGS, OPTIONS_MATRIX))

		+ new UIW_PROMPT(2, 1, "Matrix.............", WOF_NO_FLAGS)

		+ new UIW_SCROLL_BAR(63, 1, 1, 6, SBF_VERTICAL, WOF_NO_FLAGS)
		+ &(*new UIW_MATRIX(22, 1, 41, 6, 10, 14, 1, 0, MXF_NO_FLAGS, WOF_BORDER, WOAF_NO_FLAGS)
			+ new UIW_STRING(0, 0, 19, "Item 1.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 0, 19, "Item 1.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 1, 19, "Item 2.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 1, 19, "Item 2.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 2, 19, "Item 3.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 2, 19, "Item 3.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 3, 19, "Item 4.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 3, 19, "Item 4.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 4, 19, "Item 5.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 4, 19, "Item 5.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 5, 19, "Item 6.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 5, 19, "Item 6.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 6, 19, "Item 7.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 6, 19, "Item 7.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 7, 19, "Item 8.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 7, 19, "Item 8.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 8, 19, "Item 9.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 8, 19, "Item 9.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 9, 19, "Item 10.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 9, 19, "Item 10.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS));

	*_windowManager + window;
}
