//	Program name..	Extended graphics example.
//	Filename......	EXTGRAPH.HPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


// Constants for specifying graphics objects.
enum OBJECT_TYPE
{
	LINE,
	ELLIPSE,
	SECTOR,
	BAR3D
};

// Derive a class from UI_DOS_BGI_DISPLAY and add draw function.
class EXTENDED_BGI_DISPLAY : public UI_DOS_BGI_DISPLAY
{
public:
	EXTENDED_BGI_DISPLAY(int driver = 0, int mode = 0)
		: UI_DOS_BGI_DISPLAY(driver, mode) {}

	// Draw function uses generic parameters to accomodate graphics objects.
	void Draw(int objectType, const UI_REGION &region, int screenID, UI_PALETTE *palette,
		int param1, int param2 = 0, int param3 = 0, int param4 = 0);
};

// Generic base class for all graphic window objects.
class WO_GRAPHIC : public UI_WINDOW_OBJECT
{
public:
	WO_GRAPHIC(int a_objectType, UI_PALETTE *a_palette, int a_param1,
		int a_param2 = 0, int a_param3 = 0, int a_param4 = 0);

	int Event(const UI_EVENT &event);

protected:
	int objectType;
	int param1;
	int param2;
	int param3;
	int param4;
	UI_PALETTE *palette;
	UI_REGION visibleRegion;
};

// Window object line class definition.
class WO_LINE : public WO_GRAPHIC
{
public:
	// All lines must be drawn from left to right.
	WO_LINE(int x1, int y1, int x2, int y2, UI_PALETTE *palette);
};

// Window object ellipse class definition.
class WO_ELLIPSE : public WO_GRAPHIC
{
public:
	WO_ELLIPSE(int x, int y, int stAngle, int endAngle, int xRadius,
		int yRadius, UI_PALETTE *palette);
};

// Window object sector class definition.
class WO_SECTOR : public WO_GRAPHIC
{
public:
	WO_SECTOR(int x, int y, int stAngle, int endAngle, int xRadius,
		int yRadius, UI_PALETTE *palette);
};

// Window object 3D bar class definition.
class WO_BAR3D : public WO_GRAPHIC
{
public:
	WO_BAR3D(int left, int top, int right, int bottom, int depth,
		int topFlag, UI_PALETTE *palette);
};
