//	Program name..	Example demonstrating the UI_DOS_BGI_DISPLAY class object.
//	Filename......	XBGIDISP.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <graphics.h>
#include <ui_evt.hpp>

UI_DOS_BGI_DISPLAY *_display;

static UI_PALETTE linePalette = { '\260', attrib(LIGHTGRAY, LIGHTGRAY),
	attrib(MONO_DIM, MONO_DIM), SOLID_FILL, attrib(LIGHTGRAY, LIGHTGRAY),
	attrib(BW_WHITE, BW_WHITE), attrib(GS_WHITE, GS_WHITE) };

static UI_PALETTE barPalette = { '\260', attrib(YELLOW, RED),
	attrib(MONO_DIM, MONO_BLACK), SOLID_FILL, attrib(YELLOW, RED),
	attrib(BW_BLACK, BW_WHITE), attrib(GS_BLACK, GS_WHITE) };

class BOX : public UI_ELEMENT
{
public:
	UI_REGION region;

	BOX() {}

	void Move(const UI_REGION &current)
		{ region = current; }
	void Draw()
		{ _display->Rectangle(ID_SCREEN, region, &linePalette); }
	void Erase()
		{ _display->Rectangle(ID_SCREEN, region, _backgroundPalette); }
};

main()
{
	// Initialize the graphics display class.
	_display = new UI_DOS_BGI_DISPLAY;
	if (!_display->installed)
		return(0);

	// Initialize the event manager.
	UI_EVENT_MANAGER eventManager(100, _display);
	eventManager + new UI_BIOS_KEYBOARD;
	
	// Set up a region that is 15 pixiels from each side.
	UI_REGION edge;
	edge.top = 15;
	edge.left = 15;
	edge.right = _display->columns - 15;
	edge.bottom = _display->lines - 15;

	// Set up the starting positions and increments.
	UI_REGION current;
	current.left = _display->columns / 2 - 10;
	current.right = _display->columns / 2 + 10;
	current.top = current.bottom = _display->lines / 2;
	int xIncrement = 10;
	int yIncrement = 5;

	// Set up a region for the bar graph.
	UI_REGION graph;
	graph.left = _display->columns / 2 - 52;
	graph.right = _display->columns / 2 + 52;
	graph.top = 20;
	graph.bottom = 80;

	// Define the region so that other calls will not overwrite this region.
	_display->RegionDefine(-2, graph);  // Screen ID is negative for user defined regions.

	// Display the bar graph.
	UI_REGION bar;
	bar.bottom = 76;
	int count = 2;
	for (int i = graph.left + 4; i < graph.right - 12; i += 12)
	{
		count *= 1.5;
		bar.top = 76 - count;
		bar.left = i;
		bar.right = i + 10;
		_display->Fill(-2, bar, &barPalette);
	}

	// Display the graph title.
	char text[] = "1990 Sales";
	int top = 22;
	int left = (_display->columns - _display->TextWidth(text)) / 2;
	_display->Text(-2, left, top, text, &barPalette, -1, TRUE);

	UI_LIST list;
	BOX *line;

	// Wait for user response.
	UI_EVENT event;
	event.type = 0;		// Needed if Q_NO_BLOCK is used.
	do
	{
		// Erase the fifth line.
		if (list.Count() > 4)
		{
			line = (BOX *)list.first;
			list - line;
			line->Erase();
		}
		else
			line = new BOX;

		// Increment and draw the line.
		if (current.left - xIncrement < edge.left || current.right +
			xIncrement > edge.right || current.left - xIncrement * 2 > current.right )
			xIncrement = - xIncrement ;
		if (current.top - yIncrement < edge.top || current.bottom +
			yIncrement > edge.bottom || current.top - yIncrement * 2 > current.bottom)
			yIncrement = - yIncrement;
		current.left -= xIncrement;
		current.right += xIncrement;
		current.top -= yIncrement;
		current.bottom += yIncrement;

		line->Move(current);

		list + line;
		line->Draw();

		// Get input from the user.
		eventManager.Get(event, Q_NO_BLOCK | Q_POLL | Q_DESTROY | Q_BEGIN);

	} while (event.type != E_KEY);

	// Clean up. 
	delete _display;
}
