//	Program name..	Example demonstrating the UI_DATE class object.
//	Filename......	XDATE.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdio.h>		// include file for printf
#include <ui_gen.hpp>

class JDATE : public UI_DATE
{
public:
	JDATE(void)
		{ Import();	}
	JDATE(int year, int month, int day)
		{ Import(year, month, day); }
	JDATE(const char *string)
		{ Import(string, DTF_NO_FLAGS); }

	long Julian(void)
		{ return ((long)367 * dYear - 7 * (dYear + (dMonth + 9) / 12) / 4 +
		  275 * dMonth / 9 + 1721013.5 + dDay); }
};

main()
{
	char dateString[20];
	long days;

	// Initialize the dates in different ways.
	JDATE systemDate;
	JDATE nextCentury(2000, 1, 1);
	JDATE independenceDay("July 4, 1776");

	// Print the system date.
	systemDate.Export(dateString, 20, DTF_ALPHA_MONTH);
	printf("The system date is %s.\n", dateString);

	// Calculate the number of days until the next century.
	days = nextCentury.Julian() - systemDate.Julian();
	printf("There are %ld days until January 1, 2000.\n", days);

	// Calculate the number of days since the American Revolution.
	days = systemDate.Julian() - independenceDay.Julian();
	printf("There have been %ld days since July 4, 1776.\n", days);
}
