//	Program name..	Example demonstrating the UI_EDIT_INFO class object.
//	Filename......	XEDIT.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>

main()
{
	// Initialize the display, trying for graphics first.
	UI_DISPLAY *display = new UI_DOS_BGI_DISPLAY;
	if (!display->installed)
	{
		delete display;
		display = new UI_DOS_TEXT_DISPLAY;
	}

	// Initialize the event manager and add three devices to it.
	UI_EVENT_MANAGER eventManager(100, display);
	eventManager + new UI_BIOS_KEYBOARD + new UI_MS_MOUSE + new UI_CURSOR;
	
	// Initialize the window manager.
	UI_WINDOW_MANAGER windowManager(display, &eventManager);

	// Change the undo strategy to keep track of only 4 undos or 1k bytes
	// of undo information, whichever is less.
	//
	// NOTE: The default keys for UNDO are <Ctrl F9> or <Alt Left-down-click>
	// on the mouse.  For REDO, <Ctrl F10> or <Alt Right-down-click>.
	//
	UI_EDIT_INFO::UndoStrategy(-1, 1024, 4, -1, -1);

	// Create a window in the screen center.
	int centerX = display->columns / display->cellWidth / 2;
	int centerY = display->lines / display->cellHeight / 2;
	UIW_WINDOW *window = new UIW_WINDOW(centerX - 20, centerY - 3,
		40, 6, WOF_NO_FLAGS, WOAF_NO_FLAGS);

	// Add the window objects to the window.
	*window
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("Text Editor", WOF_JUSTIFY_CENTER)
		+ new UIW_TEXT(0, 0, 0, 0, "", 1024,
			TXF_NO_FLAGS, WOF_NON_FIELD_REGION);

	// Add the window to the window manager.
	windowManager + window;

	// Wait for user response.
	int ccode;
	UI_EVENT event;
	do
	{
		// Get input from the user.
		eventManager.Get(event, Q_NORMAL);

		// Send event information to the window manager.
		ccode = windowManager.Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete display;
}
