//	Program name..	Example demonstrating the UI_EVENT_MANAGER class object.
//	Filename......	XEVENT_MANAGER.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <graphics.h>	// Include file for palette colors.
#include <stdio.h>		// Include file for string operations.
#include <ui_map.hpp>

// Palette definition for new background palette.
static UI_PALETTE backgroundPalette = { ' ', attrib(YELLOW, BLACK),
	attrib(MONO_DIM, MONO_BLACK), INTERLEAVE_FILL, BLUE, RED };
UI_PALETTE *_backgroundPalette = &backgroundPalette;

main()
{
	int column = 10;
	int line = 10;

	// Initialize the relevant classes.
	UI_EVENT event;
	UI_DOS_TEXT_DISPLAY display;

	// Initialize the event manager.
	UI_EVENT_MANAGER eventManager(100, &display);

	// Add the keyboard, mouse, and cursor devices to the event manager.
	eventManager
		+ new UI_BIOS_KEYBOARD			// Add the keyboard device
		+ new UI_MS_MOUSE
		+ new UI_CURSOR(D_ON);			// Add the cursor device

	// Change the cursor to be an overtype (underline) cursor.
	eventManager.DeviceState(E_CURSOR, DC_OVERTYPE);

	// User response loop.
	do
	{
		// Position the cursor device at the initial location.
		eventManager.DevicePosition(E_CURSOR, column, line);

		// Get an event from the user.
		eventManager.Get(event);

		// Move cursor when the left mouse button is pressed.
		if (event.type == E_MOUSE && FlagSet(event.rawCode, M_LEFT ))
		{
			column = event.position.column;
			line = event.position.line;
		}

		// Move cursor with arrow keys.
		if (event.type == E_KEY)
		{
			switch (event.rawCode)
			{
			case GRAY_UP_ARROW:
			case WHITE_UP_ARROW:
				if (line > 0)
					line--;
				break;

			case GRAY_DOWN_ARROW:
			case WHITE_DOWN_ARROW:
				if (line < display.lines - 1)
					line++;
				break;

			case GRAY_LEFT_ARROW:
			case WHITE_LEFT_ARROW:
				if (column > 0 )
					column--;
				break;

			case GRAY_RIGHT_ARROW:
			case WHITE_RIGHT_ARROW:
				if (column < display.columns - 1)
					column++;
				break;

			}
		}

	} while (event.type != E_KEY || event.rawCode != ESCAPE);

	// Change the state of the keyboard device through the event manager.
	eventManager.DeviceState(E_CURSOR, D_OFF);		// Turn the cursor on.

	// The event manager and displays destructors are called automatically
	// when the scope of main ends.  The cursor device's descructor is 
	// automatically called from the event manager destructor.  The display
	// and event manager could have been created as pointers as in the
	// XBIOSKEY.CPP example program.
}
