//	Program name..	Extended graphics example.
//	Filename......	XGRAPH.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <graphics.h>
#include <ui_win.hpp>
#include "extgraph.hpp"

// Palettes used for drawing graphics.
UI_PALETTE graphPalette[] =
{
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
		XHATCH_FILL, attrib(BLACK, RED), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_GRAY, GS_GRAY)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
		LINE_FILL, attrib(BLACK, YELLOW), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_GRAY, GS_GRAY)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
		SLASH_FILL, attrib(BLACK, GREEN), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_GRAY, GS_GRAY)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
		INTERLEAVE_FILL, attrib(BLACK, BLUE), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_GRAY, GS_GRAY)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
		WIDE_DOT_FILL, attrib(BLACK, LIGHTRED), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_GRAY, GS_GRAY)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, LIGHTGREEN), attrib(BW_BLACK, BW_WHITE),
		attrib(GS_GRAY, GS_GRAY)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, DARKGRAY), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_GRAY, GS_GRAY)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
		SOLID_FILL, attrib(RED, DARKGRAY), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_GRAY, GS_GRAY)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
		SOLID_FILL, attrib(GREEN, DARKGRAY), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_GRAY, GS_GRAY)
	}
};

main()
{
	// Initialize the display.
	EXTENDED_BGI_DISPLAY *display = new EXTENDED_BGI_DISPLAY;
	if (!display->installed)
		return(0);

	// Initialize the event manager and add three devices to it.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(100, display);
	*eventManager + new UI_BIOS_KEYBOARD + new UI_MS_MOUSE + new UI_CURSOR;
	
	// Initialize the window manager.
	UI_WINDOW_MANAGER *windowManager = new UI_WINDOW_MANAGER(display, eventManager);

	// Create three windows.
	UIW_WINDOW *window1 = new UIW_WINDOW(14, 17, 52, 14, WOF_NO_FLAGS, WOAF_NO_FLAGS);
	UIW_WINDOW *window2 = new UIW_WINDOW(40, 1, 35, 15, WOF_NO_FLAGS, WOAF_NO_FLAGS);
	UIW_WINDOW *window3 = new UIW_WINDOW(7, 4, 28, 10, WOF_NO_FLAGS, WOAF_NO_FLAGS);

	// Add the pie elements and other objects to window1.
	*window1
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("WO_SECTOR", WOF_JUSTIFY_CENTER);

	*window1
		+ new WO_SECTOR(205, 80, 0, 360, 75, 30, &graphPalette[6])
		+ new WO_SECTOR(205, 70, 0, 56, 75, 30, &graphPalette[0])
		+ new WO_SECTOR(205, 70, 56, 112, 75, 30, &graphPalette[1])
		+ new WO_SECTOR(205, 70, 112, 133, 75, 30, &graphPalette[2])
		+ new WO_SECTOR(205, 70, 133, 210, 75, 30, &graphPalette[3])
		+ new WO_SECTOR(205, 70, 210, 240, 75, 30, &graphPalette[4])
		+ new WO_SECTOR(205, 70, 240, 360, 75, 30, &graphPalette[5]);

	*window1
		+ new WO_LINE(130, 70, 130, 80, &graphPalette[6])
		+ new WO_LINE(280, 70, 280, 80, &graphPalette[6])
		+ new UIW_PROMPT(16, 2, "Rent", WOF_NO_FLAGS)
		+ new UIW_PROMPT(10, 4, "Food", WOF_NO_FLAGS)
		+ new UIW_PROMPT(9, 7, "Clothing", WOF_NO_FLAGS)
		+ new UIW_PROMPT(27, 1, "Auto", WOF_NO_FLAGS)
		+ new UIW_PROMPT(36, 3, "Other", WOF_NO_FLAGS)
		+ new UIW_PROMPT(30, 8, "Entertainment", WOF_NO_FLAGS);

	// Add the 3D bars and other objects to window2.
	*window2
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("WO_BAR3D", WOF_JUSTIFY_CENTER);

	*window2
		+ new WO_BAR3D(16, 56, 40, 140, 10, TRUE, &graphPalette[0])
		+ new WO_BAR3D(56, 98, 80, 140, 10, TRUE, &graphPalette[1])
		+ new WO_BAR3D(96, 14, 120, 140, 10, TRUE, &graphPalette[2])
		+ new WO_BAR3D(136, 28, 160, 140, 10, TRUE, &graphPalette[3])
		+ new WO_BAR3D(176, 70, 200, 140, 10, TRUE, &graphPalette[4])
		+ new WO_BAR3D(216, 126, 240, 140, 10, TRUE, &graphPalette[5])
		+ new UIW_PROMPT(2, 11, "1985 1986 1987 1988 1989 1990", WOF_NO_FLAGS);

	// Initialize data for line graph.
	int redLine[] = { 75, 80, 63, 52, 14, 21, 7 };
	int greenLine[] = { 80, 70, 65, 42, 50, 35, 20 };

	// Add the border and other objects to window3.
	*window3
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("WO_LINE", WOF_JUSTIFY_CENTER);

	*window3
		+ new WO_LINE(8, 5, 8, 82, &graphPalette[6])
		+ new WO_LINE(8, 5, 200, 5, &graphPalette[6])
		+ new WO_LINE(200, 5, 200, 82, &graphPalette[6])
		+ new WO_LINE(8, 82, 200, 82, &graphPalette[6])
		+ new UIW_PROMPT(1, 6, "Jan Feb Mar Apr May Jun", WOF_NO_FLAGS);

	// Create the graph lines for window3.
	int x;
	for (x = 0; x < 6; x++)
		*window3 + new WO_LINE(8 + x * 32, redLine[x], 8 + (x + 1) * 32,
			redLine[x+1], &graphPalette[7]);

	for (x = 0; x < 6; x++)
		*window3 + new WO_LINE(8 + x * 32, greenLine[x], 8 + (x + 1) * 32,
			greenLine[x+1], &graphPalette[8]);

	// Add the windows to the window manager.
	*windowManager
		+ window1
		+ window2
		+ window3;

	// Wait for user response.
	int ccode;
	UI_EVENT event;
	do
	{
		eventManager->Get(event, Q_NORMAL);
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete windowManager;
	delete eventManager;
	delete display;
}
