//	Program name..	Example demonstrating the UI_LIST class object.
//	Filename......	XLIST.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>		// include file for strcmp and strdup
#include <stdio.h>		// include file for printf
#include <ui_gen.hpp>

class ITEM : public UI_ELEMENT
{
public:
	 char *name;

	 ITEM(char *a_name) { name = strdup(a_name); }
	 ~ITEM(void) { delete name; }
	 static Compare(void *item1, void *item2)
		{ return (strcmp(((ITEM *)item1)->name, ((ITEM *)item2)->name)); }
	 static Find(void *item1, void *matchData)
		{ return (strcmp(((ITEM *)item1)->name, (char *)matchData)); }
};

main()
{
	// Create a list, with entries, the easy way.
	UI_LIST list1(ITEM::Compare);
	list1 + new ITEM("Oranges") + new ITEM("Apples") + new ITEM("Grapes");

	// Sort the list, then print it out.
	list1.Sort();
	printf("There are %d items in list 1.\n", list1.Count());
	for (ITEM *item = (ITEM *)list1.first; item; item = (ITEM *)item->next)
		printf("%s\n", item->name);
	printf("\n");

	// Find the "Oranges" item in the first list.
	item = (ITEM *)list1.Get(ITEM::Find, "Oranges");
	printf("Found %s in list 1.\n", item->name);
	int index = list1.Index(item);
	printf("It is item number %d in the list.\n\n\n", index + 1);


	// Create a list the hard way.
	UI_LIST *list2 = new UI_LIST;
	list2->compareFunction = ITEM::Compare;
	list2->Add(new ITEM("Oranges"));
	list2->Add(new ITEM("Apples"));
	list2->Add(new ITEM("Grapes"));

	// Sort the list, then print it out.
	list2->Sort();
	printf("There are %d items in list 2.\n", list2->Count());
	for (item = (ITEM *)list2->first; item; item = (ITEM *)item->next)
		printf("%s\n", item->name);
	printf("\n");

	// Find the "Oranges" item in the second list.
	item = (ITEM *)list2->Get(ITEM::Find, "Oranges");
	printf("Found %s in list 2.\n", item->name);
	index = list2->Index(item);
	printf("It is item number %d in the list.\n", index + 1);


	// The first list's destructor is called automatically when the scope
	// of main ends.  The second list destructor must be called manually.
	delete list2;
}
