//	Program name..	Example demonstrating the UI_MS_MOUSE class object.
//	Filename......	XMSMOUSE.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <graphics.h>
#include <ui_map.hpp>

static UI_PALETTE palette = { ' ', attrib(LIGHTGRAY, LIGHTGRAY),
	attrib(MONO_DIM, MONO_DIM), SOLID_FILL, attrib(LIGHTGRAY, LIGHTGRAY),
	attrib(BW_WHITE, BW_WHITE), attrib(GS_WHITE, GS_WHITE) };

main()
{
	// Initialize the display, trying for graphics first.
	UI_DISPLAY *display = new UI_DOS_BGI_DISPLAY;
	if (!display->installed)
	{
		delete display;
		display = new UI_DOS_TEXT_DISPLAY;
	}

	// Add the keyboard, mouse, and cursor devices to the event manager.
	UI_EVENT_MANAGER eventManager(100, display);
	eventManager
		+ new UI_BIOS_KEYBOARD				// Add the keyboard device.
		+ new UI_MS_MOUSE					// Add the mouse device.
		+ new UI_CURSOR;					// Add the cursor device.

	// Get events from the keyboard until the <Esc> key is pressed.
	UI_EVENT event;
	UI_REGION position;
	int brushSize = 1;
	do
	{
		eventManager.Get(event, Q_NORMAL);

		// Change brush size (pressing keys 1 - 9).
		if (event.type == E_KEY && event.key.value > '0' &&
			event.key.value <= '9')
			brushSize = event.key.value - '0';

		// Move cursor when mouse button is pressed.
		if (event.type == E_MOUSE && FlagSet(event.rawCode, M_LEFT))
		{
			position.left = event.position.column;
			position.right = position.left + brushSize;
			position.top = event.position.line;
			position.bottom = position.top + brushSize;
			display->Fill(ID_SCREEN, position, &palette);
		}

		// Move cursor when mouse button is pressed.
		if (event.type == E_MOUSE && FlagSet(event.rawCode, M_RIGHT))
		{
			position.left = event.position.column;
			position.right = position.left + brushSize;
			position.top = event.position.line;
			position.bottom = position.top + brushSize;
			display->Fill(ID_SCREEN, position, _backgroundPalette);
		}
	} while (event.type != L_EXIT &&
		(event.type != E_KEY || event.rawCode != ESCAPE));

	// Clean up.
	delete display;
}
