//	Program name..	Example demonstrating the UI_DATE class object.
//	Filename......	XDATE.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdio.h>		// include file for printf
#include <ui_gen.hpp>

main()
{
	UI_TIME currentTime;		// Use the system time.
	UI_TIME beginLunch("12:00 pm");
	UI_TIME endLunch("1:00 pm");

	// Print out the time in various forms.
	int hour, minute, second;
	currentTime.Export(&hour, &minute, &second, 0);
	printf("Integer time value: hour-%d, minute-%d, second-%d\n",
		hour, minute, second);

	char asciiTime[128];
	currentTime.Export(asciiTime, TMF_NO_FLAGS);
	printf("Ascii time value: %s\n\n", asciiTime);

	// Check the time.
	if (currentTime < beginLunch)
		printf("It's morning.\n");
	else if (currentTime == endLunch || currentTime > endLunch)
		printf("It's afternoon.\n");
	else
		printf("Gone to lunch.\n");
}
