//	Program name..	Example demonstrating the UIW_MATRIX class object.
//	Filename......	XWMATRIX.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>

static UIW_WINDOW *SampleMatrix(UIW_WINDOW *window)
{
	*window
		+ new UIW_TITLE(" Sample matrix ", WOF_JUSTIFY_CENTER)

		+ new UIW_PROMPT(2, 1, "Matrix.............", WOF_NO_FLAGS)
		+ new UIW_SCROLL_BAR(63, 1, 1, 6, SBF_VERTICAL, WOF_NO_FLAGS)
		+ &(*new UIW_MATRIX(22, 1, 41, 6, 5, 14, 1, 0, MXF_NO_FLAGS, WOF_BORDER, WOAF_NO_FLAGS)
			+ new UIW_STRING(0, 0, 19, "Item 1.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 0, 19, "Item 1.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 1, 19, "Item 2.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 1, 19, "Item 2.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 2, 19, "Item 3.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 2, 19, "Item 3.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 3, 19, "Item 4.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 3, 19, "Item 4.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 4, 19, "Item 5.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 4, 19, "Item 5.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 5, 19, "Item 6.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 5, 19, "Item 6.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 6, 19, "Item 7.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 6, 19, "Item 7.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 7, 19, "Item 8.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 7, 19, "Item 8.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 8, 19, "Item 9.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 8, 19, "Item 9.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 9, 19, "Item 10.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 9, 19, "Item 10.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(0, 10, 19, "Item 11.1", 64, STF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_STRING(20, 10, 19, "Item 11.2", 64, STF_NO_FLAGS, WOF_NO_FLAGS));

	return (window);
}

main()
{
	// Check and initialize the display to graphics (or text if no graphics).
	UI_DISPLAY *display = new UI_DOS_BGI_DISPLAY();
	if (!display->installed)
	{
		delete display;
		display = new UI_DOS_TEXT_DISPLAY();
	}

	// Initialize the event and screen managers.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(100, display);
	*eventManager
		+ new UI_BIOS_KEYBOARD
		+ new UI_MS_MOUSE
		+ new UI_CURSOR;

	UI_WINDOW_MANAGER *windowManager =
		new UI_WINDOW_MANAGER(display, eventManager);

	// Create a window in the screen center with text inside.
	int centerX = display->columns / display->cellWidth / 2;
	int centerY = display->lines / display->cellHeight / 2;
	UIW_WINDOW *window = new UIW_WINDOW(centerX - 34, centerY - 6, 67, 11, WOF_NO_FLAGS, WOAF_NO_FLAGS);
	*window
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ &(*new UIW_SYSTEM_BUTTON
			+ new UIW_POP_UP_ITEM("~Restore", MNIF_RESTORE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("~Move", MNIF_MOVE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("~Size", MNIF_SIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("Mi~nimize", MNIF_MINIMIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("Ma~ximize", MNIF_MAXIMIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM
			+ new UIW_POP_UP_ITEM("~Close", MNIF_CLOSE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0));
	SampleMatrix(window);
	*windowManager + window;

	/* Process the events */
	int ccode;
	UI_EVENT event;
	do
	{
		/* Get a new event */
		eventManager->Get(event, Q_NORMAL);
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete windowManager;
	delete eventManager;
	delete display;
}
