//	Program name..	Example demonstrating the UIW_SCROLL_BAR class object.
//	Filename......	XWSCROLL.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>

main()
{
	// Check and initialize the display to graphics (or text if no graphics).
	UI_DISPLAY *display = new UI_DOS_BGI_DISPLAY();
	if (!display->installed)
	{
		delete display;
		display = new UI_DOS_TEXT_DISPLAY();
	}

	// Initialize the event and screen managers.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(100, display);
	*eventManager + new UI_BIOS_KEYBOARD + new UI_MS_MOUSE + new UI_CURSOR;

	UI_WINDOW_MANAGER *windowManager =
		new UI_WINDOW_MANAGER(display, eventManager);

	// Create a scrollable menu.
	UIW_WINDOW *menuWindow = new UIW_WINDOW(5, 5, 50, 14, WOF_NO_FLAGS, WOAF_NO_FLAGS);
	*menuWindow
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("Sample menu")
		+ new UIW_SCROLL_BAR(14, 1, 1, 5, SBF_VERTICAL, WOF_BORDER)
		+ &(*new UIW_MATRIX(2, 1, 12, 5, 10, 12, 1, 0, MXF_SELECT_ONE, WOF_BORDER, WOAF_NO_FLAGS)
			+ new UIW_POP_UP_ITEM(0, 0, 12, " Option 1", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(0, 1, 12, " Option 2", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(0, 2, 12, " Option 3", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(0, 3, 12, " Option 4", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(0, 4, 12, " Option 5", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(0, 5, 12, " Option 6", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(0, 6, 12, " Option 7", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(0, 7, 12, " Option 8", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(0, 8, 12, " Option 9", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(0, 9, 12, " Option 10", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0))
		+ &(*new UIW_POP_UP_MENU(20, 1, MNF_SELECT_ONE, WOF_BORDER, WOAF_NO_FLAGS)
			+ new UIW_POP_UP_ITEM(" Option 1", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 2", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 3", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 4", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 5", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 6", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 7", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 8", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 9", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM(" Option 10", MNIF_NO_FLAGS, BTF_CHECK_MARK, WOF_NO_FLAGS, 0));
	*windowManager + menuWindow;

	// Process the events.
	int ccode;
	UI_EVENT event;
	do
	{
		// Get a new event.
		eventManager->Get(event, Q_NORMAL);
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete windowManager;
	delete eventManager;
	delete display;
}

