//	Program name..	Example demonstrating the UIW_TIME class object.
//	Filename......	XWTIME.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>

static UIW_WINDOW *SampleTimes(UIW_WINDOW *window)
{
	UI_TIME time;
	*window
		+ new UIW_TITLE(" Sample times ", WOF_JUSTIFY_CENTER)

		+ new UIW_TEXT(43, 1, 20, 6,
			"All edited times should be in the range 6:00am..10:00pm",
			128, TXF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE | WOF_BORDER)

		+ new UIW_PROMPT(2, 2, "Standard...........", WOF_NO_FLAGS)
		+ new UIW_TIME(22, 2, 20, &time, 
			"6:00am..10:00pm", TMF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 3, "Twenty-four hour...", WOF_NO_FLAGS)
		+ new UIW_TIME(22, 3, 20, &time, 
			"6:00am..10:00pm", TMF_TWENTY_FOUR_HOUR | TMF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 4, "Colon & zero fill..", WOF_NO_FLAGS)
		+ new UIW_TIME(22, 4, 20, &time, 
			"6:00am..10:00pm", TMF_COLON_SEPARATOR | TMF_ZERO_FILL | TMF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 5, "Seconds...........", WOF_NO_FLAGS)
		+ new UIW_TIME(22, 5, 20, &time, 
			"6:00am..10:00pm", TMF_SECONDS | TMF_SYSTEM, WOF_BORDER | WOF_AUTO_CLEAR);

	return (window);
}

main()
{
	// Check and initialize the display to graphics (or text if no graphics).
	UI_DISPLAY *display = new UI_DOS_BGI_DISPLAY();
	if (!display->installed)
	{
		delete display;
		display = new UI_DOS_TEXT_DISPLAY();
	}

	// Initialize the event and screen managers.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(100, display);
	*eventManager
		+ new UI_BIOS_KEYBOARD
		+ new UI_MS_MOUSE
		+ new UI_CURSOR;

	UI_WINDOW_MANAGER *windowManager =
		new UI_WINDOW_MANAGER(display, eventManager);

	// Initialize the error system.
	_errorSystem = new UI_ERROR_WINDOW_SYSTEM;

	// Create a window in the screen center with text inside.
	int centerX = display->columns / display->cellWidth / 2;
	int centerY = display->lines / display->cellHeight / 2;
	UIW_WINDOW *window = new UIW_WINDOW(centerX - 34, centerY - 6, 67, 11, WOF_NO_FLAGS, WOAF_NO_FLAGS);
	*window
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ &(*new UIW_SYSTEM_BUTTON
			+ new UIW_POP_UP_ITEM("~Restore", MNIF_RESTORE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("~Move", MNIF_MOVE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("~Size", MNIF_SIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("Mi~nimize", MNIF_MINIMIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("Ma~ximize", MNIF_MAXIMIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM
			+ new UIW_POP_UP_ITEM("~Close", MNIF_CLOSE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0));
	SampleTimes(window);
	*windowManager + window;

	/* Process the events */
	int ccode;
	UI_EVENT event;
	do
	{
		/* Get a new event */
		eventManager->Get(event, Q_NORMAL);
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete _errorSystem;
	delete windowManager;
	delete eventManager;
	delete display;
}
