//	Program name..	Zinc Interface Library
//	Filename......	COUNTRY.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#pragma inline

#include <dos.h>
#include <stdio.h>
#include <string.h>
#include "ui_gen.hpp"

struct dos2_country
{
	int date_format;
	char currency[2];
	char thousands[2];
	char decimal[2];
	char reserved[24];
};

int countryCode;

struct countryInfo near _countryInfo;		// Make "near" to force into DGROUP.
static UCHAR gotInfo = FALSE;

void GetCountryInfo(void)
{
	static struct dos2_country near dos2_country;

	if (!gotInfo)
	{
		gotInfo = TRUE;
		if (_osmajor == 2)
			_DX = (USHORT) &dos2_country;
		else
			_DX = (USHORT) &_countryInfo;
		_AX = 0x3800;
		geninterrupt(0x21);
		countryCode = (_AL == 0xFF) ? _BX : _AL;
		if (_osmajor == 2)
		{
			memset( &_countryInfo, '\0', sizeof(_countryInfo) );
			_countryInfo.co_date = dos2_country.date_format;
			strcpy(_countryInfo.co_curr, dos2_country.currency);
			strcpy(_countryInfo.co_thsep, dos2_country.thousands);
			strcpy(_countryInfo.co_desep, dos2_country.decimal);
			_countryInfo.co_dtsep[0] = '/';
			_countryInfo.co_tmsep[0] = ':';
			/* Leave co_currstyle set to 0. */
			_countryInfo.co_digits = 2;
			/* Leave co_time set to 0. */
			/* Leave co_case set to 0. */
			_countryInfo.co_dasep[0] = ',';
		}
	}
}
