//	Program name..	Zinc Interface Library
//	Filename......	CURSOR.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_evt.hpp"

void VideoInt(void);

// ----- Constructor & Destructor -------------------------------------------

UI_CURSOR::UI_CURSOR(USHORT initialState) :
	UI_DEVICE(E_CURSOR, initialState)
{
	/* Initialize the cursor device */
	lastTime = *((USHORT far *)0x46CL);
	cursorMask = DC_INSERT;
	blink = (initialState == D_OFF) ? FALSE : TRUE;
	line = column = 0;
}

// ----- Member functions ---------------------------------------------------

void UI_CURSOR::Display(USHORT displayCursorMask, USHORT displayState)
{
	if (!display)
		return;
	else if (display->isText)
	{
		_CX = (displayState == D_OFF || displayState == D_HIDE) ?
			((UI_DOS_TEXT_DISPLAY *)display)->offCursorValue :
			((UI_DOS_TEXT_DISPLAY *)display)->onCursorValue;
		if (displayState != D_OFF && displayCursorMask == DC_INSERT)
			_CH = 0;
		_AH = 1;
		VideoInt();
	}
	else if (displayState != D_OFF && displayState != D_HIDE)
	{
		UI_REGION region;
		region.left = column;
		region.top = (displayCursorMask == DC_INSERT) ? line : line + 7;
		region.right = column + 7;
		region.bottom = (displayCursorMask == DC_INSERT) ? line + 6 : line + 8;
		display->FillXOR(region);
	}
}

int UI_CURSOR::Event(const UI_EVENT &event)
{
	if (state == DC_INVALID)
		return (state);

	/* Switch on the rawCode */
	USHORT ccode = event.rawCode;
	USHORT t_cursorMask = cursorMask;
	USHORT t_state = state;
	display->MakeActive();					// Insure this display is active.
	switch (ccode)
	{
	case D_HIDE:
	case D_SHOW:
		if (state == D_OFF)
			return (state);
		UI_REGION region;
		if (display->isText)
		{
			region.left = region.right = column;
			region.top = region.bottom = line;
		}
		else
		{
			region.left = column;
			region.top = (cursorMask == DC_INSERT) ? line : line + 7;
			region.right = column + 7;
			region.bottom = (cursorMask == DC_INSERT) ? line + 6 : line + 8;
		}
 		if (max(event.region.left, region.left) > min(event.region.right, region.right) ||
			max(event.region.top, region.top) > min(event.region.bottom, region.bottom))
			return(0);
		state = (ccode == D_HIDE) ? D_HIDE : D_ON;
		blink = (ccode == D_HIDE) ? FALSE : TRUE;
		break;

	case DC_BLINK:
		state = (state == D_ON) ? D_OFF : D_ON;
		break;

	case DC_INSERT:
	case DC_OVERTYPE:
	case DC_INSERT_OFF:
	case DC_OVERTYPE_OFF:
	case D_OFF:
	case D_ON:
		if (ccode == DC_INSERT_OFF || ccode == DC_INSERT)
			cursorMask = DC_INSERT;
		else if (ccode == DC_OVERTYPE_OFF || ccode == DC_OVERTYPE)
			cursorMask = DC_OVERTYPE;
		if ( ccode == D_OFF ||
			(!display->isText && (ccode == DC_INSERT_OFF || ccode == DC_OVERTYPE_OFF) ) )
			state = D_OFF;
		else
			state = D_ON;
		blink = (ccode == D_OFF) ? FALSE : TRUE;
		lastTime = *((USHORT far *)0x46CL);		// Reset blink count
		break;

	case D_INITIALIZE:
		t_state = (display->isText) ? D_ON : D_OFF;
		if (display->isText)		// Change the cursor position.
		{
			_BH = 0;
			_DH = line;
			_DL = column;
			_AH = 2;
			VideoInt();
		}
		break;

	case D_POSITION:
		if (event.position.line == line && event.position.column == column)
			return (state);
		if (!display->isText && state != D_OFF)
		{
			Display(cursorMask, state);
			t_state = D_OFF;
		}
		line = event.position.line;
		column = event.position.column;
		if (display->isText)
		{
			_BH = 0;
			_DH = line;
			_DL = column;
			_AH = 2;
			VideoInt();
		}
		break;

	default:
		return (state);
	}

	/* Change the cursor state */
	if (t_cursorMask != cursorMask || t_state != state)
	{
		USHORT t2_state = state;
		state = DC_INVALID;
		UI_REGION region;
		if (display->isText)
		{
			region.left = region.right = column;
			region.top = region.bottom = line;
		}
		else
		{
			region.left = column - 1;
			region.top = line;
			region.right = column + 7;
			region.bottom = line + 7;
		}
		eventManager->DevicesHide(region);
		if (!display->isText)
			Display(t_cursorMask, t_state);
		Display(cursorMask, t2_state);
		eventManager->DevicesShow(region);
		state = t2_state;
	}

	/* Return the device state */
	return (state);
}

void UI_CURSOR::Poll(void)
{
	/* Check the state and time of the cursor */
	USHORT currentTime = *((USHORT far *)0x46CL);
	if (!display->isText && blink && currentTime - lastTime > 6)
	{
		UI_EVENT t_event;
		t_event.rawCode = DC_BLINK;
		Event(t_event);
		lastTime = currentTime;
	}
}

