//	Program name..	Zinc Interface Library
//	Filename......	ERRORWIN.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dos.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "ui_win.hpp"

const int MAX_ERROR_MESSAGE = 2048;

// Static functions ---------------------------------------------------------

static void Continue(void *data, UI_EVENT &event)
{
	UIW_PULL_DOWN_ITEM *item = (UIW_PULL_DOWN_ITEM *)data;

	// Push on the error message so edit object can redisplay cursor.
	event.type = S_ERROR_RESPONSE;
	event.rawCode = 0;
	item->eventManager->Put(event, Q_BEGIN);

	// Push on a window delete message.  This deletes the error window.
	event.type = S_DELETE;
	item->eventManager->Put(event, Q_BEGIN);
}

static void LeaveInvalid(void *object, UI_EVENT &event)
{
	UIW_PULL_DOWN_ITEM *item = (UIW_PULL_DOWN_ITEM *)object;

	// Push on the error message.
	event.type = S_ERROR_RESPONSE;
	event.rawCode = WOS_INVALID;
	item->eventManager->Put(event, Q_BEGIN);

	// Push on a window delete message.  This deletes the error window.
	event.type = S_DELETE;
	item->eventManager->Put(event, Q_BEGIN);
}

static void LeaveUnanswered(void *data, UI_EVENT &event)
{
	UIW_PULL_DOWN_ITEM *item = (UIW_PULL_DOWN_ITEM *)data;

	// Push on the error message.
	event.type = S_ERROR_RESPONSE;
	event.rawCode = WOS_UNANSWERED;
	item->eventManager->Put(event, Q_BEGIN);

	// Push on a window delete message.  This deletes the error window.
	event.type = S_DELETE;
	item->eventManager->Put(event, Q_BEGIN);
}

// Constructor & Destructor -------------------------------------------------

UI_ERROR_WINDOW_SYSTEM::UI_ERROR_WINDOW_SYSTEM(void)
{
	// Create the error window.
	errorWindow = new UIW_WINDOW(10, 5, -10, 8, WOF_NO_FLAGS,
		WOAF_MODAL | WOAF_NO_DESTROY, NO_HELP_CONTEXT);
	errorWindow->paletteMapTable = _errorPaletteMapTable;

	message = new char[MAX_ERROR_MESSAGE];
	*errorWindow
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ &(*new UIW_SYSTEM_BUTTON
			+ new UIW_POP_UP_ITEM("~Restore", MNIF_RESTORE, BTF_NO_TOGGLE,
				WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("~Move", MNIF_MOVE, BTF_NO_TOGGLE,
				WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("~Size", MNIF_SIZE, BTF_NO_TOGGLE,
				WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("Mi~nimize", MNIF_MINIMIZE, BTF_NO_TOGGLE,
				WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("Ma~ximize", MNIF_MAXIMIZE, BTF_NO_TOGGLE,
				WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM
			+ new UIW_POP_UP_ITEM("~Close", MNIF_CLOSE, BTF_NO_TOGGLE,
				WOF_NO_FLAGS, Continue))
		+ new UIW_TITLE("Error", WOF_JUSTIFY_CENTER)
		+ &(*new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
			+ (continueEditField = new UIW_PULL_DOWN_ITEM(
				" ~Continue Edit ", MNF_NO_FLAGS, Continue))
			+ (leaveUnansweredField = new UIW_PULL_DOWN_ITEM(
				" Leave ~Unanswered ", MNF_NO_FLAGS, LeaveUnanswered))
			+ (leaveInvalidField = new UIW_PULL_DOWN_ITEM(
				" Leave ~Invalid ", MNF_NO_FLAGS, LeaveInvalid)))
		+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL, WOF_NON_FIELD_REGION)
		+ (textField = new UIW_TEXT(0, 0, 0, 0, message,
			MAX_ERROR_MESSAGE, TXF_NO_FLAGS, WOF_NO_ALLOCATE_DATA |
			WOF_VIEW_ONLY | WOF_NON_FIELD_REGION, 0));
}

UI_ERROR_WINDOW_SYSTEM::~UI_ERROR_WINDOW_SYSTEM(void)
{
	// Delete the error window system class information.
	delete message;
	if (errorWindow->windowManager)
		*(errorWindow->windowManager) - errorWindow;
	delete errorWindow;
}

// Member functions ---------------------------------------------------------

void UI_ERROR_WINDOW_SYSTEM::ReportError(UI_WINDOW_MANAGER *windowManager,
	USHORT woFlags, char *format, ...)
{
	// Beep, then display the error.
	Beep();
	if (!windowManager)
		return;

	// Format the error message.
	va_list arguments;
    va_start(arguments, format);
	vsprintf(message, format, arguments);

	// Add the error window to the window manager.
	if (FlagSet(woFlags, WOF_NO_UNANSWERED))
		leaveUnansweredField->woFlags |= WOF_NON_SELECTABLE;
	else
		leaveUnansweredField->woFlags &= ~WOF_NON_SELECTABLE;
	if (FlagSet(woFlags, WOF_NO_INVALID))
		leaveInvalidField->woFlags |= WOF_NON_SELECTABLE;
	else
		leaveInvalidField->woFlags &= ~WOF_NON_SELECTABLE;
	*windowManager + errorWindow;
}
