//	Program name..	Zinc Interface Library
//	Filename......	G_EVENT.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_map.hpp"

static UI_EVENT_MAP eventMapTable[] =
{
	{ ID_WINDOW_MANAGER, 	L_EXIT,				E_KEY, 		SHIFT_F3 },
	{ ID_WINDOW_MANAGER, 	L_EXIT,				E_KEY, 		CTRL_BREAK },
	{ ID_WINDOW_MANAGER, 	L_EXIT,				E_KEY, 		CTRL_C },
	{ ID_WINDOW_MANAGER, 	S_DELETE_LEVEL,		E_KEY, 		ESCAPE },
	{ ID_WINDOW_MANAGER, 	L_GENERAL_HELP,		E_KEY, 		ALT_F1 },
	{ ID_WINDOW_MANAGER, 	S_DELETE,			E_KEY, 		ALT_F4 },
	{ ID_WINDOW_MANAGER, 	S_DELETE,			E_KEY, 		F3	 },
	{ ID_WINDOW_MANAGER, 	L_WINDOW_MOVE,		E_KEY, 		ALT_F7 },
	{ ID_WINDOW_MANAGER, 	L_WINDOW_SIZE,		E_KEY, 		ALT_F8 },
	{ ID_WINDOW_MANAGER, 	L_WINDOW_NEXT,		E_KEY, 		ALT_F6 },
	{ ID_WINDOW_MANAGER, 	S_REDISPLAY,		E_KEY, 		F5 },

	{ ID_WINDOW,			L_CONTEXT_HELP,		E_KEY, 		F1 },

	{ ID_WINDOW_OBJECT, 	L_SELECT,			E_KEY, 		ENTER },
	{ ID_WINDOW_OBJECT, 	L_SELECT,			E_KEY, 		GRAY_ENTER },
	{ ID_WINDOW_OBJECT, 	L_VIEW,				E_MOUSE, 	0 },
	{ ID_WINDOW_OBJECT, 	L_BEGIN_SELECT,		E_MOUSE, 	M_LEFT | M_LEFT_CHANGE },
	{ ID_WINDOW_OBJECT, 	L_CONTINUE_SELECT,	E_MOUSE, 	M_LEFT },
	{ ID_WINDOW_OBJECT, 	L_END_SELECT,		E_MOUSE, 	M_LEFT_CHANGE },
	{ ID_WINDOW_OBJECT,		S_CANCEL,			E_KEY, 		F12 },

	{ ID_WINDOW_OBJECT, 	L_FIELD_UP,			E_KEY, 		GRAY_UP_ARROW },
	{ ID_WINDOW_OBJECT, 	L_FIELD_UP,			E_KEY, 		WHITE_UP_ARROW },
	{ ID_WINDOW_OBJECT, 	L_FIELD_DOWN,		E_KEY, 		GRAY_DOWN_ARROW },
	{ ID_WINDOW_OBJECT, 	L_FIELD_DOWN,		E_KEY, 		WHITE_DOWN_ARROW },
	{ ID_WINDOW_OBJECT, 	L_FIELD_LEFT,		E_KEY, 		GRAY_LEFT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_FIELD_LEFT,		E_KEY, 		WHITE_LEFT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_FIELD_RIGHT,		E_KEY, 		GRAY_RIGHT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_FIELD_RIGHT,		E_KEY, 		WHITE_RIGHT_ARROW },
	{ ID_WINDOW_OBJECT, 	L_FIELD_PREVIOUS,	E_KEY, 		BACKTAB },
	{ ID_WINDOW_OBJECT, 	L_FIELD_PREVIOUS,	E_KEY, 		SHIFT_F6 },
	{ ID_WINDOW_OBJECT, 	L_FIELD_NEXT,		E_KEY, 		TAB },
	{ ID_WINDOW_OBJECT, 	L_FIELD_NEXT,		E_KEY, 		F6 },
	{ ID_WINDOW_OBJECT, 	L_FIELD_FIRST,		E_KEY, 		WHITE_PGUP },
	{ ID_WINDOW_OBJECT, 	L_FIELD_FIRST,		E_KEY, 		GRAY_PGUP },
	{ ID_WINDOW_OBJECT, 	L_FIELD_LAST,		E_KEY, 		WHITE_PGDN },
	{ ID_WINDOW_OBJECT, 	L_FIELD_LAST,		E_KEY, 		GRAY_PGDN },
	{ ID_WINDOW_OBJECT, 	L_WINDOW_RESTORE,	E_KEY, 		ALT_F5 },
	{ ID_WINDOW_OBJECT, 	L_INSERT_TOGGLE,	E_KEY,		WHITE_INSERT},
	{ ID_WINDOW_OBJECT, 	L_INSERT_TOGGLE,	E_KEY,		GRAY_INSERT},
	{ ID_WINDOW_OBJECT,		S_ALT_KEY,			E_KEY, 		F10 },

	{ ID_MATRIX, 			L_PGUP,				E_KEY, 		WHITE_PGUP },
	{ ID_MATRIX, 			L_PGUP,				E_KEY, 		GRAY_PGUP },
	{ ID_MATRIX, 			L_PGDN,				E_KEY, 		WHITE_PGDN },
	{ ID_MATRIX, 			L_PGDN,				E_KEY, 		GRAY_PGDN },

	{ ID_MENU, 				L_ITEM_UP,			E_KEY, 		GRAY_UP_ARROW },
	{ ID_MENU, 				L_ITEM_UP,			E_KEY, 		WHITE_UP_ARROW },
	{ ID_MENU, 				L_ITEM_DOWN,		E_KEY, 		GRAY_DOWN_ARROW },
	{ ID_MENU, 				L_ITEM_DOWN,		E_KEY, 		WHITE_DOWN_ARROW },
	{ ID_MENU, 				L_ITEM_LEFT,		E_KEY, 		GRAY_LEFT_ARROW },
	{ ID_MENU, 				L_ITEM_LEFT,		E_KEY, 		WHITE_LEFT_ARROW },
	{ ID_MENU, 				L_ITEM_RIGHT,		E_KEY, 		GRAY_RIGHT_ARROW },
	{ ID_MENU, 				L_ITEM_RIGHT,		E_KEY, 		WHITE_RIGHT_ARROW },
	{ ID_MENU, 				L_ITEM_PREVIOUS,	E_KEY, 		BACKTAB },
	{ ID_MENU, 				L_ITEM_PREVIOUS,	E_KEY, 		SHIFT_F6 },
	{ ID_MENU, 				L_ITEM_NEXT,		E_KEY, 		TAB },
	{ ID_MENU, 				L_ITEM_NEXT,		E_KEY, 		F6 },
	{ ID_MENU, 				L_ITEM_FIRST,		E_KEY, 		WHITE_PGUP },
	{ ID_MENU, 				L_ITEM_FIRST,		E_KEY, 		GRAY_PGUP },
	{ ID_MENU, 				L_ITEM_LAST,		E_KEY, 		WHITE_PGDN },
	{ ID_MENU, 				L_ITEM_LAST,		E_KEY, 		GRAY_PGDN },

	{ ID_STRING, 			L_BEGIN_MARK,		E_MOUSE,	M_LEFT | M_LEFT_CHANGE},
	{ ID_STRING, 			L_CONTINUE_MARK,	E_MOUSE,	M_LEFT},
	{ ID_STRING, 			L_END_MARK,			E_MOUSE,	M_LEFT_CHANGE},
	{ ID_STRING, 			L_CUT_PASTE,		E_MOUSE,	M_RIGHT | M_RIGHT_CHANGE},
	{ ID_STRING, 			L_COPY_MARK,		E_MOUSE,	M_LEFT | M_RIGHT | M_RIGHT_CHANGE},
	{ ID_STRING, 			L_UNDO,				E_MOUSE,	S_ALT | M_LEFT | M_LEFT_CHANGE},
	{ ID_STRING, 			L_REDO,				E_MOUSE,	S_ALT | M_RIGHT | M_RIGHT_CHANGE},
	{ ID_STRING, 			L_MOVE,				E_MOUSE,	0},
	{ ID_STRING, 			L_MARK,				E_KEY,		CTRL_F5},
	{ ID_STRING, 			L_CUT,				E_KEY,		CTRL_F6},
	{ ID_STRING, 			L_COPY_MARK,		E_KEY,		CTRL_F7},
	{ ID_STRING, 			L_PASTE,			E_KEY,		CTRL_F8},
	{ ID_STRING, 			L_UNDO,				E_KEY,		CTRL_F9},
	{ ID_STRING, 			L_REDO,				E_KEY,		CTRL_F10},
	{ ID_STRING, 			L_DELETE,			E_KEY,		WHITE_DELETE},
	{ ID_STRING, 			L_DELETE,			E_KEY,		GRAY_DELETE},
	{ ID_STRING, 			L_DELETE_WORD,		E_KEY,		CTRL_WHITE_DELETE},
	{ ID_STRING, 			L_DELETE_WORD,		E_KEY,		CTRL_GRAY_DELETE},
	{ ID_STRING, 			L_DELETE_EOL,		E_KEY,		CTRL_BACKSPACE},
	{ ID_STRING, 			L_WORD_TAB_LEFT,	E_KEY,		CTRL_WHITE_LEFT_ARROW},
	{ ID_STRING, 			L_WORD_TAB_LEFT,	E_KEY,		CTRL_GRAY_LEFT_ARROW},
	{ ID_STRING, 			L_WORD_TAB_LEFT,	E_KEY,		ALT_GRAY_LEFT_ARROW},
	{ ID_STRING, 			L_WORD_TAB_RIGHT,	E_KEY,		CTRL_WHITE_RIGHT_ARROW},
	{ ID_STRING, 			L_WORD_TAB_RIGHT,	E_KEY,		CTRL_GRAY_RIGHT_ARROW},
	{ ID_STRING, 			L_WORD_TAB_RIGHT,	E_KEY,		ALT_GRAY_RIGHT_ARROW},
	{ ID_STRING, 			L_MOVE_BOL,			E_KEY,		WHITE_HOME},
	{ ID_STRING, 			L_MOVE_BOL,			E_KEY,		GRAY_HOME},
	{ ID_STRING, 			L_MOVE_BOL,			E_KEY,		CTRL_WHITE_HOME},
	{ ID_STRING, 			L_MOVE_BOL,			E_KEY,		CTRL_GRAY_HOME},
	{ ID_STRING, 			L_MOVE_EOL,			E_KEY,		WHITE_END},
	{ ID_STRING, 			L_MOVE_EOL,			E_KEY,		GRAY_END},
	{ ID_STRING, 			L_MOVE_EOL,			E_KEY,		CTRL_WHITE_END},
	{ ID_STRING, 			L_MOVE_EOL,			E_KEY,		CTRL_GRAY_END},
	{ ID_STRING, 			L_MOVE_LEFT,		E_KEY,		WHITE_LEFT_ARROW},
	{ ID_STRING, 			L_MOVE_LEFT,		E_KEY,		GRAY_LEFT_ARROW},
	{ ID_STRING, 			L_MOVE_RIGHT,		E_KEY,		WHITE_RIGHT_ARROW},
	{ ID_STRING, 			L_MOVE_RIGHT,		E_KEY,		GRAY_RIGHT_ARROW},

	{ ID_TEXT,				L_MOVE_TOP,			E_KEY,	 	CTRL_WHITE_HOME},
	{ ID_TEXT,				L_MOVE_TOP,			E_KEY,	 	CTRL_GRAY_HOME},
	{ ID_TEXT,				L_MOVE_BOTTOM,		E_KEY,	 	CTRL_WHITE_END},
	{ ID_TEXT,				L_MOVE_BOTTOM,		E_KEY,	 	CTRL_GRAY_END},
	{ ID_TEXT,				L_MOVE_PAGE_UP,		E_KEY,	 	WHITE_PGUP},
	{ ID_TEXT,				L_MOVE_PAGE_UP,		E_KEY,	 	GRAY_PGUP},
	{ ID_TEXT,				L_MOVE_PAGE_DOWN,	E_KEY,	 	WHITE_PGDN},
	{ ID_TEXT,				L_MOVE_PAGE_DOWN,	E_KEY,	 	GRAY_PGDN},
	{ ID_TEXT,				L_MOVE_UP,			E_KEY,	 	WHITE_UP_ARROW},
	{ ID_TEXT,				L_MOVE_UP,			E_KEY,	 	GRAY_UP_ARROW},
	{ ID_TEXT,				L_MOVE_DOWN,		E_KEY,	 	WHITE_DOWN_ARROW},
	{ ID_TEXT,				L_MOVE_DOWN,		E_KEY,	 	GRAY_DOWN_ARROW},
	{ ID_TEXT,				E_KEY,				E_KEY,	 	ENTER},
	{ ID_TEXT,				E_KEY,				E_KEY,	 	GRAY_ENTER},

	{ ID_TEXT_VIEW, 		L_MOVE,				E_MOUSE,	0},
	{ ID_TEXT_VIEW,			L_MOVE_TOP,			E_KEY,	 	CTRL_WHITE_HOME},
	{ ID_TEXT_VIEW,			L_MOVE_TOP,			E_KEY,	 	CTRL_GRAY_HOME},
	{ ID_TEXT_VIEW,			L_MOVE_BOTTOM,		E_KEY,	 	CTRL_WHITE_END},
	{ ID_TEXT_VIEW,			L_MOVE_BOTTOM,		E_KEY,	 	CTRL_GRAY_END},
	{ ID_TEXT_VIEW,			L_MOVE_PAGE_UP,		E_KEY,	 	WHITE_PGUP},
	{ ID_TEXT_VIEW,			L_MOVE_PAGE_UP,		E_KEY,	 	GRAY_PGUP},
	{ ID_TEXT_VIEW,			L_MOVE_PAGE_DOWN,	E_KEY,	 	WHITE_PGDN},
	{ ID_TEXT_VIEW,			L_MOVE_PAGE_DOWN,	E_KEY,	 	GRAY_PGDN},
	{ ID_TEXT_VIEW,			L_MOVE_UP,			E_KEY,	 	WHITE_UP_ARROW},
	{ ID_TEXT_VIEW,			L_MOVE_UP,			E_KEY,	 	GRAY_UP_ARROW},
	{ ID_TEXT_VIEW,			L_MOVE_DOWN,		E_KEY,	 	WHITE_DOWN_ARROW},
	{ ID_TEXT_VIEW,			L_MOVE_DOWN,		E_KEY,	 	GRAY_DOWN_ARROW},

	// End of array.
	{ ID_END, 0, 0, 0 }
};
UI_EVENT_MAP *_eventMapTable = eventMapTable;

