//	Program name..	Zinc Interface Library
//	Filename......	MAX.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include "ui_win.hpp"

// ----- Constructor & Destructor -------------------------------------------

UIW_MAXIMIZE_BUTTON::UIW_MAXIMIZE_BUTTON(void) :
	UIW_BUTTON(0, 0, 0, 0, BTF_NO_FLAGS,
		WOF_JUSTIFY_CENTER | WOF_NON_FIELD_REGION,
		UIW_MAXIMIZE_BUTTON::MaximizeUserFunction)
{
	windowID[0] = ID_MAXIMIZE_BUTTON;
	windowID[1] = ID_BUTTON;
	hotKey = HOT_KEY_MAXIMIZE;
	woAdvancedFlags |= WOAF_NON_CURRENT;
}

// ----- Member functions ---------------------------------------------------

int UIW_MAXIMIZE_BUTTON::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	int ccode = event.type;
	switch (ccode)
	{
	case S_CREATE:
		if (string)
			delete string;
		string = ui_strdup(" ");
		// Continue to S_SIZE.

	case S_SIZE:
		string[0] = (FlagSet(parent->woAdvancedStatus, WOAS_MAXIMIZED)) ?
			0x12 : 0x18;
		if (display->isText)
		{
			true.top = true.bottom = parent->true.top;
			true.left = parent->true.right - 3;
			true.right = true.left + 2;
		}
		else
		{
			int height, width;
 			UIW_BUTTON::Information(GET_DEFAULT_HEIGHT, &height);
			UIW_BUTTON::Information(GET_DEFAULT_WIDTH, &width);
			UI_WINDOW_OBJECT::RegionMax(TRUE);
			true.top -= 1;
			true.right += 1;
			true.bottom = true.top + height - 1;
			true.left = true.right - width + 1;
		}
		if (FlagSet(parent->woAdvancedStatus, WOAS_MAXIMIZED))
			woStatus |= WOS_SELECTED;
		else
			woStatus &= ~WOS_SELECTED;
		if (FlagSet(parent->woAdvancedStatus, WOAS_MINIMIZED))
			woFlags |= WOF_NON_SELECTABLE;
		else
			woFlags &= ~WOF_NON_SELECTABLE;
		break;

	case S_DISPLAY_INACTIVE:
		if (display->isText)
			break;
		// Continue to S_DISPLAY_ACTIVE.

	case S_DISPLAY_ACTIVE:
		if (display->isText)
			lastPalette = 0;
		// Continue to default.

	default:
		ccode = UIW_BUTTON::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}

void UIW_MAXIMIZE_BUTTON::MaximizeUserFunction(void *button, UI_EVENT &event)
{
	// Send a maximize message to the parent window.
 	event.type = S_MAXIMIZE;
 	((UIW_BUTTON *)button)->eventManager->Put(event, Q_BEGIN);
}
