//	Program name..	Zinc Interface Library
//	Filename......	MOUSE.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#pragma inline

#include <dos.h>
#include "ui_evt.hpp"

static USHORT _oldMouseMask = 0;

UI_EVENT_MANAGER *_eventManagerPtr = 0;
UI_EVENT _mouseEvent;
int _mouseCellWidth;
int _mouseCellHeight;
long _mouseTime;
int _mouseEnabled;

static UCHAR _oldButtonState = 0;

struct {
	USHORT offset;
	USHORT segment;
} _oldMouseISR;

USHORT arrowMask[] = {
	0,			// 		Horizontal hot spot
	0,			// 		Vertical hot spot
				//	   	����������������Ŀ
	0x3FFF,		//	   	�  ���������������
	0x1FFF,		//	   	�   ��������������
	0x0FFF,		//	   	�    �������������
	0x07FF,		//	   	�     ������������
	0x03FF,		//	   	�      �����������
	0x01FF,		//	   	�       ����������
	0x00FF,		//	   	�        ���������
	0x007F,		//	   	�		  ��������
	0x003F,		//	   	�		   �������
	0x007F,		//	   	�		  ��������
	0x01FF,		//	   	�	    ����������
	0x00FF,		//	   	�		 ���������
	0xF0FF,		//	   	�����	 ���������
	0xF87F,		//	   	������    ��������
	0xF87F,		//	   	������    ��������
	0xFCFF,		//	   	�������  ���������
				//	   	������������������

				//		����������������Ŀ
	0x0000,		//		�                �
	0x4000,		//		� �              �
	0x6000,		//		� ��             �
	0x7000,		//		� ���            �
	0x7800,		//		� ����           �
	0x7C00,		//		� �����          �
	0x7E00,		//		� ������         �
	0x7F00,		//		� �������        �
	0x7F00,		//		� �������        �
	0x7C00,		//		� �����      	 �
	0x6C00,		//		� �� ��          �
	0x0600,		//		�	  ��         �
	0x0600,		//		�     ��         �
	0x0300,		//		�      ��        �
	0x0300,		//		�      ��        �
	0x0000 		//		�                �
				//		������������������
};

USHORT handMask[] = {
	4,			// 		Horizontal hot spot
	0,			// 		Vertical hot spot
				//		����������������Ŀ
	0xE1FF,		//		����    ����������
	0xE1FF,		//		����    ����������
	0xE1FF,		//		����    ����������
	0xE1FF,		//		����    ����������
	0xE1FF,		//		����    ����������
	0xE000,		//		����             �
	0xE000,		//		����             �
	0xE000,		//		����             �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
				//		������������������
				//		����������������Ŀ
	0x0000,		//		�                �
	0x0C00,		//		�    ��          �
	0x0C00,		//		�    ��          �
	0x0C00,		//		�    ��          �
	0x0C00,		//		�    ��          �
	0x0C00,		//		�    ��          �
	0x0DB6,		//		�    �� �� �� �� �
	0x0DB6,		//		�    �� �� �� �� �
	0x0DB6,		//		�    �� �� �� �� �
	0x6FFE,		//		� �� ����������� �
	0x6FFE,		//		� �� ����������� �
	0x6FFE,		//		� �� ����������� �
	0x7FFE,		//		� �������������� �
	0x7FFE,		//		� �������������� �
	0x7FFE,		//		� �������������� �
	0x0000 		//		�                �
				//		������������������
};

USHORT verticalArrowsMask[] = {
	7,			// 		Horizontal hot spot
	7,			// 		Vertical hot spot
				//		����������������Ŀ
	0xFE7F,		//		��������  ��������
	0xFC3F,		//		�������    �������
	0xF81F,		//		������      ������
	0xF00F,		//		�����        �����
	0xE007,		//		����          ����
	0xC003,		//		���            ���
	0xFC3F,		//		�������    �������
	0xFC3F,		//		�������    �������
	0xFC3F,		//		�������    �������
	0xFC3F,		//		�������    �������
	0xC003,		//		���            ���
	0xE007,		//		����          ����
	0xF00F,		//		�����        �����
	0xF81F,		//		������      ������
	0xFC3F,		//		�������    �������
	0xFE7F,		//		��������  ��������
				//		������������������
				//		����������������Ŀ
	0x0000,		//		�                �
	0x0180,		//		�       ��       �
	0x03C0,		//		�      ����      �
	0x07E0,		//		�     ������     �
	0x0FF0,		//		�    ��������    �
	0x0180,		//		�       ��       �
	0x0180,		//		�       ��       �
	0x0180,		//		�       ��       �
	0x0180,		//		�       ��       �
	0x0180,		//		�       ��       �
	0x0180,		//		�       ��       �
	0x0FF0,		//		�    ��������    �
	0x07E0,		//		�     ������     �
	0x03C0,		//		�      ����      �
	0x0180,		//		�       ��       �
	0x0000 		//		�                �
				//		������������������
};

USHORT horizontalArrowsMask[] = {
	7,			// 		Horizontal hot spot
	7,			// 		Vertical hot spot
				//		����������������Ŀ
	0xFFFF,		//		������������������
	0xFFFF,		//		������������������
	0xFBDF,		//		������ ���� ������
	0xF3CF,		//		�����  ����  �����
	0xE3C7,		//		����   ����   ����
	0xC3C3,		//		���    ����    ���
	0x8001,		//		��              ��
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x8001,		//		��              ��
	0xC3C3,		//		���    ����    ���
	0xE3C7,		//		����   ����   ����
	0xF3CF,		//		�����  ����  �����
	0xFBDF,		//		������ ���� ������
	0xFFFF,		//		������������������
	0xFFFF,		//		������������������
				//		������������������
				//		����������������Ŀ
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0810,		//		�    �      �    �
	0x1818,		//		�   ��      ��   �
	0x381C,		//		�  ���      ���  �
	0x7FFE,		//		� �������������� �
	0x7FFE,		//		� �������������� �
	0x381C,		//		�  ���      ���  �
	0x1818,		//		�   ��      ��   �
	0x0810,		//		�    �      �    �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000 		//		�                �
				//		������������������
};

USHORT ULLRArrowsMask[] = {
	7,			// 		Horizontal hot spot
	7,			// 		Vertical hot spot
				//		����������������Ŀ
	0xFFFF,		//		������������������
	0x801F,		//		��          ������
	0x803F,		//		��         �������
	0x807F,		//		��        ��������
	0x80FF,		//		��       ���������
	0x80FD,		//		��       ������ ��
	0x8079,		//		��        ����  ��
	0x8031,		//		��         ��   ��
	0x8C01,		//		��   ��         ��
	0x9E01,		//		��  ����        ��
	0xBF01,		//		�� ������       ��
	0xFF01,		//		���������       ��
	0xFE01,		//		��������        ��
	0xFC01,		//		�������         ��
	0xF801,		//		������          ��
	0xFFFF,		//		������������������
				//		������������������
				//		����������������Ŀ
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x3F00,		//		�  ������        �
	0x3E00,		//		�  �����         �
	0x3C00,		//		�  ����          �
	0x3E00,		//		�  �����         �
	0x3700,		//		�  �� ���        �
	0x2380,		//		�  �   ���       �
	0x01C4,		//		�       ���   �  �
	0x00EC,		//		�        ��� ��  �
	0x007C,		//		�         �����  �
	0x003C,		//		�          ����  �
	0x007C,		//		�         �����  �
	0x00FC,		//		�        ������  �
	0x0000,		//		�                �
	0x0000 		//		�                �
				//		������������������
};

USHORT LLURArrowsMask[] = {
	7,			// 		Horizontal hot spot
	7,			// 		Vertical hot spot
				//		����������������Ŀ
	0xFFFF,		//		������������������
	0xF801,		//		������          ��
	0xFC01,		//		�������         ��
	0xFE01,		//		��������        ��
	0xFF01,		//		���������       ��
	0xBF01,		//		�� ������       ��
	0x9E01,		//		��  ����        ��
	0x8C01,		//		��   ��         ��
	0x8031,		//		��         ��   ��
	0x8079,		//		��        ����  ��
	0x80FD,		//		��       ������ ��
	0x80FF,		//		��       ���������
	0x807F,		//		��        ��������
	0x803F,		//		��         �������
	0x801F,		//		��          ������
	0xFFFF,		//		������������������
				//		������������������
				//		����������������Ŀ
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x00FC,		//		�        ������  �
	0x007C,		//		�         �����  �
	0x003C,		//		�          ����  �
	0x007C,		//		�         �����  �
	0x00EC,		//		�        ��� ��  �
	0x01C4,		//		�       ���   �  �
	0x2380,		//		�  �   ���       �
	0x3700,		//		�  �� ���        �
	0x3E00,		//		�  �����         �
	0x3C00,		//		�  ����          �
	0x3E00,		//		�  �����         �
	0x3F00,		//		�  ������        �
	0x0000,		//		�                �
	0x0000 		//		�                �
				//		������������������
};

USHORT editMask[] = {
	7,			// 		Horizontal hot spot
	7,			// 		Vertical hot spot
				//		����������������Ŀ
	0xFFFF,		//		������������������
	0xFFFF,		//		������������������
	0xF18F,		//		�����   ��   �����
	0xFE7F,		//		��������  ��������
	0xFE7F,		//		��������  ��������
	0xFE7F,		//		��������  ��������
	0xFE7F,		//		��������  ��������
	0xFE7F,		//		��������  ��������
	0xFE7F,		//		��������  ��������
	0xFE7F,		//		��������  ��������
	0xFE7F,		//		��������  ��������
	0xFE7F,		//		��������  ��������
	0xFE7F,		//		��������  ��������
	0xF18F,		//		�����   ��   �����
	0xFFFF,		//		������������������
	0xFFFF,		//		������������������
				//		������������������
				//		����������������Ŀ
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0000 		//		�                �
				//		������������������
};

USHORT hourglassMask[] = {
	7,			// 		Horizontal hot spot
	7,			// 		Vertical hot spot
				//		����������������Ŀ
	0xC001,		//		���             ��
	0xC001,		//		���             ��
	0xC001,		//		���             ��
	0xC001,		//		���             ��
	0xE003,		//		����           ���
	0xF007,		//		�����         ����
	0xF80F,		//		������       �����
	0xFC1F,		//		�������     ������
	0xFC1F,		//		�������     ������
	0xF80F,		//		������       �����
	0xF007,		//		�����         ����
	0xE003,		//		����           ���
	0xC001,		//		���             ��
	0xC001,		//		���             ��
	0xC001,		//		���             ��
	0xC001,		//		���             ��
				//		������������������
				//		����������������Ŀ
	0x0000,		//		�                �
	0x0000,		//		�                �
	0x0FF8,		//		�    ���������   �
	0x0FF8,		//		�    ���������   �
	0x0550,		//		�     � � � �    �
	0x02A0,		//		�      � � �     �
	0x0140,		//		�       � �      �
	0x0080,		//		�        �       �
	0x0080,		//		�        �       �
	0x0140,		//		�       � �      �
	0x0360,		//		�      �� ��     �
	0x06B0,		//		�     �� � ��    �
	0x0D58,		//		�    �� � � ��   �
	0x0AA8,		//		�    � � � � �   �
	0x0000,		//		�                �
	0x0000 		//		�                �
				//		������������������
};

void far MouseISR(void)
{
	asm cli								// Disable interrupts.
	asm push ds
#if !defined(__HUGE__)
	asm mov ax, DGROUP
	asm mov ds, ax						// Get the proper value to DS.
#endif
	_mouseEvent.position.column = _CX;
	_mouseEvent.position.line = _DX;
	_BH = _BL;
	asm xor bh, _oldButtonState
	asm mov _oldButtonState, bl
	_mouseEvent.rawCode = (((_BH << 4) | _BL) << 8) | (*((UCHAR far *) 0x417L) & 0xF);
	_mouseEvent.type = E_MOUSE;
	_mouseEvent.position.column /= _mouseCellWidth;
	_mouseEvent.position.line /= _mouseCellHeight;
	if (_mouseEnabled && _eventManagerPtr)
		_eventManagerPtr->Put(_mouseEvent, Q_END);
	_mouseTime = *((long far *)0x46CL);
	if (UI_DEVICE::altPressed != ALT_NOT_PRESSED)
		UI_DEVICE::altPressed = ALT_PRESSED_AND_EVENTS_RECEIVED;
	asm pop ds
	asm sti
}

static int InstallHandler(void)
{
	_AX = 0;
	geninterrupt(0x33);
	if (_AX == -1)
	{
		void far *isrPtr;

		isrPtr = MouseISR;
		_CX = 0xFF;					// Enable all events.
		_DX = FP_OFF(isrPtr);
		_BX = FP_SEG(isrPtr);
		_ES = _BX;
		_AX = 12;					// Set Interrupt Subroutine call
		geninterrupt(0x33);
		return TRUE;
	}
	return FALSE;
}

UI_MS_MOUSE::UI_MS_MOUSE(USHORT initialState) :
	UI_DEVICE(E_MOUSE, initialState)
{
	UCHAR far * far *mouse_vec = (UCHAR far * far *) (4 * 0x33);

	installed = FALSE;
	_mouseEnabled = TRUE;
	graphicsCursorMask = arrowMask;
	textScreenMask = 0xFFFF;
	textCursorMask = 0xFF00;
	if (*mouse_vec && **mouse_vec != 0xCF)
	{
		_AX = 20;
		_BX = 0;
		_DX = 0;
		_CX = 0;
		geninterrupt(0x33);
		_oldMouseMask = _CX;
		_oldMouseISR.segment = _BX;
		_oldMouseISR.offset  = _DX;
		installed = InstallHandler();
	}
}

UI_MS_MOUSE::~UI_MS_MOUSE(void)
{
	// Uninstall the mouse.
	if (installed)
	{
		_CX = _oldMouseMask;
		_DX = _oldMouseISR.offset;
		_BX = _oldMouseISR.segment;
		_ES = _BX;
		_AX = 12;
		geninterrupt(0x33);
	}
}

int UI_MS_MOUSE::Event(const UI_EVENT &event)
{
	// Make sure the mouse is installed.
	if (!installed)
		return (0);

	display->MakeActive();				// Insure this is the active display.
	if (display->isText)
	{
		_mouseCellWidth  = 640 / display->columns;
		_mouseCellHeight = 8;
	}
	else
	{
		_mouseCellWidth  = 1;
		_mouseCellHeight = 1;
	}
	USHORT ccode = event.rawCode;
	int t_state = state;
	USHORT t_textCursorMask = textCursorMask;
	USHORT *t_graphicsCursorMask = graphicsCursorMask;

	// See if the mouse has been initialized.
	if (ccode == D_INITIALIZE)
	{
		_eventManagerPtr = eventManager;
		_DX = (display->columns - 1) * _mouseCellWidth;
		_CX = 0;
		_AX = 7;
		geninterrupt(0x33);	 // Set min. & max. horizontal cursor position.
		_DX = (display->lines - 1) * _mouseCellHeight;
		_CX = 0;
		_AX = 8;
		geninterrupt(0x33);	 // Set min. & max. horizontal cursor position.
		if (!display->isText)
		{
			if (display->isActiveDisplay && display->ActiveDisplayCode() == DC_MONOCHROME)
			{
				// Hercules graphics card.
				*((char far *)0x449L) = 6;
				InstallHandler();
			}
		}
		Display();
		ccode = state;
		t_state = D_OFF;
	}

	switch (ccode)
	{
	case D_HIDE:
		_AX = 11;
		geninterrupt(0x33);					// See if mouse is moving.
		if (_CX || _DX)
		{
			// Insure the mouse is turned off if it is moving.
			column = event.region.left * _mouseCellWidth;
			line = event.region.top * _mouseCellHeight;
		}
		else
		{
			_AX = 3;
			geninterrupt(0x33);				// Get the mouse position.
			column = _CX;
			line = _DX;
		}
		// Continue to D_SHOW.

	case D_SHOW:
		UI_REGION region;
		region.left = column;
		region.top = line;
		if (display->isText)
		{
			region.left /= _mouseCellWidth;
			region.top  /= _mouseCellHeight;
			region.right = region.left;
			region.bottom = region.top;
		}
		else
		{
			region.left -= graphicsCursorMask[0] + 8;
			region.top -= graphicsCursorMask[1]  + 4;
			region.right = region.left + 31;
			region.bottom = region.top + 23;
		}
 		if (max(event.region.left, region.left) > min(event.region.right, region.right) ||
			max(event.region.top, region.top) > min(event.region.bottom, region.bottom))
			return(0);
		state = (ccode == D_SHOW) ? D_ON : D_OFF;
		break;

	case D_OFF:
	case D_ON:
		_mouseEnabled = enabled = (event.rawCode == D_OFF) ? FALSE : TRUE;
		break;

	case DM_VIEW:
		graphicsCursorMask = arrowMask;
		textScreenMask = 0xFFFF;
		textCursorMask = 0xFF00;
		break;

	case DM_EDIT:
		graphicsCursorMask = editMask;
		textScreenMask = 0xFFFF;
		textCursorMask = 0xFF00;
		break;

	case DM_WAIT:
		graphicsCursorMask = hourglassMask;
		textScreenMask = 0xFFFF;
		textCursorMask = 0xFF00;
		break;

	case DM_MOVE:
		graphicsCursorMask = handMask;
		textScreenMask = 0xFFFF;
		textCursorMask = 0xFF00;
		break;

	case DM_HORIZONTAL:
		graphicsCursorMask = horizontalArrowsMask;
		textScreenMask = 0xFF00;
		textCursorMask = 0xFF1D;
		break;

	case DM_VERTICAL:
		graphicsCursorMask = verticalArrowsMask;
		textScreenMask = 0xFF00;
		textCursorMask = 0xFF12;
		break;

	case DM_DIAGONAL_ULLR:
		graphicsCursorMask = ULLRArrowsMask;
		textScreenMask = 0xFF00;
		textCursorMask = 0xFF04;
		break;

	case DM_DIAGONAL_LLUR:
		graphicsCursorMask = LLURArrowsMask;
		textScreenMask = 0xFF00;
		textCursorMask = 0xFF04;
		break;

	default:
		return(enabled ? D_ON : D_OFF);
	}

	// Change the mouse state.
	if ((display->isText && t_textCursorMask != textCursorMask) ||
		(!display->isText && t_graphicsCursorMask != graphicsCursorMask))
		Display();
	if (t_state != state)
	{
		_AX = (state != D_OFF) ? 1 : 2;
		geninterrupt(0x33);
	}

	// Return the device state.
	return (state);
}

void UI_MS_MOUSE::SetSensitivity(short horizontalSensitivity,
	short verticalSensitivity, short doubleSpeedThreshold)
{
	if (installed)
	{
		_BX = horizontalSensitivity;
		_CX = verticalSensitivity;
		_DX = doubleSpeedThreshold;
		_AX = 26;
		geninterrupt(0x33);
	}
}

void UI_MS_MOUSE::Display(void)
{
	if (!display)
		return;
	else if (display->isText)
	{
		_DX = textCursorMask;
		_CX = textScreenMask;
		_BX = 0;	 				// BX = 0 for software cursor.
		_AX = 10;
	}
	else
	{
		_DX = (USHORT) (graphicsCursorMask + 2);
		_CX = *(graphicsCursorMask + 1);
		_BX = *graphicsCursorMask;
		_ES = _DS;
		_AX = 9;					// Set Graphics Cursor call.
	}
	geninterrupt(0x33);
}

void UI_MS_MOUSE::Poll(void)
{
}
