//	Program name..	Zinc Interface Library
//	Filename......	NUMBER.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <mem.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ui_win.hpp"

int ValidNumChar(char val, int decimalPoint)
{
	if (isdigit(val) ||
		(decimalPoint == 0xFF && val == _countryInfo.co_desep[0]))
		return (TRUE);
	return (FALSE);
}

void FixNegative(char *buff, int credit)
{
	memmove(buff + 1, buff, strlen(buff) + 1);
	*buff = credit ? '(' : '-';
	if (credit)
		strcat(buff, ")");
}

void PlaceCommas(char *buff)
{
	char tempBuff[256];
	char *tempPtr = tempBuff;
	char *buffPtr = buff;
	int  digits;

	while (*buffPtr)
	{
		if (*buffPtr != _countryInfo.co_thsep[0])
			*tempPtr++ = *buffPtr;
		buffPtr++;
	}
	*tempPtr = '\0';
	tempPtr = strrchr(tempBuff, _countryInfo.co_desep[0]);
	if (!tempPtr)
		tempPtr = strchr(tempBuff, '\0');
	while (tempPtr > &tempBuff[0] && !isdigit(*(tempPtr - 1)))
		tempPtr--;
	digits = 0;
	while (tempPtr > &tempBuff[0] && isdigit(*(tempPtr - 1)))
	{
		digits++;
		tempPtr--;
		if (digits % 3 == 0 && tempPtr > &tempBuff[0] &&
			isdigit(*(tempPtr - 1)))
		{
			memmove(tempPtr + 1, tempPtr, strlen(tempPtr) + 1);
			*tempPtr = _countryInfo.co_thsep[0];
		}
	}
	tempPtr = strrchr(tempBuff, _countryInfo.co_desep[0]);
	if (tempPtr && _countryInfo.co_thsep[0] != ',')
	{
		tempPtr++;
		digits = 0;
		while (isdigit(*tempPtr))
		{
			digits++;
			tempPtr++;
			if ( digits % 3 == 0 && isdigit(*(tempPtr + 1)) )
			{
				memmove(tempPtr + 1, tempPtr, strlen(tempPtr) + 1);
				*tempPtr++ = _countryInfo.co_thsep[0];
			}
		}
	}
	strcpy(buff, tempBuff);
}

void PlaceDecimal(char *buff, int decimal)
{
	char tempBuff[256];
	char *tempPtr = tempBuff;
	char *buffPtr = buff;

	if (decimal != 0xFF)
	{
		while (*buffPtr)
		{
			if (*buffPtr != _countryInfo.co_desep[0])
				*tempPtr++ = *buffPtr;
			buffPtr++;
		}
		*tempPtr = '\0';
		if (decimal)
		{
			while (tempPtr > &tempBuff[0] && !isdigit(*(tempPtr - 1)))
				tempPtr--;
			while (tempPtr > &tempBuff[0] && decimal)
			{
				if (isdigit(*(tempPtr - 1)))
					decimal--;
				else if (*(tempPtr - 1) != _countryInfo.co_thsep[0])
					break;
				tempPtr--;
			}
			if (decimal || tempPtr == &tempBuff[0] ||
				(tempPtr > &tempBuff[0] && !isdigit(*(tempPtr - 1))))
			{
				memmove(tempPtr + decimal + 2, tempPtr, strlen(tempPtr) + 1);
				*tempPtr = '0';
				*(tempPtr + 1) = _countryInfo.co_desep[0];
				if (decimal)
					memset(tempPtr + 2, '0', decimal);
			}
			else
			{
				memmove(tempPtr + 1, tempPtr, strlen(tempPtr) + 1);
				*tempPtr = _countryInfo.co_desep[0];
			}
		}
		strcpy(buff, tempBuff);
	}
}

int NUM_STATE::operator == (NUM_STATE& rightOperand)
{
	return (memcmp(this, &rightOperand, sizeof(NUM_STATE)) == 0);
}

int NUM_STATE::operator != (NUM_STATE& rightOperand)
{
	return (memcmp(this, &rightOperand, sizeof(NUM_STATE)) != 0);
}
