//	Program name..	Zinc Interface Library
//	Filename......	NUMFVAL.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ui_win.hpp"

extern int ParseRange(char *buffer, int offset, char *minValue, char *maxValue, int decimalPlace, UCHAR numType);

static int IsZero(char *string)
{
	while (*string == '0')
		string++;
	if (*string == '.')
		string++;
	while (*string == '0')
		string++;
	if (*string == '\0' || *string == 'E')
		return (TRUE);
	else
		return (FALSE);
}

static int ExponentValue(char *string)
{
	if (IsZero(string))
		return 0;
	char *exp = strchr(string, 'E');
	return (exp ? atoi(exp + 1) : 0);
}

int UIW_NUMBER::ValidRealBetween(char *minValue, char *maxValue)
{
	int valNegative = IsZero(state.text) ? FALSE : state.isNegative;

	/* Check the sign */
	int minNegative = (minValue[0] == '-') ? TRUE : FALSE;
	int maxNegative = (maxValue[0] == '-') ? TRUE : FALSE;
	if (!minNegative && valNegative || maxNegative && !valNegative)
		return (FALSE);

	/* Check the exponent */
	int valExponent = ExponentValue(state.text);
	int minExponent = ExponentValue(minValue);
	int maxExponent = ExponentValue(maxValue);
	if ((valNegative && minNegative && minExponent && valExponent > minExponent) ||
		(!valNegative && !minNegative && minExponent && valExponent < minExponent) ||
		(valNegative && maxNegative && maxExponent && valExponent < maxExponent) ||
		(!valNegative && !maxNegative && maxExponent && valExponent > maxExponent))
		return (FALSE);

	/* Compare the raw numerical values */
	double val = atof(state.text);
	if (valNegative)
		val = -val;
	if (val >= atof(minValue) && val <= atof(maxValue))
		return (TRUE);

	/* The value does not fall within the minimum and maximum values */
	return (FALSE);
}

int UIW_NUMBER::ValidRealInRange(char *a_range)
{
	char minValue[20];
	char maxValue[20];
	int validNumber;
	int rangeLength;
	int offset;

	/* See if a range exists */
	if (!a_range || a_range[0] == '\0')
		return(TRUE);

	/* See if the value is in the specified range */
	validNumber = FALSE;
	offset = 0;
	rangeLength = (a_range) ? strlen(a_range) : 0;
	while (!validNumber && offset < rangeLength)
	{
		offset = ParseRange(a_range, offset, minValue, maxValue, decimal, type);
		validNumber = ValidRealBetween(minValue, maxValue);
	}
	return(validNumber);
}

int UIW_NUMBER::ValidRealNumber(void)
{
	char *absoluteRange;

	if (type == NUM_FLOAT)
		absoluteRange = "-3.4E38..-3.4E-38/0/3.4E-38..3.4E38";
	else
		absoluteRange = "-1.7E308..-1.7E-308/0/1.7E-308..1.7E308";
	if (range && !ValidRealInRange(range))
	{
		RangeError(range);
		return (FALSE);
	}
	else if (!ValidRealInRange(absoluteRange))
	{
		RangeError(absoluteRange);
		return (FALSE);
	}
	return (TRUE);
}


