//	Program name..	Zinc Interface Library
//	Filename......	NUMVALID.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ctype.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ui_win.hpp"

static void StripDecimal(char *buffer);

int ParseRange(char *buffer, int offset, char *minValue, char *maxValue,
	int decimalPlace, UCHAR numType)
{
	/* Get the minimum value */
	int position = 0;
	while (buffer[offset] != '\0' &&
		(buffer[offset] != '.' || buffer[offset+1] != '.') &&
		buffer[offset] != '/')
		minValue[position++] = buffer[offset++];
	minValue[position] = '\0';

	/* See if it is a standalone value */
	if (buffer[offset] == '/' || buffer[offset] == '\0')
	{
		strcpy(maxValue, minValue);
		return(++offset);
	}

	/* Increment the offset */
	while (buffer[offset] != '\0' &&
		buffer[offset] == '.')
		offset++;

	/* Get the maximum value */
	position = 0;
	while (buffer[offset] != '\0' &&
		buffer[offset] != '/')
		maxValue[position++] = buffer[offset++];
	maxValue[position] = '\0';
	if (decimalPlace && decimalPlace != 0xFF &&
		numType != NUM_FLOAT && numType != NUM_DOUBLE)
	{
		StripDecimal(minValue);
		StripDecimal(maxValue);
	}

	/* Return the offset */
	return(++offset);
}

static void StripDecimal(char *buffer)
{
	char *dpl = strchr(buffer, _countryInfo.co_desep[0]);
	if (dpl)
		memmove(dpl, dpl + 1, strlen(dpl));
}

void UIW_NUMBER::FormatNumericBuffer(char *buffer, UCHAR maximumLength)
{
	int i;
	char decimalPoint = _countryInfo.co_desep[0];

	/* Get the buffer length */
	int bufferLength = (buffer) ? strlen(buffer) : 0;
	if (bufferLength == 0)
	{
		strcpy(buffer, "0");
		bufferLength++;
	}

	/* Replace '.' with country specific decimal separator. */
	ui_strrepc(buffer, '.', decimalPoint);

	/* See if the buffer is free format */
	if (decimal == 0xFF || type == NUM_FLOAT || type == NUM_DOUBLE)
	{
		if (bufferLength >= maximumLength)
			bufferLength = maximumLength - 1;
		buffer[bufferLength] = '\0';
		return;
	}

	/* Remove the '-' sign */
	int negativeValue = (buffer[0] == '-') ? TRUE : FALSE;
	if (negativeValue)
		memmove(&buffer[0], &buffer[1], bufferLength--);

	/* Try to find a decimal point */
	int position = 0;
	while (position < bufferLength && buffer[position] != decimalPoint)
		position++;

	/* Insert the decimal point */
	if (decimal == 0)
		 bufferLength = position;
	else if (decimal != 0xFF && position == bufferLength)
	{
		/* Make sure the buffer is long enough */
		while (bufferLength <= decimal)
		{
			memmove(&buffer[1], &buffer[0], bufferLength++);
			buffer[0] = '0';
		}

		/* Insert the decimal */
		position = bufferLength - decimal;
		memmove(&buffer[position+1], &buffer[position],	bufferLength - position);
		buffer[position] = decimalPoint;
		bufferLength++;
	}
	else if (decimal != 0xFF)
	{
		/* Make sure the buffer is long enough */
		for (i = 1; i <= decimal; i++)
			if (position + i >= bufferLength)
				buffer[bufferLength++] = '0';

		/* Get the new buffer length */
		bufferLength = position + decimal + 1;
	}

	/* Insert the commas */
	if (nmFlags & NMF_COMMAS)
	{
		for (i = position - 3; i > 0; i = i - 3)
		{
			memmove(&buffer[i+1], &buffer[i], bufferLength - i);
			buffer[i] = _countryInfo.co_thsep[0];
			bufferLength++;
		}
	}

	/* Insert the currency symbol */
	if (nmFlags & NMF_CURRENCY)
	{
		i = (_countryInfo.co_curr) ? strlen(_countryInfo.co_curr) : 0;
		memmove(&buffer[i], &buffer[0], bufferLength);
		memmove(&buffer[0], _countryInfo.co_curr, i);
		bufferLength += i;
	}

	/* Insert the '%' sign */
	if (nmFlags & NMF_PERCENT)
		buffer[bufferLength++] = '%';

	/* Insert the '-', '(' and ')', or ' ' characters (for negative value) */
	if (negativeValue && (nmFlags & NMF_CREDIT))
	{
		memmove(&buffer[1], &buffer[0], bufferLength++);
		buffer[0] = '(';
		buffer[bufferLength++] = ')';
	}
	else if (negativeValue)
	{
		memmove(&buffer[1], &buffer[0], bufferLength++);
		buffer[0] = '-';
		if (buffer[bufferLength-1] != '%')
			buffer[bufferLength++] = ' ';
	}
	else if (buffer[bufferLength-1] != '%')
		buffer[bufferLength++] = ' ';

	/* Finish the buffer */
	if (bufferLength > maximumLength)
	{
		buffer[maximumLength-1] = (buffer[bufferLength-1] == ')') ? ')' : ' ';
		bufferLength = maximumLength;
	}
	buffer[bufferLength] = '\0';
	if (bufferLength && buffer[bufferLength - 1] == ' ')
		buffer[bufferLength - 1] = '\0';
}

int UIW_NUMBER::RangeError(char *a_range)
{
	/* Declaration of local variables */
	char formattedMin[40];
	char formattedMax[40];
	char formattedString[256];
	char tempString[256];
	static char throughString[] = "through";
	static char orString[] = "or";
	int position;
	int offset = 0;
	int count = 0;

	/* Set up the initial variables */
	int rangeLength = (a_range) ? strlen(a_range) : 0;
	char separator = ',';
	int cursorColumn;
	Expand(formattedString, &cursorColumn);
	strcat(formattedString, " is not valid.  The value must be in the range ");
	while (offset < rangeLength)
	{
		/* Format the current minimum and maximum values */
		if (count == 1)
		{
			if (!strcmp(formattedMin, formattedMax))
				strcpy(tempString, formattedMin);
			else
				sprintf(tempString, "%s %s %s", formattedMin, throughString,
					formattedMax);
			strcat(formattedString, tempString);
		}
		else if (count != 0)
		{
			if (!strcmp(formattedMin, formattedMax))
				sprintf(tempString, "%c %s", separator, formattedMin);
			else
				sprintf(tempString, "%c %s %s %s", separator,
					formattedMin, throughString, formattedMax);
			strcat(formattedString, tempString);
		}

		/* Get a new set of minimum and maximum values */
		count++;
		offset = ParseRange(a_range, offset, formattedMin, formattedMax, decimal, type);
		FormatNumericBuffer(formattedMin, sizeof(formattedMin));
		FormatNumericBuffer(formattedMax, sizeof(formattedMax));
	}

	/* Append the final minimum and maximum values on the string */
	if (count > 2 && !strcmp(formattedMin, formattedMax))
		sprintf(tempString, "%c %s %s.", separator, orString, formattedMin);
	else if (count > 2)
		sprintf(tempString, "%c %s %s %s %s.", separator, orString,
			formattedMin, throughString, formattedMax);
	else if (count == 2 && !strcmp(formattedMin, formattedMax))
		sprintf(tempString, " %s %s.", orString, formattedMin);
	else if (count == 2)
		sprintf(tempString, " %s %s %s %s.", orString, formattedMin,
			throughString, formattedMax);
	else if (count > 0)
		sprintf(tempString, "%s %s %s.", formattedMin, throughString,
			formattedMax);
	else
	{
		position = 0;		
		while (formattedString[position] != '\0' &&
			formattedString[position] != '.')
			position++;
		formattedString[++position] = '\0';
	}
	strcat(formattedString, tempString);
	_errorSystem->ReportError(windowManager,
		woFlags & (WOF_NO_UNANSWERED | WOF_NO_INVALID), "%s", formattedString);
	return (TRUE);
}

int UIW_NUMBER::ValidWholeBetween(char *minValue, char *maxValue)
{
	int minNegative;
	int maxNegative;
	int minLength;
	int maxLength;
	int	valLength;
	char *valPtr = state.text;
	int valNegative = state.isNegative;

	minNegative = (minValue[0] == '-') ? TRUE : FALSE;
	if (minNegative)
		*minValue++;
	maxNegative = (maxValue[0] == '-') ? TRUE : FALSE;
	if (maxNegative)
		*maxValue++;
	if (!minNegative && valNegative || maxNegative && !valNegative)
		return(FALSE);

	// Take out leading zeroes.
	while (*minValue == '0' && *(minValue + 1))
		minValue++;
	while (*maxValue == '0' && *(maxValue + 1))
		maxValue++;
	while (*valPtr == '0' && *(valPtr + 1))
		valPtr++;

	valLength = (valPtr) ? strlen(valPtr) : 0;
	minLength = (minValue) ? strlen(minValue) : 0;
	if ((!minNegative &&
		 !valNegative &&
		 (minLength > valLength ||
		  (minLength == valLength && strcmp(minValue, valPtr) > 0))) ||
		(minNegative &&
		 valNegative &&
		 (minLength < valLength ||
		  (minLength == valLength && strcmp(minValue, valPtr) < 0))))
		return(FALSE);

	/* Compare the value against the maximum */
	maxLength = (maxValue) ? strlen(maxValue) : 0;
	if ((!maxNegative &&
		 !valNegative &&
		 (maxLength < valLength ||
		  (maxLength == valLength && strcmp(maxValue, valPtr) < 0))) ||
		(maxNegative &&
		 valNegative &&
		 (maxLength > valLength ||
		  (maxLength == valLength && strcmp(maxValue, valPtr) > 0))))
		return(FALSE);

	/* The value falls within the minimum and maximum values */
	return(TRUE);
}

int UIW_NUMBER::ValidWholeInRange(
	char *a_range)
{
	/* See if a range exists */
	if (!a_range || a_range[0] == '\0')
		return(TRUE);

	/* See if the value is in the specified range */
	char minValue[20];
	char maxValue[20];
	int validNumber = FALSE;
	int offset = 0;
	int rangeLength = (a_range) ? strlen(a_range) : 0;
	while (!validNumber && offset < rangeLength)
	{
		offset = ParseRange(a_range, offset, minValue, maxValue, decimal, type);
		validNumber = ValidWholeBetween(minValue, maxValue);
	}
	return(validNumber);
}

int UIW_NUMBER::ValidWholeNumber(void)
{
	char *absoluteRange;

	switch (type)
	{
	case NUM_CHAR:
		absoluteRange = (FlagSet(nmFlags, NMF_UNSIGNED)) ?
			"0..255" : "-128..127";
		break;

	case NUM_SHORT:
		absoluteRange = (FlagSet(nmFlags, NMF_UNSIGNED)) ? 
			"0..65535" : "-32768..32767";
		break;

	case NUM_LONG:
		absoluteRange = (FlagSet(nmFlags, NMF_UNSIGNED)) ?
			"0..4294967295" : "-2147483648..2147483647";
		break;
	}

	if (range && !ValidWholeInRange(range))
	{
		RangeError(range);
		return (FALSE);
	}
	else if (!ValidWholeInRange(absoluteRange))
	{
		RangeError(absoluteRange);
		return (FALSE);
	}

	return (TRUE);
}
