//	Program name..	Zinc Interface Library
//	Filename......	PULLDOWN.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include "ui_win.hpp"

void UIW_PULL_DOWN_ITEM::PullDownUserFunction(void *button, UI_EVENT &event)
{
	((UIW_PULL_DOWN_ITEM *)button)->woStatus &= ~WOS_SELECTED;
	((UIW_PULL_DOWN_ITEM *)button)->UserFunction(event);
}

#pragma argsused
void UIW_PULL_DOWN_ITEM::UserFunction(UI_EVENT &event)
{
	if (!menu.First())
		return;

	for (UIW_POP_UP_ITEM *item = menu.First(); item; item = item->Next())
		item->woStatus &= ~WOS_CURRENT;

	menu.true.left = (!previous && !display->isText) ? true.left - 1 : true.left;
	menu.true.top = true.bottom + 1;
	menu.true.right = menu.true.bottom = 0x0FFF;
	if (display->isText)
		menu.woStatus &= ~WOS_GRAPHICS;
	else
		menu.woStatus |= WOS_GRAPHICS;
	*windowManager + &menu;
}

UIW_PULL_DOWN_ITEM::UIW_PULL_DOWN_ITEM(char *a_string, USHORT a_mnFlags,
	void (*a_userFunction)(void *object, UI_EVENT &event)) :
	UIW_BUTTON(0, 0, strlen(a_string), a_string,
		BTF_DOWN_CLICK | BTF_NO_TOGGLE, WOF_NON_FIELD_REGION,
		UIW_PULL_DOWN_ITEM::PullDownUserFunction),
	menu(0, 0, a_mnFlags | MNF_SELECT_LEFT | MNF_SELECT_RIGHT, WOF_BORDER,
		WOAF_TEMPORARY | WOAF_NO_DESTROY)
{
	// Initialize the menu item information.
	windowID[0] = ID_MENU_ITEM;
	windowID[1] = ID_BUTTON;
	woFlags &= ~WOF_BORDER;
	depth = 0;
	if (a_userFunction)
		userFunction = a_userFunction;
}

UIW_PULL_DOWN_ITEM::Event(const UI_EVENT &event)
{
	int ccode = event.type;
	switch (ccode)
	{
	case S_CREATE:
		menu.InformationSet(-screenID, display, eventManager, windowManager, 
			paletteMapTable, this);
		if (!menu.First())
			btFlags &= ~BTF_DOWN_CLICK;
		// Continue to default.

	default:
		ccode = UIW_BUTTON::Event(event);
		break;
	}

	// Return the event control code.
	return (ccode);
}

UIW_PULL_DOWN_MENU::UIW_PULL_DOWN_MENU(int a_indentation, USHORT a_woFlags,
	USHORT a_woAdvancedFlags) :
	UIW_WINDOW(0, 0, 1, 1, a_woFlags | WOF_NON_FIELD_REGION,
		a_woAdvancedFlags | WOAF_NORMAL_HOT_KEYS | WOAF_NO_SIZE | WOAF_NO_MOVE)
{
	// Initialize the pull-down menu information.
	windowID[0] = ID_MENU;
	windowID[1] = ID_WINDOW;
	hotKey = HOT_KEY_SUB_WINDOW;
	indentation = a_indentation;
}

UIW_PULL_DOWN_MENU::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	int ccode = UI_WINDOW_OBJECT::LogicalEvent(event, ID_MENU);
	UIW_PULL_DOWN_ITEM *item;
	switch (ccode)
	{
	case S_CREATE:
	case S_SIZE:
		if (display->isText)
			woFlags &= ~WOF_BORDER;
		else
			woFlags |= WOF_BORDER;
		woAdvancedStatus &= ~WOAS_INVALID_REGION;
		if (!parent)
		{
			true.left = true.top = 0;
			true.right = display->columns - 1;
			true.bottom = display->lines - 1;
		}
		else
		{
			UI_WINDOW_OBJECT::RegionMax(TRUE);
			if (true.bottom - true.top < display->cellHeight - 1)
			{
				woAdvancedStatus |= WOAS_INVALID_REGION;
				break;
			}
			if (!display->isText &&
				parent->true.left < true.left &&
				parent->true.right > true.right &&
				parent->true.top < true.top)
			{
				true.left--;
				true.top--;
				true.right++;
			}
		}

		int trueLeft = true.left;
		int trueTop = true.top;
		true.left += indentation * display->cellWidth;
		int bottom = true.top;
		for (item = First(); item; item = item->Next())
		{
			item->InformationSet(screenID, display, eventManager,
				windowManager, paletteMapTable, this);
			item->Event(event);
			item->true.right = item->true.left + item->relative.right;
			item->true.bottom = item->true.top + display->cellHeight - 1;
			if (item->true.bottom > true.bottom)
				item->woAdvancedStatus |= WOAS_INVALID_REGION;
			else if (!FlagSet(item->woAdvancedStatus, WOAS_INVALID_REGION))
				bottom = item->true.bottom;
			true.top = (display->isText) ? item->true.top : item->true.top - 1;
		}
		true.left = trueLeft;
		true.top = trueTop;
		true.bottom = (display->isText) ? bottom : bottom + 1;
 		UIW_WINDOW::RegionsCompute();
		break;

	case L_BEGIN_SELECT:
	case L_CONTINUE_SELECT:
		for (UIW_PULL_DOWN_ITEM *t_item = First(); t_item; t_item = t_item->Next())
			if (!FlagSet(t_item->woFlags, WOF_NON_SELECTABLE) &&
				t_item->Overlap(event.position))
				break;

		// See if it is a new current item.
		if (ccode == L_CONTINUE_SELECT && (!t_item ||
			t_item == (UIW_PULL_DOWN_ITEM *)windowList.Get(UIW_WINDOW::FindStatus, &WOS_CURRENT)))
			break;

		// Unhighlight the remaining items.
		UI_EVENT t_event;
		t_event.type = S_DISPLAY_ACTIVE;
		for (item = First(); item; item = item->Next())
			if (item != t_item && FlagSet(item->woStatus, WOS_SELECTED))
			{
				item->woStatus &= ~WOS_SELECTED;
				t_event.region = item->true;
				item->Event(t_event);
			}

		// Process the key.
		t_event = event;
		t_event.type = L_BEGIN_SELECT;
		ccode = UIW_WINDOW::Event(t_event);
		break;

	case L_ITEM_DOWN:
		item = (UIW_PULL_DOWN_ITEM *)windowList.Get(UIW_WINDOW::FindStatus, &WOS_CURRENT);
		if (!item || !item->menu.First())
			break;
		UI_EVENT tEvent = event;
		tEvent.type = L_SELECT;
		ccode = UIW_WINDOW::Event(tEvent);
		break;

	default:
		ccode = UIW_WINDOW::Event(event);
		break;
	}

	// Return the event control code.
	return (ccode);
}

