//	Program name..	Zinc Interface Library
//	Filename......	TITLE.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ctype.h>
#include <string.h>
#include "ui_win.hpp"

// Constructor & Destructor -------------------------------------------------

UIW_TITLE::UIW_TITLE(char *a_title, USHORT a_woFlags) :
	UI_WINDOW_OBJECT(0, 0, 0, 0,
		a_woFlags | WOF_BORDER | WOF_NON_FIELD_REGION, WOAF_NON_CURRENT)
{
	// Initialize the title information.
	windowID[0] = ID_TITLE;
	title = (FlagSet(a_woFlags, WOF_NO_ALLOCATE_DATA)) ?
		a_title : ui_strdup(a_title);
}

UIW_TITLE::~UIW_TITLE(void)
{
	// Destroy the title information.
	if (title && !FlagSet(woFlags, WOF_NO_ALLOCATE_DATA))
		delete title;
}

// Member functions ---------------------------------------------------------

void UIW_TITLE::DataSet(char *newTitle)
{
	// Reset the title information.
	if (newTitle)
	{
		if (FlagSet(woFlags, WOF_NO_ALLOCATE_DATA))
			title = newTitle;
		else
		{
			if (title)
				delete title;
			title = (newTitle) ? ui_strdup(newTitle) : 0;
		}
	}
	UI_WINDOW_OBJECT::Redisplay(TRUE);
}

int UIW_TITLE::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	int ccode = UI_WINDOW_OBJECT::LogicalEvent(event, ID_TITLE);
	switch (ccode)
	{
	case S_CREATE:
		{
		// Find the title's hotkey (if any).
		char *tHotKey = strchr(title, '~');
		if (tHotKey)
			parent->hotKey = toupper(tHotKey[1]);
		}
		// Continue to S_SIZE.

	case S_SIZE:
		if (display->isText)
		{
			int width = (parent && parent->hotKey) ? 
				strlen(title) - 1 : strlen(title);
			if (FlagSet(woFlags, WOF_BORDER))
				width += 2;
			true.top = true.bottom = parent->true.top;
			int count = 0;
			for (UI_WINDOW_OBJECT *object = (UI_WINDOW_OBJECT *)previous; 
				object; object = (UI_WINDOW_OBJECT *)object->previous)
				if (object->true.top == parent->true.top)
					count++;
			if (count > 1)
			{
				true.left = parent->true.left + 5;
				true.right = parent->true.right - 8;
			}
			else
			{
				true.left = parent->true.left + 1;
				true.right = parent->true.right - 1;
			}
			if (width < true.right - true.left)
			{
				if (FlagSet(woFlags, WOF_JUSTIFY_CENTER))
					true.left += (true.right - true.left - width + 1) / 2;
				else if (FlagSet(woFlags, WOF_JUSTIFY_RIGHT))
					true.left = true.right - width + 1;
				true.right = true.left + width - 1;
			}
		}
		else
		{
			int height;
			UI_WINDOW_OBJECT::Information(GET_DEFAULT_HEIGHT, &height);
			UI_WINDOW_OBJECT::RegionMax(TRUE);
			true.top -= 1;
			true.right += 1;
			true.left -= 1;
			true.bottom = true.top + height - 1;
		}
		break;

	case S_DISPLAY_ACTIVE:
	case S_DISPLAY_INACTIVE:
		// Display the title.
		if (display->isText || UI_WINDOW_OBJECT::NeedsUpdate(event, ccode))
		{
			lastPalette = UI_WINDOW_OBJECT::LogicalPalette(ccode);
			UI_WINDOW_OBJECT::Text(title, 0, ccode, lastPalette);
		}
		break;

	case L_VIEW:
	case L_BEGIN_SELECT:
		if (FlagSet(parent->woAdvancedFlags, WOAF_NO_MOVE))
			ccode = UI_WINDOW_OBJECT::Event(event);
		else if (UI_WINDOW_OBJECT::Overlap(event.position))
		{
			UI_EVENT tEvent = event;
			tEvent.rawCode = DM_MOVE;
			eventManager->Event(tEvent);
			if (ccode == L_BEGIN_SELECT)
			{
				tEvent.type = S_MOVE;
				eventManager->Put(tEvent, Q_BEGIN);
			}
		}
		break;

	default:
		// Default to the base class object.
		ccode = UI_WINDOW_OBJECT::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}

