//	Program name.. Calendar tutorial part 1
//	Filename...... CALENDR1.CPP
//	Version....... 1.0
//
//	COPYRIGHT (C) 1990.  All Rights Reserverd.
//	Zinc Software Incorported.  Pleasant Grove, Utha  USA

#include <string.h>
#include <graphics.h>
#include "ui_win.hpp"

class CALENDAR : public UIW_WINDOW
{
public:
	CALENDAR(int left, int top, int offset);
	virtual ~CALENDAR(void) {}

	virtual int Event(const UI_EVENT &event);

private:
	UI_DATE date;
	UIW_TITLE *title;
	UIW_TEXT *calendarText;
	int year;
	int month;
};

// Calendar logical events.
const int L_PREVIOUS_MONTH			= 10000;
const int L_NEXT_MONTH				= 10001;
const int L_CURRENT_MONTH			= 10002;

static char dayText[] = " 1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 \
16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31";

CALENDAR::CALENDAR(int centerX, int centerY, int offset) :
	UIW_WINDOW(centerX - 11, centerY - 4, 24, 9,
		WOF_NO_FLAGS, WOAF_NO_SIZE)
{
	// Get the current year and month.
	date.Export(&year, &month, 0, 0);

	// Create the window with new palette map table
	*this
		+ new UIW_BORDER
		+ (title = new UIW_TITLE("", WOF_JUSTIFY_CENTER))
		+ new UIW_STRING(0, 0, 24, "  S  M  T  W  T  F  S", 23,
			STF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE)
		+ (calendarText = new UIW_TEXT(0 + offset, 1,
			24 - offset, 7 - offset, "", 256, TXF_NO_FLAGS, WOF_VIEW_ONLY |
			WOF_NON_SELECTABLE | (WOF_BORDER * !offset)));

	// Initialize the current month's calendar.
	UI_EVENT event;
	event.type = L_CURRENT_MONTH;
	Event(event);
}

int CALENDAR::Event(const UI_EVENT &event)
{
	static char text[256];
	static char monthString[20];

	// Switch on the event type.
	int ccode = UI_WINDOW_OBJECT::LogicalEvent(event, ID_WINDOW);
	switch (ccode)
	{
	case L_CURRENT_MONTH:
		date.Import(year, month, 0);
		date.Export(monthString, 15, DTF_ALPHA_MONTH);
		date.Import(year, month, 1);
		int startingDay = date.DayOfWeek();
		strcpy(text, "                     ");
		strcpy(text + (startingDay - 1) * 3, dayText);
		text[(date.DaysInMonth() + startingDay - 1) * 3] = '\0';

		// Change the window data to reflect new month.
		title->DataSet(monthString);
		calendarText->DataSet(text, 256);
		break;

	default:
		// Call the window event to process other events.
		ccode = UIW_WINDOW::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}

main()
{
	// Initialize the display.
	UI_DISPLAY *display = new UI_DOS_BGI_DISPLAY();
	if (!display->installed)
	{
		delete display;
		display = new UI_DOS_TEXT_DISPLAY();
	}

	// Initialize the event and window managers.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(100, display);
	*eventManager + new UI_BIOS_KEYBOARD + new UI_MS_MOUSE + new UI_CURSOR;
	UI_WINDOW_MANAGER *windowManager =
		new UI_WINDOW_MANAGER(display, eventManager);

	// Create the calendar.
	int centerX = display->columns / display->cellWidth / 2;
	int centerY = display->lines / display->cellHeight / 2;
	int offset = (display->isText) ? 1 : 0;
	*windowManager + new CALENDAR(centerX, centerY, offset);

	// Process the events.
	int ccode;
	UI_EVENT event;
	do
	{
		eventManager->Get(event, Q_NORMAL);
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete windowManager;
	delete eventManager;
	delete display;
}
