//	Program name..	Zinc Interface Library
//	Filename......	D_APPS.CPP
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>
#include "d_demo.hpp"
#include "d_help.hlh"

// Definition of the calculator class.
class CALCULATOR : public UIW_WINDOW
{
public:
	CALCULATOR(int left, int top, char *title);

private:
	UIW_NUMBER *numberField;
	long operand1;
	long operand2;
	int operatorLast;
	UCHAR operation;

	static void ButtonFunction(void *button, UI_EVENT &event);
	void Display(UIW_BUTTON *button);
};

CALCULATOR::CALCULATOR(int left, int top, char *title) :
	UIW_WINDOW(left, top, 19, 10, WOF_NO_FLAGS, WOAF_NO_SIZE | WOAF_NORMAL_HOT_KEYS, INFO_CALCULATOR)
{
	// Initialize the calculator values.
	operand1 = 0L;
	operand2 = 0L;
	operatorLast = TRUE;
	operation = '=';

	// Create the number display field.
	numberField = new UIW_NUMBER(2, 1, 12, &operand2, NULL, NMF_COMMAS,
		WOF_BORDER | WOF_JUSTIFY_RIGHT | WOF_VIEW_ONLY | WOF_NO_ALLOCATE_DATA);

	// Add the buttons and other objects.
	*this
		+ new UIW_BORDER
		+ new UIW_MINIMIZE_BUTTON
		+ &(*new UIW_SYSTEM_BUTTON
			+ new UIW_POP_UP_ITEM("~Move", MNIF_MOVE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("Mi~nimize", MNIF_MINIMIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM
			+ new UIW_POP_UP_ITEM("~Close", MNIF_CLOSE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new HELP_PULL_DOWN_ITEM(" ~About the calculator ", MNF_NO_FLAGS, INFO_CALCULATOR))
		+ new UIW_TITLE(title, WOF_JUSTIFY_CENTER)
		+ numberField
		+ new UIW_BUTTON(1, 3, 4, "~7", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(5, 3, 4, "~8", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(9, 3, 4, "~9", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(13, 3, 4, "~/", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(1, 4, 4, "~4", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(5, 4, 4, "~5", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(9, 4, 4, "~6", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(13, 4, 4, "~-", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(1, 5, 4, "~1", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(5, 5, 4, "~2", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(9, 5, 4, "~3", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(13, 5, 4, "~*", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(1, 6, 4, "~C", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(5, 6, 4, "~0", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(9, 6, 4, "~=", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction)
		+ new UIW_BUTTON(13, 6, 4, "~+", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, CALCULATOR::ButtonFunction);
}

#pragma argsused
void CALCULATOR::ButtonFunction(void *button, UI_EVENT &event)
{
	CALCULATOR *calculator = (CALCULATOR *)((UIW_BUTTON *)button)->parent;
	calculator->Display((UIW_BUTTON *)button);
}

void CALCULATOR::Display(UIW_BUTTON *button)
{
	// Switch on the button value.
	switch (button->hotKey)
	{

	// Clear the calculator.
	case 'C' :
		operand1 =
			operand2 = 0L;
		operation = '=';
		break;

	// Operations.
	case '/' :
	case '*' :
	case '-' :
	case '+' :
	case '=' :
		if (operation != '=' && !operatorLast)
		{
			switch (operation)
			{
			case '/' :
				if (operand2 != 0L)
					operand2 = operand1 / operand2;
				else
					operand2 = 100000000L;
				break;

			case '*' :
				operand2 *= operand1;
				break;

			case '-' :
				operand2 = operand1 - operand2;
				break;

			case '+' :
				operand2 += operand1;
				break;

			}
			operand1 = 0L;
		}
		operatorLast = TRUE;
		operation = button->hotKey;
		break;

	// Digit pressed.
	default:
		if (operatorLast)
		{
			operatorLast = FALSE;
			operand1 = operand2;
			operand2 = 0L;
		}
		if (operand2 < 10000000L)
			operand2 = operand2 * 10 + button->hotKey - '0';
		break;
	}

	// Check for out of range numbers.
	if (operand2 >= 100000000L)
	{
		operand2 =
			operand1 = 0L;
		operation = '=';
	}

	// Update the displayed number.
	numberField->DataSet(NULL);
}

#pragma argsused
void Calculator(void *item, UI_EVENT &event)
{
	// Create the calculator in the screen center.
	int left = _display->columns / _display->cellWidth / 2 - 10;
	int top = _display->lines / _display->cellHeight / 2 - 5;
	*_windowManager + new CALCULATOR(left, top, "Zinc Calc");
}


