//	Program name..	Zinc Interface Library
//	Filename......	D_DEMO.CPP
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdlib.h>		// for abort()
#include <stdio.h>		// for printf()
#include <graphics.h>	// for bgi calls
#include <ui_win.hpp>
#include "d_demo.hpp"
#include "d_help.hlh"

UI_DISPLAY *_display = 0;
UI_EVENT_MANAGER *_eventManager = 0;
UI_WINDOW_MANAGER *_windowManager = 0;
TEXT_DISPLAY_MODE _currentMode = TDM_AUTO;
UIW_PULL_DOWN_MENU *_controlMenu;

static UI_LIST _deviceList;
static UI_LIST _objectList;

void InitializeSystem(TEXT_DISPLAY_MODE mode)
{
	// Initialize the screen display, trying for graphics mode first.
	// The graphics overlay files are linked into the application program.
	if (mode == TDM_AUTO)
	{
		int mode;
		int driver = DETECT;
		detectgraph(&driver, &mode);
		switch(driver)
		{
		case EGA:
		case EGAMONO:
		case VGA:
			registerbgidriver(EGAVGA_driver);
			break;

		case CGA:
			registerbgidriver(CGA_driver);
			break;

		case HERCMONO:
			registerbgidriver(Herc_driver);
			break;
		}
		_display = new UI_DOS_BGI_DISPLAY;
		if (!_display->installed)
		{
			delete _display;
			_display = 0;
		}
	}

	// Graphics mode failed.  Try for a specified text mode.
	if (!_display)
	{
		_display = new UI_DOS_TEXT_DISPLAY(mode);
		if (!_display->installed)
		{
			delete _display;
			_display = 0;
		}
	}

	// The specified text mode failed.  Get the default text mode.
	if (!_display)
	{
		mode = _currentMode;
		_display = new UI_DOS_TEXT_DISPLAY(mode);
	}

	// Reset the text mode.
	if (!_display->isText)
		_currentMode = TDM_AUTO;
	else if (_display->columns == 40)
		_currentMode = TDM_25x40;
	else if (_display->lines == 25)
		_currentMode = TDM_25x80;
	else
		_currentMode = TDM_43x80;

	// Initialize the event manager.
	_eventManager = new UI_EVENT_MANAGER(100, _display);
	UI_DEVICE *device, *tDevice;
	for (device = (UI_DEVICE *)_deviceList.last; device; device = tDevice)
	{
		tDevice = device->Previous();
		*_eventManager + device;
	}
	_deviceList.first = _deviceList.last = 0;

	// Initialize the window manager.
	_windowManager = new UI_WINDOW_MANAGER(_display, _eventManager);
	UI_WINDOW_OBJECT *object, *tObject;
	for (object = (UI_WINDOW_OBJECT *)_objectList.last; object; object = tObject)
	{
		tObject = object->Previous();
		*_windowManager + object;
	}
	_objectList.first = _objectList.last = 0;
}

void RestoreSystem(int finish)
{
	// Restore the window manager.
	if (!finish)
	{
		_objectList.first = _objectList.last = 0;
		for (UI_WINDOW_OBJECT *object = _windowManager->First(); object; 
			object = _windowManager->First())
		{
			*_windowManager - object;	// Order is important here.
			_objectList + object;
		}
	}
	delete _windowManager;
	_windowManager = 0;

	// Restore the event manager.
	if (!finish)
	{
		_deviceList.first = _deviceList.last = 0;
		for (UI_DEVICE *device = _eventManager->First(); device; 
			device = _eventManager->First())
		{
			*_eventManager - device;	// Order is important here.
			_deviceList + device;
		}
	}
	delete _eventManager;
	_eventManager = 0;

	// Restore the screen display.
	delete _display;
	_display = 0;
	_currentMode = TDM_AUTO;
}

void cdecl FreeStoreException(void)
{
	// The program failed on all attempts to get memory.
	printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nDEMO: Out of memory!\n");
	abort();
}

#pragma argsused
main(int argc, char *argv[])
{
	// Reset the free store exception handler.
	extern void (*_new_handler)();
	_new_handler  = FreeStoreException;

	// Initialize the Zinc Interface Library.
	_path = new UI_PATH(argv[0], TRUE);
	InitializeSystem(TDM_AUTO);
	*_eventManager + new UI_BIOS_KEYBOARD + new UI_MS_MOUSE + new UI_CURSOR;

	// Reset the default error and help systems.
	UI_ERROR_WINDOW_SYSTEM *errorSystem = new UI_ERROR_WINDOW_SYSTEM;
	_errorSystem = errorSystem;
	UI_HELP_WINDOW_SYSTEM *helpSystem = new UI_HELP_WINDOW_SYSTEM("d_help.hlp", _windowManager, HELP_GENERAL);
	_helpSystem = helpSystem;

	// Create the control menu.
	extern void InitializeControlMenu(void);
	InitializeControlMenu();

	// Display a general help message then process the events.
	_helpSystem->DisplayHelp(_windowManager, HELP_INTRO);
	int ccode;
	UI_EVENT event;
	do
	{
		// Get a new event.
		_eventManager->Get(event, Q_NORMAL);
		ccode = _windowManager->Event(event);
	} while (ccode != L_EXIT);

	// Restore the Zinc Interface Library, unlocking the control menu
	// so the window manager will clean it up.
	delete _errorSystem;
	delete _helpSystem;
	_controlMenu->woAdvancedFlags &= ~WOAF_LOCKED;
	RestoreSystem(TRUE);						  
	return (0);
}
