//	Program name..	Zinc Interface Library
//	Filename......	D_APPS.CPP
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dos.h>
#include <graphics.h>
#include <ui_win.hpp>
#include "d_demo.hpp"
#include "d_help.hlh"

const int IVORY = 0;
const int EBONY = 1;

// Color palette definitions for piano keys.
static UI_PALETTE ebonyPalette = { ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		SOLID_FILL, attrib(BLACK, BLACK), attrib(BW_BLACK, BW_BLACK),
		attrib(GS_BLACK, GS_BLACK) };

static UI_PALETTE ivoryPalette = { ' ', attrib(WHITE, WHITE), attrib(MONO_NORMAL, MONO_NORMAL),
		SOLID_FILL, attrib(WHITE, WHITE), attrib(BW_WHITE, BW_WHITE),
		attrib(GS_WHITE, GS_WHITE) };

class PIANO_KEY : public UIW_BUTTON
{
public:
	PIANO_KEY(int left, int a_ebony, char a_key, char a_note, int a_freq);

	virtual int Event(const UI_EVENT &event);

private:
	int ebony;
	char note;
	int freq;
	int oldScreenID;
};

PIANO_KEY::PIANO_KEY(int left, int a_ebony, char a_key, char a_note, int a_freq) :
	UIW_BUTTON(left, 2, 3 - a_ebony, "", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, 0)
{
	ebony = a_ebony;
	hotKey = a_key;
	note = a_note;
	freq = a_freq;

	// Lengthen buttons to look like piano keys.
	true.bottom = relative.bottom = 6 - 2 * ebony;
	woAdvancedFlags |= WOAF_HOT_REGION;
}

int PIANO_KEY::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	UI_REGION region = true;
	UI_PALETTE *palette;
	int ccode = UI_WINDOW_OBJECT::LogicalEvent(event, ID_BUTTON);
	switch (ccode)
	{
	case S_CREATE:
		oldScreenID = screenID;
	case S_MOVE:
	case S_SIZE:
		ccode = UI_WINDOW_OBJECT::Event(event);
 		nosound();
		break;

	case S_NON_CURRENT:
		btStatus &= ~BTS_DEPRESSED;
		palette = (ebony) ? &ebonyPalette : &ivoryPalette;
		UI_WINDOW_OBJECT::Text(string, depth, ccode, palette);
 		nosound();
		break;

	case S_DISPLAY_ACTIVE:
	case S_CURRENT:
	case S_DISPLAY_INACTIVE:
		if (ebony && ccode != S_DISPLAY_INACTIVE)
		{
			screenID = -2;
			UI_WINDOW_OBJECT::display->RegionDefine(screenID, region);
		}
		else
			screenID = oldScreenID;
		palette = (ebony) ? &ebonyPalette : &ivoryPalette;
		if (ccode == S_CURRENT || UI_WINDOW_OBJECT::NeedsUpdate(event, ccode))
			UI_WINDOW_OBJECT::Text(string, depth, ccode, palette);
		break;

	case L_BEGIN_SELECT:
	case L_CONTINUE_SELECT:
	case L_END_SELECT:
		woStatus |= WOS_CURRENT;
		if (!FlagSet(btStatus, BTS_DEPRESSED) && 
			UI_WINDOW_OBJECT::Overlap(event.position))
		{
			UI_WINDOW_OBJECT::Shadow(region, -depth);
			btStatus |= BTS_DEPRESSED;
			sound(freq);
		}
		else if (ccode == L_END_SELECT || (FlagSet(btStatus, BTS_DEPRESSED) &&
			!UI_WINDOW_OBJECT::Overlap(event.position)))
		{
			UI_WINDOW_OBJECT::Shadow(region, depth);
			btStatus &= ~BTS_DEPRESSED;
			nosound();
		}
		break;

	case L_SELECT:
		UI_WINDOW_OBJECT::Shadow(region, -depth);
		sound(freq);
		delay(100);
		region = true;
		UI_WINDOW_OBJECT::Shadow(region, depth);
		nosound();
		break;

	default:
		ccode = UI_WINDOW_OBJECT::Event(event);
		break;
	}
	return (ccode);
}

#pragma argsused
void Piano(void *item, UI_EVENT &event)
{
	extern void ExitButton(void *object, UI_EVENT &event);

	// Create a window in the screen center.
	int centerX = _display->columns / _display->cellWidth / 2;
	if (centerX < 25)
		centerX = 25;
	int centerY = _display->lines / _display->cellHeight / 2;
	UIW_WINDOW *window = new UIW_WINDOW(centerX - 25, centerY - 6, 49, 13, WOF_NO_FLAGS, WOAF_MODAL, INFO_PIANO);

	// Allow normal keys to be hot keys for piano. (normally <Alt key>)
	window->woAdvancedFlags |= WOAF_NORMAL_HOT_KEYS;

	// Add border, buttons, keys, etc. to window.
	*window
		+ new UIW_BORDER
		+ new UIW_MINIMIZE_BUTTON
		+ &(*new UIW_SYSTEM_BUTTON
			+ new UIW_POP_UP_ITEM("~Move", MNIF_MOVE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("Mi~nimize", MNIF_MINIMIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM
			+ new UIW_POP_UP_ITEM("~Close", MNIF_CLOSE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new HELP_PULL_DOWN_ITEM(" ~About the piano ", MNF_NO_FLAGS, INFO_PIANO))
		+ new UIW_TITLE("Beethoven (Modal Window)", WOF_JUSTIFY_CENTER)
		+ new UIW_PROMPT(2, 1, "  1  2     4  5  6     8  9     -  =  ", WOF_NO_FLAGS)
		+ new UIW_PROMPT(2, 7, "a  q  w  e  r  t  y  u  i  o  p  [  ]  ;  '", WOF_NO_FLAGS)
		+ new UIW_BUTTON(19, 9, 10, "Esc=Exit", BTF_NO_FLAGS, WOF_JUSTIFY_CENTER, ExitButton);
	*window
		+ new PIANO_KEY(1, IVORY, 'A', 'C', 131)
		+ new PIANO_KEY(4, IVORY, 'Q', 'D', 147)
		+ new PIANO_KEY(7, IVORY, 'W', 'E', 165)
		+ new PIANO_KEY(10, IVORY, 'E', 'F', 175)
		+ new PIANO_KEY(13, IVORY, 'R', 'G', 196);
	*window
		+ new PIANO_KEY(16, IVORY, 'T', 'A', 220)
		+ new PIANO_KEY(19, IVORY, 'Y', 'B', 247)
		+ new PIANO_KEY(22, IVORY, 'U', 'C', 262)
		+ new PIANO_KEY(25, IVORY, 'I', 'D', 294)
		+ new PIANO_KEY(28, IVORY, 'O', 'E', 329);
	*window
		+ new PIANO_KEY(31, IVORY, 'P', 'F', 349)
		+ new PIANO_KEY(34, IVORY, '[', 'G', 392)
		+ new PIANO_KEY(37, IVORY, ']', 'A', 440)
		+ new PIANO_KEY(40, IVORY, ';', 'B', 494)
		+ new PIANO_KEY(43, IVORY, '\'', 'C', 523);
	*window
		+ new PIANO_KEY(3, EBONY, '1', 'C', 139)
		+ new PIANO_KEY(6, EBONY, '2', 'D', 156)
		+ new PIANO_KEY(12, EBONY, '4', 'F', 185)
		+ new PIANO_KEY(15, EBONY, '5', 'G', 208)
		+ new PIANO_KEY(18, EBONY, '6', 'A', 233);
	*window
		+ new PIANO_KEY(24, EBONY, '8', 'C', 277)
		+ new PIANO_KEY(27, EBONY, '9', 'D', 311)
		+ new PIANO_KEY(33, EBONY, '-', 'F', 370)
		+ new PIANO_KEY(36, EBONY, '=', 'G', 415)
		+ new PIANO_KEY(39, EBONY, BACKSPACE, 'A', 466);

	// Add the window to the window manager.
	*_windowManager + window;
}

