//	Program name..	Extended graphics example.
//	Filename......	EXTGRAPH.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <graphics.h>
#include <ui_win.hpp>
#include "extgraph.hpp"

void EXTENDED_BGI_DISPLAY::Draw(int objectType, const UI_REGION &region, int screenID,
	UI_PALETTE *palette, int param1, int param2, int param3, int param4)
{
	UI_REGION tRegion;

	// Determine visible regions and draw graphics object.
	int hidden = FALSE;
	for (UI_REGION_ELEMENT *d_region = regionList.First(); d_region; d_region = d_region->Next())
		if (d_region->screenID == screenID && d_region->Overlap(region, tRegion))
		{
			if (!hidden && eventManager)
			{
				hidden = TRUE;
				eventManager->DevicesHide(region);
				setcolor(MapColor(palette, TRUE));
				setfillstyle(palette->fillPattern, MapColor(palette, FALSE));
			}
			setviewport(tRegion.left, tRegion.top, tRegion.right, tRegion.bottom, TRUE);

			// Draw graphics object on the display.
			switch (objectType)
			{
			case LINE:
				line(region.left - tRegion.left,
					region.top + param2 - tRegion.top,
					region.left + param1 - tRegion.left,
					region.top + param3 - tRegion.top);
				break;

			case ELLIPSE:
				ellipse(region.left + param3 - tRegion.left,
					region.top + param4 - tRegion.top, param1,
					param2, param3, param4);
				break;

			case SECTOR:
				sector(region.left + param3 - tRegion.left,
					region.top + param4 - tRegion.top, param1,
					param2, param3, param4);
				break;

			case BAR3D:
				bar3d(region.left - tRegion.left,
					region.top + param3 - tRegion.top,
					region.left + param1 - tRegion.left,
					region.top + param2 + param3 - tRegion.top,
					param3, param4);
				break;
			}
		}

	// Show the screen devices.
	if (hidden && eventManager)
		eventManager->DevicesShow(region);
}

int WO_GRAPHIC::Event(const UI_EVENT &event)
{
	int ccode = MapEvent(eventMapTable, event, ID_WINDOW_OBJECT);
	switch (ccode)
	{
	// Set visibleRegion to true coordinates of graphics object.
	case S_CREATE:
	case S_SIZE:
		ccode = UI_WINDOW_OBJECT::Event(event);
		visibleRegion = true;
		true.left = true.right = true.top = true.bottom = 0;
		break;

	case S_MOVE:
		visibleRegion.left += event.position.column;
		visibleRegion.top += event.position.line;
		visibleRegion.right += event.position.column;
		visibleRegion.bottom += event.position.line;
		break;

	// Display object.
	case S_CURRENT:
	case S_NON_CURRENT:
	case S_DISPLAY_ACTIVE:
	case S_DISPLAY_INACTIVE:
		((EXTENDED_BGI_DISPLAY *)display)->Draw(objectType, visibleRegion, screenID, palette, param1,
			param2, param3, param4);
		break;
	}

	// Return the control code.
	return (ccode);
}

WO_GRAPHIC::WO_GRAPHIC(int a_objectType, UI_PALETTE *a_palette, int a_param1,
	int a_param2, int a_param3, int a_param4)
	: UI_WINDOW_OBJECT(0, 0, 0, 0, WOF_BORDER, WOAF_NO_FLAGS)
{
	woStatus = WOS_GRAPHICS;
	objectType = a_objectType;
	palette = a_palette;
	param1 = a_param1;
	param2 = a_param2;
	param3 = a_param3;
	param4 = a_param4;
}

WO_LINE::WO_LINE(int x1, int y1, int x2, int y2, UI_PALETTE *palette)
	: WO_GRAPHIC(LINE, palette, x2 - x1, y1 - y2, y2 - y1)
{
	// Set Window Object region relative to parent window.
	relative.left = x1;
	relative.right = x2;
	relative.top = min(y1, y2);
	relative.bottom = max(y1, y2);

	// Determine if line is to be drawn from top to bottom.
	if (param2 < 0)
		param2 = 0;
	else
		param3 = 0;
}

WO_ELLIPSE::WO_ELLIPSE(int x, int y, int stAngle, int endAngle, int xRadius,
	int yRadius, UI_PALETTE *palette)
	: WO_GRAPHIC(ELLIPSE, palette, stAngle, endAngle, xRadius, yRadius)
{
	// Set Window Object region relative to parent window.
	relative.left = x - xRadius;
	relative.right = x + xRadius;
	relative.top = y - yRadius;
	relative.bottom = y + yRadius;
}

WO_SECTOR::WO_SECTOR(int x, int y, int stAngle, int endAngle, int xRadius,
	int yRadius, UI_PALETTE *palette)
	: WO_GRAPHIC(SECTOR, palette, stAngle, endAngle, xRadius, yRadius)
{
	// Set Window Object region relative to parent window.
	relative.left = x - xRadius;
	relative.right = x + xRadius;
	relative.top = y - yRadius;
	relative.bottom = y + yRadius;
}

WO_BAR3D::WO_BAR3D(int left, int top, int right, int bottom, int depth,
	int topFlag, UI_PALETTE *palette)
	: WO_GRAPHIC(BAR3D, palette, right - left, bottom - top, depth,
		topFlag)
{
	// Set Window Object region relative to parent window.
	relative.left = left;
	relative.right = right + depth;
	relative.top = top - depth;
	relative.bottom = bottom;
}
