//	Program name..	Example demonstrating the UI_BIOS_KEYBOARD class object.
//	Filename......	XBIOSKEY.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <graphics.h>	// Include file for palette colors.
#include <stdio.h>		// Include file for string operations.
#include <ui_map.hpp>

// Palette definition for text.
static UI_PALETTE palette = { ' ', attrib(WHITE, RED),
	attrib(MONO_NORMAL, MONO_BLACK), SOLID_FILL, attrib(WHITE, RED),
	attrib(BW_WHITE, BW_BLACK), attrib(GS_GRAY, GS_BLACK) };

main()
{
	char text[40];
	UI_EVENT event;

	// Initialize the display and event manager.
	UI_DOS_TEXT_DISPLAY *display = new UI_DOS_TEXT_DISPLAY;
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(100, display);

	// Turn the cursor off.
	*eventManager + new UI_CURSOR(D_OFF);

	// Construct the keyboard device.
	UI_BIOS_KEYBOARD *keyboard = new UI_BIOS_KEYBOARD;

	// Different ways to add/delete the keyboard device to/from the device
	// list.  Both of the pairs below do the same thing.
	*eventManager + keyboard;			// Add the keyboard device.
	*eventManager - keyboard;			// Remove the keyboard device.

	eventManager->Add(keyboard);		// Add the keyboard device.
	eventManager->Subtract(keyboard);	// Remove the keyboard device.

	*eventManager + keyboard;			// Add back in to continue.

	// Get events from the keyboard until the <Esc> key is pressed.
	do
	{
		// Get input from the user.
		eventManager->Get(event, Q_NORMAL);

		// Print the keyboard scan code on the screen.
		sprintf(text, " Key scan code = %4x ", event.rawCode);
		display->Text(ID_SCREEN, 0, 0, text, &palette);

		// Print the key shift state on the screen.
		sprintf(text, " Key shift state  = %x ", event.key.shiftState);
		display->Text(ID_SCREEN, 0, 1, text, &palette);

		// Print the key ascii value on the screen.
		sprintf(text, " Key ascii value  = %c ", event.key.value);
		display->Text(ID_SCREEN, 0, 2, text, &palette);

	} while (event.type != E_KEY || event.rawCode != ESCAPE);

	// Change the state of the keyboard device through the event manager.
	// The first two sets below do the same thing in different ways.  The
	// third turns all devices in the device list off and on. 
	eventManager->DeviceState(E_KEY, D_OFF);	// Turn the keyboard off.
	eventManager->DeviceState(E_KEY, D_ON);		// Turn the keyboard on.

	event.type = E_KEY;
	event.rawCode = D_OFF;
	eventManager->Event(event);			// Turn the keyboard off.
	event.rawCode = D_ON;
	eventManager->Event(event);			// Turn the keyboard on.

	event.type = E_DEVICE;
	event.rawCode = D_OFF;
	eventManager->Event(event);			// Turn all defined devices off.
	event.rawCode = D_ON;
	eventManager->Event(event);			// Turn all defined devices on.

	// The event manager and displays destructors are called manually.  The
	// keyboard device's descructor is automatically called from the event
	// manager.  We could have written this as:
	//		*eventManager - keyboard;
	//		delete keyboard;
	//		delete eventManager;
	delete eventManager;
	delete display;
}
