//	Program name..	Example demonstrating the UI_ELEMENT class object.
//	Filename......	XELEMENT.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


// This program requires a graphics display. For another example of 
// using elements see XLIST.CPP.

#include <graphics.h>	// include file for BGI routines
#include <ui_evt.hpp>

class GRAPHICS_OBJECT : public UI_ELEMENT
{
public:
	virtual void Draw(void) { }
};

class CIRCLE : public GRAPHICS_OBJECT
{
public:
	CIRCLE(int a_column, int a_line, int a_radius) : column(a_column),
		line(a_line), radius(a_radius) { }
	~CIRCLE(void) { }
	void Draw(void) { circle(column, line, radius); }

private:
	int column;
	int line;
	int radius;
};

class RECTANGLE : public GRAPHICS_OBJECT
{
public:
	RECTANGLE(int a_left, int a_top, int a_right, int a_bottom) :
		left(a_left), top(a_top), right(a_right), bottom(a_bottom) { }
	~RECTANGLE(void) { }
	void Draw(void) { rectangle(left, top, right, bottom); }

private:
	int left;
	int right;
	int top;
	int bottom;
};

class LINE : public GRAPHICS_OBJECT
{
public:
	LINE(int a_left, int a_top, int a_right, int a_bottom) : left(a_left),
		top(a_top), right(a_right), bottom(a_bottom) { }
	~LINE(void) { }
	void Draw(void) { line(left, top, right, bottom); }

private:
	int left;
	int top;
	int right;
	int bottom;
};

main()
{
	// Initialize the graphics display class.
	UI_DOS_BGI_DISPLAY display;
	if (!display.installed)
		return(0);

	// Initialize the event manager.
	UI_EVENT_MANAGER eventManager(100, &display);
	eventManager + new UI_BIOS_KEYBOARD;

	// Add a circle, rectangle, and line objects to the list.
	int centerX = display.columns / 2;
	int centerY = display.lines / 2;
	UI_LIST list;
	list
		+ new CIRCLE(centerX - 60, centerY - 60, 50)								// Add a circle
		+ new RECTANGLE(centerX - 50, centerY - 50, centerX + 50, centerY + 50)	// Add a box
		+ new LINE(centerX - 30, centerY + 80, centerX + 80, centerY - 30);		// Add a line

	// Draw each of the objects in the list.
	setcolor(WHITE);
	for (UI_ELEMENT *object = list.first; object; object = object->next)
		((GRAPHICS_OBJECT *)object)->Draw();

	// Wait for user response.
	UI_EVENT event;
	do
	{
		eventManager.Get(event, Q_NORMAL);
	} while (event.type != E_KEY);
}
