//	Program name..	Example demonstrating the UI_MS_MOUSE class object.
//	Filename......	XMSMOUSE.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <graphics.h>
#include <ui_map.hpp>

static UI_PALETTE palette[] = {

	{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
	SOLID_FILL, attrib(BLACK, BLACK),
	attrib(BW_BLACK, BW_BLACK),	attrib(GS_BLACK, GS_BLACK) },

	{ ' ', attrib(BLUE, BLUE), attrib(MONO_BLACK, MONO_BLACK),
	SOLID_FILL, attrib(BLUE, BLUE),
	attrib(BW_BLACK, BW_BLACK),	attrib(GS_BLACK, GS_BLACK) },

	{ ' ', attrib(GREEN, GREEN), attrib(MONO_BLACK, MONO_BLACK),
	SOLID_FILL, attrib(GREEN, GREEN),
	attrib(BW_BLACK, BW_BLACK),	attrib(GS_BLACK, GS_BLACK) },

	{ ' ', attrib(CYAN, CYAN), attrib(MONO_BLACK, MONO_BLACK),
	SOLID_FILL, attrib(CYAN, CYAN),
	attrib(BW_BLACK, BW_BLACK),	attrib(GS_BLACK, GS_BLACK) },

	{ ' ', attrib(RED, RED), attrib(MONO_DIM, MONO_DIM),
	SOLID_FILL, attrib(RED, RED),
	attrib(BW_BLACK, BW_BLACK),	attrib(GS_BLACK, GS_BLACK) },

	{ ' ', attrib(MAGENTA, MAGENTA), attrib(MONO_DIM, MONO_DIM),
	SOLID_FILL, attrib(MAGENTA, MAGENTA),
	attrib(BW_BLACK, BW_BLACK),	attrib(GS_GRAY, GS_GRAY) },

	{ ' ', attrib(BROWN, BROWN), attrib(MONO_DIM, MONO_DIM),
	SOLID_FILL, attrib(BROWN, BROWN),
	attrib(BW_BLACK, BW_BLACK),	attrib(GS_GRAY, GS_GRAY) },

	{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_DIM, MONO_DIM),
	SOLID_FILL, attrib(LIGHTGRAY, LIGHTGRAY),
	attrib(BW_BLACK, BW_BLACK),	attrib(GS_GRAY, GS_GRAY) },

	{ ' ', attrib(DARKGRAY, DARKGRAY), attrib(MONO_NORMAL, MONO_NORMAL),
	SOLID_FILL, attrib(DARKGRAY, DARKGRAY),
	attrib(BW_BLACK, BW_BLACK),	attrib(GS_GRAY, GS_GRAY) },

	{ ' ', attrib(LIGHTBLUE, LIGHTBLUE), attrib(MONO_NORMAL, MONO_NORMAL),
	SOLID_FILL, attrib(LIGHTBLUE, LIGHTBLUE),
	attrib(BW_BLACK, BW_BLACK),	attrib(GS_GRAY, GS_GRAY) },

	{ ' ', attrib(LIGHTGREEN, LIGHTGREEN), attrib(MONO_NORMAL, MONO_NORMAL),
	SOLID_FILL, attrib(LIGHTGREEN, LIGHTGREEN),
	attrib(BW_WHITE, BW_WHITE), attrib(GS_WHITE, GS_WHITE) },

	{ ' ', attrib(LIGHTCYAN, LIGHTCYAN), attrib(MONO_NORMAL, MONO_NORMAL),
	SOLID_FILL, attrib(LIGHTCYAN, LIGHTCYAN),
	attrib(BW_WHITE, BW_WHITE), attrib(GS_WHITE, GS_WHITE) },

	{ ' ', attrib(LIGHTRED, LIGHTRED), attrib(MONO_HIGH, MONO_HIGH),
	SOLID_FILL, attrib(LIGHTRED, LIGHTRED),
	attrib(BW_WHITE, BW_WHITE), attrib(GS_WHITE, GS_WHITE) },

	{ ' ', attrib(LIGHTMAGENTA, LIGHTMAGENTA), attrib(MONO_HIGH, MONO_HIGH),
	SOLID_FILL, attrib(LIGHTMAGENTA, LIGHTMAGENTA),
	attrib(BW_WHITE, BW_WHITE), attrib(GS_WHITE, GS_WHITE) },

	{ ' ', attrib(YELLOW, YELLOW), attrib(MONO_HIGH, MONO_HIGH),
	SOLID_FILL, attrib(YELLOW, YELLOW),
	attrib(BW_WHITE, BW_WHITE), attrib(GS_WHITE, GS_WHITE) },

	{ ' ', attrib(WHITE, WHITE), attrib(MONO_HIGH, MONO_HIGH),
	SOLID_FILL, attrib(WHITE, WHITE),
	attrib(BW_WHITE, BW_WHITE), attrib(GS_WHITE, GS_WHITE) } };

main()
{
	// Initialize the display, trying for graphics first.
	UI_DISPLAY *display = new UI_DOS_BGI_DISPLAY;
	if (!display->installed)
	{
		delete display;
		display = new UI_DOS_TEXT_DISPLAY;
	}

	// Initialize the event and window managers.
	UI_EVENT_MANAGER eventManager(100, display);
	eventManager + new UI_BIOS_KEYBOARD + new UI_MS_MOUSE + new UI_CURSOR;

	// Add the color palette to the screen.
	UI_REGION region;
	int leftBorder = display->lines / 16;
	if (display->isText)
		leftBorder *= 2;
	region.left = 0;
	region.right = leftBorder;
	for (int i = 0; i < 16; i++)
	{
		region.top = i * leftBorder;
		region.bottom = region.top + leftBorder;
		display->Fill(ID_SCREEN, region, &palette[i]);
	}

	// Get events from the keyboard until the <Esc> key is pressed.
	UI_EVENT event;
	UI_REGION position;
	int brushSize = (display->isText) ? 0 : 6;
	int color = 15;
	do
	{
		eventManager.Get(event, Q_NORMAL);

		// Change brush size (pressing keys 1 - 9).
		if (event.type == E_KEY && event.key.value > '0' &&
			event.key.value <= '9')
			brushSize = event.key.value - '0' - 1;

		// Check if the event is a mouse.
		if (event.type == E_MOUSE &&
			FlagSet(event.rawCode, M_LEFT | M_RIGHT))
		{
			// Change colors if on the screen palette.
			if (event.position.column <= leftBorder)
			{
				color = event.position.line / leftBorder;
				if (color > 15)
					color = 15;
			}
			else
			{
				position.left = event.position.column;
				position.right = position.left + brushSize;
				position.top = event.position.line;
				position.bottom = position.top + brushSize;

				// Draw the color on the screen (left button).
				if (FlagSet(event.rawCode, M_LEFT))
					display->Fill(ID_SCREEN, position, &palette[color]);

				// Erase with the mouse (right button).
				else
					display->Fill(ID_SCREEN, position, _backgroundPalette);
			}
		}
	} while (event.type != L_EXIT &&
		(event.type != E_KEY || event.rawCode != ESCAPE));

	// Clean up.
	delete display;
}
