//	Program name..	Example demonstrating the UI_DOS_TEXT_DISPLAY class object.
//	Filename......	XTXTDISP.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <graphics.h>
#include <ui_evt.hpp>

static UI_PALETTE barPalette = { '\261', attrib(YELLOW, RED),
	attrib(MONO_BLACK, MONO_NORMAL), SOLID_FILL, attrib(YELLOW, RED),
	attrib(BW_BLACK, BW_WHITE), attrib(GS_BLACK, GS_WHITE) };

main()
{
	// Initialize the graphics display class.
	UI_DOS_TEXT_DISPLAY *display = new UI_DOS_TEXT_DISPLAY;
	if (!display->installed)
		return(0);

	// Initialize the event manager and add three devices to it.
	UI_EVENT_MANAGER eventManager(100, display);
	eventManager + new UI_BIOS_KEYBOARD + new UI_CURSOR;
	
	// Set up a region for the bar graph.
	UI_REGION graph;
	graph.left = 10;
	graph.right = display->columns - 10;
	graph.top = 2;
	graph.bottom = display->lines - 2;

	// Define the region so that other calls will not overwrite this region.
	display->RegionDefine(-2, graph);  // Screen ID is negative for user defined regions.

	// XOR a rectangle around the bar graph.
	display->RectangleXOR(graph);

	// Display the bar graph.
	UI_REGION bar;
	bar.bottom = graph.bottom - 4;
	int count = 4;
	for (int i = graph.left + 3; i < graph.right - 5; i += 7)
	{
		bar.top = bar.bottom - count + 3;
		bar.left = i;
		bar.right = i + 4;
		display->Fill(-2, bar, &barPalette);
		count *= 1.3;
	}

	// Display the graph titles.
	char text1[] = " 1990 Sales ";
	char text2[] = " JAN    FEB    MAR    APR    MAY    JUN    JUL    AUG ";
	int top = graph.top + 2;
	int left = (display->columns - display->TextWidth(text1)) / 2;
	display->Text(-2, left, top, text1, &barPalette, -1, TRUE);
	top = graph.bottom - 2;
	left = graph.left + 3;
	display->Text(-2, left, top, text2, &barPalette, -1, TRUE);

	// Wait for user response (pressing any key).
	UI_EVENT event;
	do
	{
		eventManager.Get(event, Q_NORMAL);
	} while (event.type != E_KEY);

	// Clean up. 
	delete display;
}
