//	Program name..	Example demonstrating the UI_WINDOW_MANAGER class object.
//	Filename......	XWINMGR.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>

main()
{
	// Initialize the display, trying for graphics first.
	UI_DISPLAY *display = new UI_DOS_BGI_DISPLAY;
	if (!display->installed)
	{
		delete display;
		display = new UI_DOS_TEXT_DISPLAY;
	}

	// Initialize the event manager.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(100, display);
	*eventManager + new UI_BIOS_KEYBOARD + new UI_MS_MOUSE + new UI_CURSOR;

	// Initialize the window manager.
	UI_WINDOW_MANAGER *windowManager =
		new UI_WINDOW_MANAGER(display, eventManager);

	// Create both notepads.
	UIW_WINDOW *notepad1 = new UIW_WINDOW(4, 5, 66, 12,
		WOF_NO_FLAGS, WOAF_NO_FLAGS);

	UIW_WINDOW *notepad2 = new UIW_WINDOW(9, 10, 65, 12,
		WOF_NO_FLAGS, WOAF_NO_FLAGS);

	// Add window objects to notepad1.
	*notepad1
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("Notepad 1", WOF_JUSTIFY_CENTER)

		+ new UIW_PROMPT(2, 1, "To:", WOF_NO_FLAGS)
		+ new UIW_STRING(6, 1, 15, "Everyone", 40, STF_NO_FLAGS,
			WOF_BORDER)

		+ new UIW_PROMPT(28, 1, "Date:", WOF_NO_FLAGS)
		+ new UIW_DATE(35, 1, 20, &UI_DATE(), "",
			DTF_SYSTEM | DTF_ALPHA_MONTH, WOF_BORDER, NO_HELP_CONTEXT)

		+ new UIW_PROMPT(2, 2, "Message:", WOF_NO_FLAGS)
		+ new UIW_TEXT(2, 3, 60, 4, "", 1028, TXF_NO_FLAGS, WOF_BORDER);

	// Add window objects to notepad2.
	*notepad2
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("Notepad 2", WOF_JUSTIFY_CENTER)

		+ new UIW_PROMPT(2, 1, "To:", WOF_NO_FLAGS)
		+ new UIW_STRING(6, 1, 15, "Everyone", 40, STF_NO_FLAGS,
			WOF_BORDER)

		+ new UIW_PROMPT(28, 1, "Date:", WOF_NO_FLAGS)
		+ new UIW_DATE(35, 1, 20, &UI_DATE(), "",
			DTF_SYSTEM | DTF_ALPHA_MONTH, WOF_BORDER)

		+ new UIW_PROMPT(2, 2, "Message:", WOF_NO_FLAGS)
		+ new UIW_TEXT(2, 3, 60, 4, "", 1028, TXF_NO_FLAGS, WOF_BORDER);

	// Add notepads to the window manager.
	*windowManager + notepad1 + notepad2;

	// Wait for user response.
	int ccode;
	UI_EVENT event;
	do
	{
		eventManager->Get(event, Q_NORMAL);
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
 	delete windowManager;
	delete eventManager;
	delete display;
}
