//	Program name..	Example demonstrating the UIW_STRING class object.
//	Filename......	XWMISC.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <graphics.h>
#include <ui_win.hpp>

static USHORT zincBitmap1[] =
{
	32, 32,
	0xFFFF, 0xFFFF, 	0xFFFF, 0xFFFE, 	0xFFFF, 0xFFFC,		0xFFFF, 0xFFF8,
	0xFFFF, 0xFFF0, 	0xFFFF, 0xFFE0, 	0xFFFF, 0xFFC0,		0xFFFF, 0xFF80,
	0xFFFF, 0xFF00, 	0xFFFF, 0xFE00, 	0xFFFF, 0xFC00,		0xFFFF, 0xF800,
	0xFFFF, 0xF000, 	0xFFFF, 0xE000, 	0xFFFF, 0xC000,		0xFFFF, 0x8000,
	0xFFFF, 0x0000,		0xFFFE, 0x0000, 	0xFFFC, 0x0000,		0xFFF8, 0x0000,
	0xFFF0, 0x0000, 	0xFFE0, 0x0000, 	0xFFC0, 0x0000,		0xFF80, 0x0000,
	0xFF00, 0x0000, 	0xFE00, 0x0000, 	0xFC00, 0x0000,		0xF800, 0x0000,
	0xF000, 0x0000, 	0xE000, 0x0000, 	0xC000, 0x0000,		0x8000, 0x0000
};
static USHORT zincBitmap2[] =
{
	32, 32,
	0x0000, 0x0001, 	0x0000, 0x0003, 	0x0000, 0x0007, 	0x0000, 0x000F,
	0x0000, 0x001F, 	0x0000, 0x003F, 	0x0000, 0x007F, 	0x0000, 0x00FF,
	0x0000, 0x01FF, 	0x0000, 0x03FF,		0x0000, 0x07FF, 	0x0000, 0x0FFF,
	0x0000, 0x1FFF, 	0x0000, 0x3FFF, 	0x0000, 0x7FFF, 	0x0000, 0xFFFF,
	0x0001, 0xFFFF, 	0x0003, 0xFFFF, 	0x0007, 0xFFFF,		0x000F, 0xFFFF,
	0x001F, 0xFFFF, 	0x003F, 0xFFFF, 	0x007F, 0xFFFF, 	0x00FF, 0xFFFF,
	0x01FF, 0xFFFF, 	0x03FF, 0xFFFF,		0x07FF, 0xFFFF, 	0x0FFF, 0xFFFF,
	0x1FFF, 0xFFFF, 	0x3FFF, 0xFFFF, 	0x7FFF, 0xFFFF, 	0xFFFF, 0xFFFF
};
static USHORT zincBitmap3[] =
{
	32, 32,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0003, 0xC000, 	0x0007, 0xC000, 	0x000F, 0xF000,
	0x000F, 0xF000, 	0x0007, 0xC000, 	0x0003, 0xC000,		0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000
};
static USHORT zincBitmap4[] =
{
	32, 32,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0003, 0xC000, 	0x0000, 0x8000,
	0x0001, 0x0000, 	0x0003, 0xC000, 	0x0000, 0x0000,		0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000
};

USHORT *zincBitmaps[] = { zincBitmap1, zincBitmap2, zincBitmap3, zincBitmap4, 0 };

UI_PALETTE zincPalettes[] =
{
	{
		'\260', attrib(DARKGRAY, DARKGRAY), attrib(MONO_DIM, MONO_BLACK),
			INTERLEAVE_FILL, attrib(DARKGRAY, DARKGRAY), attrib(BW_WHITE, BW_WHITE),
			attrib(GS_GRAY, GS_GRAY)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
			INTERLEAVE_FILL, attrib(BLACK, BLACK), attrib(BW_WHITE, BW_WHITE),
			attrib(GS_GRAY, GS_GRAY)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
			INTERLEAVE_FILL, attrib(BLACK, BLACK), attrib(BW_WHITE, BW_WHITE),
			attrib(GS_GRAY, GS_GRAY)
	},
	{
		'\260', attrib(YELLOW, YELLOW), attrib(MONO_DIM, MONO_BLACK),
			INTERLEAVE_FILL, attrib(YELLOW, YELLOW), attrib(BW_WHITE, BW_WHITE),
			attrib(GS_GRAY, GS_GRAY)
	}
};

// Button validate procedure for OK button.
static void OKButton(void *object, UI_EVENT &event)
{
	// Put an L_EXIT message on the event queue to exit the program.
	event.type = L_EXIT;
	((UIW_BUTTON *)object)->eventManager->Put(event, Q_BEGIN);
}

static UIW_WINDOW *SampleObjects(UIW_WINDOW *window)
{
	long value = 0L;
	UI_DATE date("Jan. 1, 1990");

	UIW_WINDOW *popup = new UIW_WINDOW(-20,1,40,10,WOF_NO_FLAGS,WOAF_NO_FLAGS);

	*popup
		+ new UIW_BORDER
		+ new UIW_TITLE("Salary Sub-Window", WOF_JUSTIFY_CENTER)

		+ new UIW_PROMPT(2, 1, "Starting Date....", WOF_NO_FLAGS)
		+ new UIW_DATE(20, 1, 15, &date, "", DTF_ALPHA_MONTH, WOF_BORDER)

		+ new UIW_PROMPT(2, 2, "Starting Salary..", WOF_NO_FLAGS)
		+ new UIW_NUMBER(20, 2, 15, &value, "",
			NMF_CURRENCY | NMF_DECIMAL(2), WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 3, "Current Salary...", WOF_NO_FLAGS)
		+ new UIW_NUMBER(20, 3, 15, &value, "",
			NMF_CURRENCY | NMF_DECIMAL(2), WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 4, "Comments...", WOF_NO_FLAGS)
		+ new UIW_TEXT(14, 4, 23, 3, "Hourly Wages", 1024, TXF_NO_FLAGS, WOF_BORDER);

	*window
		+ new UIW_TITLE("Employee Information", WOF_JUSTIFY_CENTER)

		+ new UIW_PROMPT(8, 1, "Name.....", WOF_NO_FLAGS)
		+ new UIW_STRING(20, 1, 25, "Joe Programmer", 64, STF_NO_FLAGS, WOF_BORDER)

		+ new UIW_PROMPT(8, 2, "Address..", WOF_NO_FLAGS)
		+ new UIW_STRING(20, 2, 25, "405 South 100 East  Suite 201", 64, STF_NO_FLAGS, WOF_BORDER)
		+ new UIW_STRING(20, 3, 25, "Pleasant Grove, UT", 64, STF_NO_FLAGS, WOF_BORDER)

		+ new UIW_PROMPT(8, 5, "Salary Info......", WOF_NO_FLAGS)
		+ new UIW_POP_UP_WINDOW(28, 5, 15, "See Sub-Window", popup,BTF_NO_FLAGS, WOF_NO_FLAGS)

		+ new UIW_ICON(2, 1, zincBitmaps , zincPalettes, ICF_NO_FLAGS, WOF_NO_FLAGS)

		+ new UIW_BUTTON(20, 7, 10, "OK", BTF_NO_FLAGS, WOF_JUSTIFY_CENTER, OKButton);

	return (window);
}

main()
{
	// Check and initialize the display to graphics (or text if no graphics).
	UI_DISPLAY *display = new UI_DOS_BGI_DISPLAY();
	if (!display->installed)
	{
		delete display;
		display = new UI_DOS_TEXT_DISPLAY();
	}

	// Initialize the event and screen managers.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(100, display);
	*eventManager
		+ new UI_BIOS_KEYBOARD
		+ new UI_MS_MOUSE
		+ new UI_CURSOR;

	UI_WINDOW_MANAGER *windowManager =
		new UI_WINDOW_MANAGER(display, eventManager);

	// Create a window in the screen center with text inside.
	int centerX = display->columns / display->cellWidth / 2;
	int centerY = display->lines / display->cellHeight / 2;
	UIW_WINDOW *window = new UIW_WINDOW(centerX - 25, centerY - 6, 50, 12, WOF_NO_FLAGS, WOAF_NO_FLAGS);
	*window
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ &(*new UIW_SYSTEM_BUTTON
			+ new UIW_POP_UP_ITEM("~Restore", MNIF_RESTORE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("~Move", MNIF_MOVE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("~Size", MNIF_SIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("Mi~nimize", MNIF_MINIMIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("Ma~ximize", MNIF_MAXIMIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM
			+ new UIW_POP_UP_ITEM("~Close", MNIF_CLOSE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0));
	SampleObjects(window);
	*windowManager + window;

	/* Process the events */
	int ccode;
	UI_EVENT event;
	do
	{
		/* Get a new event */
		eventManager->Get(event, Q_NORMAL);
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete windowManager;
	delete eventManager;
	delete display;
}
