//	Program name..	Example demonstrating the UIW_NUMBER class object.
//	Filename......	XWNUMBER.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>

static UIW_WINDOW *SampleNumbers(UIW_WINDOW *window)
{
	int ivalue = 1000;
	int cvalue = -1000;
	*window
		+ new UIW_TITLE(" Sample numbers ", WOF_JUSTIFY_CENTER)

		+ new UIW_TEXT(43, 1, 20, 6,
			"All edited numbers should be in the range 0..10,000",
			128, TXF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE | WOF_BORDER)

		+ new UIW_PROMPT(2, 1, "Standard...........", WOF_NO_FLAGS)
		+ new UIW_NUMBER(22, 1, 20, &ivalue, "0..10000",
			NMF_NO_FLAGS, WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 2, "Currency...........", WOF_NO_FLAGS)
		+ new UIW_NUMBER(22, 2, 20, &ivalue, "0..10000",
			NMF_CURRENCY | NMF_DECIMAL(2), WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 3, "Commas.............", WOF_NO_FLAGS)
		+ new UIW_NUMBER(22, 3, 20, &ivalue, "0..10000",
			NMF_COMMAS, WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 4, "Fixed decimal (2)..", WOF_NO_FLAGS)
		+ new UIW_NUMBER(22, 4, 20, &ivalue, "0..10000",
			NMF_DECIMAL(2), WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 5, "Percent............", WOF_NO_FLAGS)
		+ new UIW_NUMBER(22, 5, 20, &ivalue, "0..10000",
			NMF_PERCENT, WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 6, "Credit.............", WOF_NO_FLAGS)
		+ new UIW_NUMBER(22, 6, 20, &cvalue, "-10000..10000",
			NMF_CREDIT, WOF_BORDER | WOF_AUTO_CLEAR);


	return (window);
}

void Exit(void *item, UI_EVENT &event)
{
	event.type = L_EXIT;
	((UIW_POP_UP_ITEM *)item)->eventManager->Put(event, Q_BEGIN);
}

main()
{
	// Check and initialize the display to graphics (or text if no graphics).
	UI_DISPLAY *display = new UI_DOS_BGI_DISPLAY();
	if (!display->installed)
	{
		delete display;
		display = new UI_DOS_TEXT_DISPLAY();
	}

	// Initialize the event and screen managers.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(100, display);
	*eventManager
		+ new UI_BIOS_KEYBOARD
		+ new UI_MS_MOUSE
		+ new UI_CURSOR;

	UI_WINDOW_MANAGER *windowManager =
		new UI_WINDOW_MANAGER(display, eventManager);

	// Initialize the error system.
	_errorSystem = new UI_ERROR_WINDOW_SYSTEM;

	// Create a window in the screen center with text inside.
	int centerX = display->columns / display->cellWidth / 2;
	int centerY = display->lines / display->cellHeight / 2;
	UIW_WINDOW *window = new UIW_WINDOW(centerX - 34, centerY - 6, 67, 11, WOF_NO_FLAGS, WOAF_NO_FLAGS);
	*window
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ &(*new UIW_SYSTEM_BUTTON
			+ new UIW_POP_UP_ITEM("~Restore", MNIF_RESTORE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("~Move", MNIF_MOVE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("~Size", MNIF_SIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("Mi~nimize", MNIF_MINIMIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM("Ma~ximize", MNIF_MAXIMIZE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0)
			+ new UIW_POP_UP_ITEM
			+ new UIW_POP_UP_ITEM("~Close", MNIF_CLOSE, BTF_NO_TOGGLE, WOF_NO_FLAGS, 0));
	SampleNumbers(window);
	*windowManager + window;

	/* Process the events */
	int ccode;
	UI_EVENT event;
	do
	{
		/* Get a new event */
		eventManager->Get(event, Q_NORMAL);
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete _errorSystem;
	delete windowManager;
	delete eventManager;
	delete display;
}
